/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.SelectionHighlighters;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.i18n.Resources;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionHighlighter
extends AbstractConfigurable
implements Highlighter {
    public static final String NAME = "name";
    public static final String MATCH = "match";
    public static final String COLOR = "color";
    public static final String THICKNESS = "thickness";
    public static final String USE_IMAGE = "useImage";
    public static final String IMAGE = "image";
    public static final String X_OFFSET = "xoffset";
    public static final String Y_OFFSET = "yoffset";
    protected PropertyExpression matchProperties = new PropertyExpression();
    protected Color color = Color.RED;
    protected int thickness = 3;
    protected boolean useImage = false;
    protected String imageName = "";
    protected int x = 0;
    protected int y = 0;
    protected VisibilityCondition visibilityCondition;
    @Deprecated
    protected Image image;
    protected ScaledImagePainter imagePainter = new ScaledImagePainter();

    @Override
    public void draw(GamePiece gamePiece, Graphics graphics, int n, int n2, Component component, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.accept(gamePiece)) {
            if (this.useImage) {
                int n3 = n - (int)((double)this.imagePainter.getImageSize().width * d / 2.0);
                int n4 = n2 - (int)((double)this.imagePainter.getImageSize().height * d / 2.0);
                this.imagePainter.draw(graphics, n3, n4, d, component);
            } else {
                if (this.color == null || this.thickness <= 0) {
                    return;
                }
                Shape shape = gamePiece.getShape();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(new BasicStroke(Math.max(1L, Math.round(d * (double)this.thickness))));
                graphics2D.setColor(this.color);
                AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
                affineTransform.translate((double)n / d, (double)n2 / d);
                graphics2D.draw(affineTransform.createTransformedShape(shape));
                graphics2D.setStroke(stroke);
            }
        }
    }

    @Override
    public Rectangle boundingBox(GamePiece gamePiece) {
        Rectangle rectangle = gamePiece.getShape().getBounds();
        if (this.accept(gamePiece)) {
            if (this.useImage) {
                rectangle.add(ImageUtils.getBounds(this.imagePainter.getImageSize()));
            } else {
                rectangle.translate(-this.thickness, -this.thickness);
                rectangle.setSize(rectangle.width + 2 * this.thickness, rectangle.height + 2 * this.thickness);
            }
        }
        return rectangle;
    }

    protected boolean accept(GamePiece gamePiece) {
        return this.matchProperties.isNull() ? true : this.matchProperties.accept(gamePiece);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.SelectionHighlight.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.SelectionHighlight.active_property"), Resources.getString("Editor.SelectionHighlight.use_image"), Resources.getString("Editor.SelectionHighlight.border_color"), Resources.getString("Editor.SelectionHighlight.border_thickness"), Resources.getString("Editor.SelectionHighlight.image"), Resources.getString("Editor.SelectionHighlight.offset_x"), Resources.getString("Editor.SelectionHighlight.offset_y")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, PropertyExpression.class, Boolean.class, Color.class, Integer.class, IconConfig.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, MATCH, USE_IMAGE, COLOR, THICKNESS, IMAGE, X_OFFSET, Y_OFFSET};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLOR.equals(string) || THICKNESS.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return !SelectionHighlighter.this.useImage;
                }
            };
        }
        if (IMAGE.equals(string) || X_OFFSET.equals(string) || Y_OFFSET.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SelectionHighlighter.this.useImage;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (string.equals(NAME)) {
            this.setConfigureName((String)object);
        } else if (string.equals(MATCH)) {
            this.matchProperties.setExpression((String)object);
        } else if (string.equals(USE_IMAGE)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.useImage = (Boolean)object;
        } else if (string.equals(COLOR)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            if (object != null) {
                this.color = (Color)object;
            }
        } else if (string.equals(THICKNESS)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.thickness = (Integer)object;
        } else if (string.equals(IMAGE)) {
            this.imageName = (String)object;
            this.imagePainter.setImageName(this.imageName);
        } else {
            if (string.equals(X_OFFSET)) {
                if (object instanceof String) {
                    object = Integer.valueOf((String)object);
                }
                try {
                    this.x = (Integer)object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalBuildException(numberFormatException);
                }
            }
            if (string.equals(Y_OFFSET)) {
                if (object instanceof String) {
                    object = Integer.valueOf((String)object);
                }
                try {
                    this.y = (Integer)object;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalBuildException(numberFormatException);
                }
            }
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (string.equals(NAME)) {
            return this.getConfigureName();
        }
        if (string.equals(MATCH)) {
            return this.matchProperties.getExpression();
        }
        if (string.equals(USE_IMAGE)) {
            return String.valueOf(this.useImage);
        }
        if (string.equals(COLOR)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (string.equals(THICKNESS)) {
            return String.valueOf(this.thickness);
        }
        if (string.equals(IMAGE)) {
            return this.imageName;
        }
        if (string.equals(X_OFFSET)) {
            return String.valueOf(this.x);
        }
        if (string.equals(Y_OFFSET)) {
            return String.valueOf(this.y);
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((SelectionHighlighters)buildable).removeHighlighter(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "SelectionHighlighter");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable buildable) {
        ((SelectionHighlighters)buildable).addHighlighter(this);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((SelectionHighlighter)autoConfigurable).imageName);
        }
    }
}

