/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ServerAddressBook;
import VASSAL.chat.ui.BasicChatControlsInitializer;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.RoomTree;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.VisibilityOption;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.menu.MenuManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class ChatServerControls
extends AbstractBuildable {
    protected RoomTree currentRoom;
    protected JTextField newRoom;
    protected JLabel newRoomLabel;
    protected JToolBar toolbar;
    protected RoomTree roomTree;
    protected JButton newRoomButton;
    protected JButton launch;
    protected ChatServerConnection client;
    protected JPanel controlPanel;
    protected ComponentSplitter.SplitPane splitter;
    protected ChatControlsInitializer oldClient;
    protected BasicChatControlsInitializer basicControls;
    protected JButton configServerButton;
    protected String configServerText;

    public ChatServerControls() {
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setResizeWeight(0.5);
        JPanel jPanel = new JPanel(new MigLayout("fill, nogrid, hidemode 3"));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), Resources.getString("Chat.active_games")));
        this.newRoom = new JTextField(12);
        this.newRoomLabel = new JLabel(Resources.getString("Chat.new_game"));
        this.newRoomLabel.setLabelFor(this.newRoom);
        jPanel.add((Component)this.newRoomLabel, "");
        jPanel.add((Component)this.newRoom, "growx, pushx");
        this.newRoomButton = new JButton("...");
        this.newRoomButton.setPreferredSize(new Dimension(20, 20));
        this.newRoomButton.setVisible(false);
        jPanel.add((Component)this.newRoomButton, "hidemode 3");
        this.roomTree = new RoomTree();
        JScrollPane jScrollPane = new JScrollPane(this.roomTree);
        jPanel.add((Component)jScrollPane, "newline, spanx, grow, push");
        jSplitPane.setLeftComponent(jPanel);
        this.currentRoom = new RoomTree();
        this.currentRoom.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                throw new ExpandVetoException(treeExpansionEvent);
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        JScrollPane jScrollPane2 = new JScrollPane(this.currentRoom);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), Resources.getString("Chat.current_game")));
        jSplitPane.setRightComponent(jScrollPane2);
        jSplitPane.setDividerLocation(160);
        jSplitPane.setPreferredSize(new Dimension(320, 120));
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BorderLayout());
        this.controlPanel.add("Center", jSplitPane);
        this.toolbar = new JToolBar();
        this.controlPanel.add("North", this.toolbar);
        this.toolbar.addSeparator();
        this.configServerButton = new JButton();
        this.configServerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerAddressBook.editCurrentServer(!ChatServerControls.this.client.isConnected());
            }
        });
        this.configServerButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!ChatServerControls.this.client.isConnected() && mouseEvent.isMetaDown()) {
                    ChatServerControls.this.showChangeServerMenu();
                }
            }
        });
        this.toolbar.add(this.configServerButton);
    }

    private void showChangeServerMenu() {
        ServerAddressBook.changeServerPopup(this.configServerButton);
    }

    public void updateClientDisplay(Icon icon, String string) {
        this.configServerButton.setIcon(icon);
        this.configServerText = string;
        this.updateConfigServerToolTipText();
    }

    private void updateConfigServerToolTipText() {
        if (this.client.isConnected()) {
            this.configServerButton.setToolTipText(this.configServerText);
        } else {
            this.configServerButton.setToolTipText("<html><center>" + this.configServerText + "<br>Right-click to change server");
        }
    }

    public Component getExtendedControls() {
        return null;
    }

    public void addTo(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        this.setClient((ChatServerConnection)gameModule.getServer());
        this.launch = new JButton(Resources.getString("Chat.server"));
        this.launch.setAlignmentY(0.0f);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatServerControls.this.toggleVisible();
            }
        };
        this.launch.addActionListener(actionListener);
        final NamedKeyStrokeListener namedKeyStrokeListener = new NamedKeyStrokeListener(actionListener);
        namedKeyStrokeListener.setKeyStroke(NamedKeyStroke.getNamedKeyStroke(83, 8));
        URL uRL = this.getClass().getResource("/images/connect.gif");
        if (uRL != null) {
            this.launch.setIcon(new ImageIcon(uRL));
            this.launch.setText(null);
        }
        final IconConfigurer iconConfigurer = new IconConfigurer("serverControlsIcon", Resources.getString("Chat.server_controls_button_icon"), "/images/connect.gif");
        iconConfigurer.setValue("/images/connect.gif");
        GlobalOptions.getInstance().addOption(iconConfigurer);
        iconConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChatServerControls.this.launch.setIcon(iconConfigurer.getIconValue());
            }
        });
        iconConfigurer.fireUpdate();
        final NamedHotKeyConfigurer namedHotKeyConfigurer = new NamedHotKeyConfigurer("serverControlsHotKey", Resources.getString("Chat.server_controls_hotkey"), namedKeyStrokeListener.getNamedKeyStroke());
        GlobalOptions.getInstance().addOption(namedHotKeyConfigurer);
        namedHotKeyConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                namedKeyStrokeListener.setKeyStroke(namedHotKeyConfigurer.getValueNamedKeyStroke());
                ChatServerControls.this.launch.setToolTipText(Resources.getString("Chat.server_controls_tooltip", NamedHotKeyConfigurer.getString(namedKeyStrokeListener.getKeyStroke())));
            }
        });
        namedHotKeyConfigurer.fireUpdate();
        gameModule.addKeyStrokeListener(namedKeyStrokeListener);
        gameModule.getToolBar().add(this.launch);
    }

    public void toggleVisible() {
        if (this.controlPanel.getTopLevelAncestor() == null) {
            if (GlobalOptions.getInstance().isUseSingleWindow()) {
                this.splitter = new ComponentSplitter().splitRight(GameModule.getGameModule().getControlPanel(), this.controlPanel, false);
                this.splitter.revalidate();
                Runnable runnable = new Runnable(){

                    public void run() {
                        ChatServerControls.this.splitter.showComponent();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            } else {
                JFrame jFrame = new JFrame(Resources.getString("Chat.server"));
                jFrame.setDefaultCloseOperation(1);
                jFrame.add(this.controlPanel);
                jFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(jFrame));
                VisibilityOption visibilityOption = new VisibilityOption("BoundsOfClientWindow", jFrame);
                GameModule.getGameModule().getPrefs().addOption(visibilityOption);
                jFrame.setVisible(true);
            }
        } else if (this.splitter != null) {
            this.splitter.toggleVisibility();
        } else {
            this.controlPanel.getTopLevelAncestor().setVisible(!this.controlPanel.getTopLevelAncestor().isVisible());
        }
    }

    public JPanel getControls() {
        return this.controlPanel;
    }

    public void setClient(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
        if (chatServerConnection instanceof ChatControlsInitializer) {
            if (this.basicControls != null) {
                this.basicControls.uninitializeControls(this);
            }
            if (this.oldClient != null) {
                this.oldClient.uninitializeControls(this);
            }
            this.basicControls = new BasicChatControlsInitializer(chatServerConnection);
            this.basicControls.initializeControls(this);
            ((ChatControlsInitializer)((Object)chatServerConnection)).initializeControls(this);
            this.oldClient = (ChatControlsInitializer)((Object)chatServerConnection);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        ChatServerControls.this.roomTree.setRooms((Room[])propertyChangeEvent.getNewValue());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        this.client.addPropertyChangeListener("AvailableRooms", propertyChangeListener);
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (propertyChangeEvent.getNewValue() == null) {
                            ChatServerControls.this.currentRoom.setRooms(new Room[0]);
                        } else {
                            ChatServerControls.this.currentRoom.setRooms(new Room[]{(Room)propertyChangeEvent.getNewValue()});
                            Object object = ChatServerControls.this.currentRoom.getModel().getRoot();
                            Object object2 = ChatServerControls.this.currentRoom.getModel().getChild(object, 0);
                            ChatServerControls.this.currentRoom.expandPath(new TreePath(new Object[]{object, object2}));
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        this.client.addPropertyChangeListener("Room", propertyChangeListener2);
        this.client.addPropertyChangeListener("Connected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChatServerControls.this.updateConfigServerToolTipText();
            }
        });
    }

    public ChatServerConnection getClient() {
        return this.client;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public void setAttribute(String string, Object object) {
    }

    public String getAttributeValueString(String string) {
        return null;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public RoomTree getCurrentRoom() {
        return this.currentRoom;
    }

    public JTextField getNewRoom() {
        return this.newRoom;
    }

    public void addExtendedNewRoomHandler(ActionListener actionListener) {
        this.newRoomButton.addActionListener(actionListener);
        this.newRoomButton.setVisible(true);
    }

    public void removeExtendedNewRoomHandler(ActionListener actionListener) {
        this.newRoomButton.removeActionListener(actionListener);
        this.newRoomButton.setVisible(false);
    }

    public void setRoomControlsVisible(boolean bl) {
        this.newRoom.setVisible(bl);
        this.newRoomLabel.setVisible(bl);
    }

    public RoomTree getRoomTree() {
        return this.roomTree;
    }
}

