/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marker
extends Decorator
implements EditablePiece {
    public static final String ID = "mark;";
    protected String[] keys;
    protected String[] values;

    public Marker() {
        this(ID, null);
    }

    public Marker(String string, GamePiece gamePiece) {
        this.mySetType(string);
        this.setInner(gamePiece);
    }

    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public void mySetType(String string) {
        string = string.substring(ID.length());
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        ArrayList<String> arrayList = new ArrayList<String>();
        while (decoder.hasMoreTokens()) {
            arrayList.add(decoder.nextToken());
        }
        this.keys = arrayList.toArray(new String[arrayList.size()]);
        this.values = new String[this.keys.length];
        Arrays.fill(this.values, "");
    }

    @Override
    public void draw(Graphics graphics, int n, int n2, Component component, double d) {
        this.piece.draw(graphics, n, n2, component, d);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Object getProperty(Object object) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(object)) continue;
            return this.values[i];
        }
        return super.getProperty(object);
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(object)) continue;
            return this.values[i];
        }
        return super.getLocalizedProperty(object);
    }

    @Override
    public void setProperty(Object object, Object object2) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(object)) continue;
            this.values[i] = (String)object2;
            return;
        }
        super.setProperty(object, object2);
    }

    @Override
    public String myGetState() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < this.values.length; ++i) {
            sequenceEncoder.append(this.values[i]);
        }
        return sequenceEncoder.getValue();
    }

    @Override
    public void mySetState(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        int n = 0;
        while (decoder.hasMoreTokens() && n < this.values.length) {
            this.values[n++] = decoder.nextToken();
        }
    }

    @Override
    public String myGetType() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < this.keys.length; ++i) {
            sequenceEncoder.append(this.keys[i]);
        }
        return ID + sequenceEncoder.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public Command myKeyEvent(KeyStroke keyStroke) {
        return null;
    }

    @Override
    public String getDescription() {
        if (this.keys != null && this.keys.length > 0 && this.keys[0].length() > 0 && this.values.length > 0 && this.values[0].length() > 0) {
            return "Marker - " + this.keys[0] + " = " + this.values[0];
        }
        return "Marker";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PropertyMarker.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.keys.length; ++i) {
            arrayList.add(this.keys[i]);
        }
        return arrayList;
    }

    private static class Ed
    implements PieceEditor {
        private StringConfigurer propName;
        private StringConfigurer propValue;
        private JPanel panel = new JPanel();

        private Ed(Marker marker) {
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
            for (int i = 0; i < marker.keys.length; ++i) {
                sequenceEncoder.append(marker.keys[i]);
            }
            SequenceEncoder sequenceEncoder2 = new SequenceEncoder(',');
            for (int i = 0; i < marker.values.length; ++i) {
                sequenceEncoder2.append(marker.values[i]);
            }
            this.propName = new StringConfigurer(null, "Property name:  ", marker.keys.length == 0 ? "" : sequenceEncoder.getValue());
            this.propValue = new StringConfigurer(null, "Property value:  ", marker.values.length == 0 ? "" : sequenceEncoder2.getValue());
            this.panel.add(this.propName.getControls());
            this.panel.add(this.propValue.getControls());
        }

        public Component getControls() {
            return this.panel;
        }

        public String getState() {
            return this.propValue.getValueString();
        }

        public String getType() {
            return Marker.ID + this.propName.getValueString();
        }
    }
}

