/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.ipc;

import VASSAL.tools.concurrent.listener.MultiEventListenerSupport;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.ipc.Fin;
import VASSAL.tools.ipc.IPCMessage;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IPCMessageReceiver
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(IPCMessageReceiver.class);
    protected final ObjectInput in;
    protected final MultiEventListenerSupport lsup;

    public IPCMessageReceiver(ObjectInput objectInput, MultiEventListenerSupport multiEventListenerSupport) {
        this.in = objectInput;
        this.lsup = multiEventListenerSupport;
    }

    public void run() {
        try {
            IPCMessage iPCMessage;
            do {
                iPCMessage = (IPCMessage)this.in.readObject();
                this.lsup.notify(iPCMessage);
            } while (!(iPCMessage instanceof Fin));
            this.in.close();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException(classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        catch (InvalidClassException invalidClassException) {
            throw new IllegalStateException(invalidClassException);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new IllegalStateException(streamCorruptedException);
        }
        catch (OptionalDataException optionalDataException) {
            throw new IllegalStateException(optionalDataException);
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
        finally {
            IOUtils.closeQuietly(this.in);
        }
    }
}

