/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.cloud.rule.ReplicaAssigner;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitShardCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public SplitShardCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        this.split(state, message, results);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean split(ClusterState clusterState, ZkNodeProps message, NamedList results) throws Exception {
        Slice parentSlice;
        DocRouter router;
        String collectionName = message.getStr("collection");
        String slice = message.getStr("shard");
        log.info("Split shard invoked");
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        zkStateReader.forceUpdateCollection(collectionName);
        String splitKey = message.getStr("split.key");
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        DocCollection collection = clusterState.getCollection(collectionName);
        DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
        if (slice == null) {
            if (!(router instanceof CompositeIdRouter)) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Split by route key can only be used with CompositeIdRouter or subclass. Found router: " + router.getClass().getName());
            Collection searchSlices = router.getSearchSlicesSingle(splitKey, (SolrParams)new ModifiableSolrParams(), collection);
            if (searchSlices.isEmpty()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to find an active shard for split.key: " + splitKey);
            }
            if (searchSlices.size() > 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Splitting a split.key: " + splitKey + " which spans multiple shards is not supported");
            }
            parentSlice = (Slice)searchSlices.iterator().next();
            slice = parentSlice.getName();
            log.info("Split by route.key: {}, parent shard is: {} ", (Object)splitKey, (Object)slice);
        } else {
            parentSlice = collection.getSlice(slice);
        }
        if (parentSlice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard with the specified name exists: " + slice);
        }
        Replica parentShardLeader = null;
        try {
            parentShardLeader = zkStateReader.getLeaderRetry(collectionName, slice, 10000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Stat leaderZnodeStat = zkStateReader.getZkClient().exists("/live_nodes/" + parentShardLeader.getNodeName(), null, true);
        if (leaderZnodeStat == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard leader node: " + parentShardLeader.getNodeName() + " is not live anymore!");
        }
        DocRouter.Range range = parentSlice.getRange();
        if (range == null) {
            range = new PlainIdRouter().fullRange();
        }
        Object var15_16 = null;
        String rangesStr = message.getStr("ranges");
        if (rangesStr != null) {
            String[] ranges = rangesStr.split(",");
            if (ranges.length == 0 || ranges.length == 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least two ranges specified to split a shard");
            }
            ArrayList<DocRouter.Range> arrayList = new ArrayList<DocRouter.Range>(ranges.length);
            for (int i = 0; i < ranges.length; ++i) {
                String r = ranges[i];
                try {
                    arrayList.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception in parsing hexadecimal hash range: " + r, (Throwable)e);
                }
                if (((DocRouter.Range)arrayList.get(i)).isSubsetOf(range)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash range: " + r + " is not a subset of parent shard's range: " + range.toString());
            }
            ArrayList temp = new ArrayList(arrayList);
            Collections.sort(temp);
            if (!range.equals((Object)new DocRouter.Range(((DocRouter.Range)temp.get((int)0)).min, ((DocRouter.Range)temp.get((int)(temp.size() - 1))).max))) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " do not cover the entire range of parent shard: " + range);
            }
            for (int i = 1; i < temp.size(); ++i) {
                if (((DocRouter.Range)temp.get((int)(i - 1))).max + 1 == ((DocRouter.Range)temp.get((int)i)).min) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Specified hash ranges: " + rangesStr + " either overlap with each other or do not cover the entire range of parent shard: " + range);
            }
        } else if (splitKey != null) {
            if (router instanceof CompositeIdRouter) {
                CompositeIdRouter compositeIdRouter = (CompositeIdRouter)router;
                List list = compositeIdRouter.partitionRangeByKey(splitKey, range);
                if (list.size() == 1) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " has a hash range that is exactly equal to hash range of shard: " + slice);
                }
                for (DocRouter.Range subRange : list) {
                    if (subRange.min != subRange.max) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The split.key: " + splitKey + " must be a compositeId");
                }
                log.info("Partitioning parent shard " + slice + " range: " + parentSlice.getRange() + " yields: " + list);
                rangesStr = "";
                for (int i = 0; i < list.size(); ++i) {
                    DocRouter.Range subRange;
                    subRange = (DocRouter.Range)list.get(i);
                    rangesStr = rangesStr + subRange.toString();
                    if (i >= list.size() - 1) continue;
                    rangesStr = rangesStr + ',';
                }
            }
        } else {
            List list = router.partitionRange(2, range);
        }
        try {
            Object m;
            DistributedQueue inQueue;
            int i;
            String subShardName;
            void var15_20;
            ArrayList<String> subSlices = new ArrayList<String>(var15_20.size());
            ArrayList<String> subShardNames = new ArrayList<String>(var15_20.size());
            String nodeName = parentShardLeader.getNodeName();
            for (int i2 = 0; i2 < var15_20.size(); ++i2) {
                String subSlice = slice + "_" + i2;
                subSlices.add(subSlice);
                String subShardName2 = collectionName + "_" + (String)subSlice + "_replica1";
                subShardNames.add(subShardName2);
            }
            boolean oldShardsDeleted = false;
            for (String subSlice : subSlices) {
                Slice oSlice = collection.getSlice(subSlice);
                if (oSlice == null) continue;
                Slice.State state = oSlice.getState();
                if (state == Slice.State.ACTIVE) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Sub-shard: " + subSlice + " exists in active state. Aborting split shard.");
                }
                if (state != Slice.State.CONSTRUCTION && state != Slice.State.RECOVERY) continue;
                log.info("Sub-shard: {} already exists therefore requesting its deletion", (Object)subSlice);
                HashMap<String, String> propMap = new HashMap<String, String>();
                propMap.put("operation", "deleteshard");
                propMap.put("collection", collectionName);
                propMap.put("shard", subSlice);
                ZkNodeProps m2 = new ZkNodeProps(propMap);
                try {
                    this.ocmh.commandMap.get(CollectionParams.CollectionAction.DELETESHARD).call(clusterState, m2, new NamedList());
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to delete already existing sub shard: " + subSlice, (Throwable)e);
                }
                oldShardsDeleted = true;
            }
            if (oldShardsDeleted) {
                clusterState = zkStateReader.getClusterState();
                collection = clusterState.getCollection(collectionName);
            }
            String asyncId = message.getStr("async");
            HashMap<String, String> requestMap = new HashMap<String, String>();
            for (int i3 = 0; i3 < var15_20.size(); ++i3) {
                String subSlice = (String)subSlices.get(i3);
                subShardName = (String)subShardNames.get(i3);
                DocRouter.Range subRange = (DocRouter.Range)var15_20.get(i3);
                log.info("Creating slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                propMap.put("operation", CollectionParams.CollectionAction.CREATESHARD.toLower());
                propMap.put("shard", subSlice);
                propMap.put("collection", collectionName);
                propMap.put("shard_range", subRange.toString());
                propMap.put("shard_state", Slice.State.CONSTRUCTION.toString());
                propMap.put("shard_parent", parentSlice.getName());
                propMap.put("shard_parent_node", parentShardLeader.getNodeName());
                propMap.put("shard_parent_zk_session", leaderZnodeStat.getEphemeralOwner());
                DistributedQueue inQueue2 = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                inQueue2.offer(Utils.toJSON((Object)new ZkNodeProps(propMap)));
                this.ocmh.waitForNewShard(collectionName, subSlice);
                clusterState = zkStateReader.getClusterState();
                log.info("Adding replica " + subShardName + " as part of slice " + subSlice + " of collection " + collectionName + " on " + nodeName);
                propMap = new HashMap();
                propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap.put("collection", collectionName);
                propMap.put("shard", subSlice);
                propMap.put("node", nodeName);
                propMap.put("name", subShardName);
                for (String string : message.keySet()) {
                    if (!string.startsWith("property.")) continue;
                    propMap.put(string, message.getStr(string));
                }
                if (asyncId != null) {
                    propMap.put("async", asyncId);
                }
                this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap), results, null);
            }
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed to create subshard leaders", asyncId, requestMap);
            for (String subShardName3 : subShardNames) {
                log.info("Asking parent leader to wait for: " + subShardName3 + " to be alive on: " + nodeName);
                String coreNodeName = this.ocmh.waitForCoreNodeName(collectionName, nodeName, subShardName3);
                CoreAdminRequest.WaitForState cmd = new CoreAdminRequest.WaitForState();
                cmd.setCoreName(subShardName3);
                cmd.setNodeName(nodeName);
                cmd.setCoreNodeName(coreNodeName);
                cmd.setState(Replica.State.ACTIVE);
                cmd.setCheckLive(Boolean.valueOf(true));
                cmd.setOnlyIfLeader(true);
                ModifiableSolrParams p = new ModifiableSolrParams(cmd.getParams());
                this.ocmh.sendShardRequest(nodeName, p, shardHandler, asyncId, requestMap);
            }
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD timed out waiting for subshard leaders to come up", asyncId, requestMap);
            log.info("Successfully created all sub-shards for collection " + collectionName + " parent shard: " + slice + " on: " + parentShardLeader);
            log.info("Splitting shard " + parentShardLeader.getName() + " as part of slice " + slice + " of collection " + collectionName + " on " + parentShardLeader);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.SPLIT.toString()});
            params.set("core", new String[]{parentShardLeader.getStr("core")});
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                params.add("targetCore", new String[]{subShardName});
            }
            params.set("ranges", new String[]{rangesStr});
            this.ocmh.sendShardRequest(parentShardLeader.getNodeName(), params, shardHandler, asyncId, requestMap);
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed to invoke SPLIT core admin command", asyncId, requestMap);
            log.info("Index on shard: " + nodeName + " split into two successfully");
            for (i = 0; i < subShardNames.size(); ++i) {
                subShardName = (String)subShardNames.get(i);
                log.info("Applying buffered updates on : " + subShardName);
                params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                params.set("name", new String[]{subShardName});
                this.ocmh.sendShardRequest(nodeName, params, shardHandler, asyncId, requestMap);
            }
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed while asking sub shard leaders to apply buffered updates", asyncId, requestMap);
            log.info("Successfully applied buffered updates on : " + subShardNames);
            int repFactor = parentSlice.getReplicas().size();
            Set nodes = clusterState.getLiveNodes();
            ArrayList nodeList = new ArrayList(nodes.size());
            nodeList.addAll(nodes);
            nodeList.remove(nodeName);
            Map<ReplicaAssigner.Position, String> nodeMap = this.ocmh.identifyNodes(clusterState, new ArrayList<String>(clusterState.getLiveNodes()), new ZkNodeProps(collection.getProperties()), subSlices, repFactor - 1);
            ArrayList replicas = new ArrayList((repFactor - 1) * 2);
            for (Map.Entry entry : nodeMap.entrySet()) {
                String sliceName = ((ReplicaAssigner.Position)entry.getKey()).shard;
                String string = (String)entry.getValue();
                String shardName = collectionName + "_" + sliceName + "_replica" + ((ReplicaAssigner.Position)entry.getKey()).index;
                log.info("Creating replica shard " + (String)shardName + " as part of slice " + sliceName + " of collection " + collectionName + " on " + string);
                ZkNodeProps props = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.ADDREPLICA.toLower(), "collection", collectionName, "shard", sliceName, "core", shardName, "state", Replica.State.DOWN.toString(), "base_url", zkStateReader.getBaseUrlForNodeName(string), "node_name", string});
                Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)props));
                HashMap<String, Object> propMap = new HashMap<String, Object>();
                propMap.put("operation", CollectionParams.CollectionAction.ADDREPLICA.toLower());
                propMap.put("collection", collectionName);
                propMap.put("shard", sliceName);
                propMap.put("node", string);
                propMap.put("name", shardName);
                for (String key : message.keySet()) {
                    if (!key.startsWith("property.")) continue;
                    propMap.put(key, message.getStr(key));
                }
                if (asyncId != null) {
                    propMap.put("async", asyncId);
                }
                propMap.put("skipCreateReplicaInClusterState", "true");
                replicas.add(propMap);
            }
            assert (TestInjection.injectSplitFailureBeforeReplicaCreation());
            long ephemeralOwner = leaderZnodeStat.getEphemeralOwner();
            leaderZnodeStat = zkStateReader.getZkClient().exists("/live_nodes/" + parentShardLeader.getNodeName(), null, true);
            if (leaderZnodeStat == null || ephemeralOwner != leaderZnodeStat.getEphemeralOwner()) {
                inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.RECOVERY_FAILED.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON((Object)m));
                if (leaderZnodeStat == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The shard leader node: " + parentShardLeader.getNodeName() + " is not live anymore!");
                }
                if (ephemeralOwner != leaderZnodeStat.getEphemeralOwner()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The zk session id for the shard leader node: " + parentShardLeader.getNodeName() + " has changed from " + ephemeralOwner + " to " + leaderZnodeStat.getEphemeralOwner() + ". This can cause data loss so we must abort the split");
                }
            }
            if (repFactor == 1) {
                log.info("Replication factor is 1 so switching shard states");
                inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                hashMap.put(slice, Slice.State.INACTIVE.toString());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.ACTIVE.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON((Object)m));
            } else {
                log.info("Requesting shard state be set to 'recovery'");
                inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
                for (String subSlice : subSlices) {
                    hashMap.put(subSlice, Slice.State.RECOVERY.toString());
                }
                hashMap.put("collection", collectionName);
                m = new ZkNodeProps(hashMap);
                inQueue.offer(Utils.toJSON((Object)m));
            }
            for (Map map : replicas) {
                this.ocmh.addReplica(clusterState, new ZkNodeProps(map), results, null);
            }
            this.ocmh.processResponses(results, shardHandler, true, "SPLITSHARD failed to create subshard replicas", asyncId, requestMap);
            log.info("Successfully created all replica shards for all sub-slices " + subSlices);
            this.ocmh.commit(results, slice, parentShardLeader);
            return true;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error executing split operation for collection: " + collectionName + " parent shard: " + slice, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
    }
}

