/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.core.SolrResourceNotFoundException;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.ManagedIndexSchemaFactory;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResourceLoader
implements ResourceLoader,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String project = "solr";
    static final String base = "org.apache.solr";
    static final String[] packages = new String[]{"", "analysis.", "schema.", "handler.", "search.", "update.", "core.", "response.", "request.", "update.processor.", "util.", "spelling.", "handler.component.", "handler.dataimport.", "spelling.suggest.", "spelling.suggest.fst.", "rest.schema.analysis.", "security.", "handler.admin."};
    private static final String SOLR_CORE_NAME = "solr.core.name";
    private static Set<String> loggedOnce = new ConcurrentSkipListSet<String>();
    protected URLClassLoader classLoader;
    private final Path instanceDir;
    private String dataDir;
    private final List<SolrCoreAware> waitingForCore = Collections.synchronizedList(new ArrayList());
    private final List<SolrInfoMBean> infoMBeans = Collections.synchronizedList(new ArrayList());
    private final List<ResourceLoaderAware> waitingForResources = Collections.synchronizedList(new ArrayList());
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private final Properties coreProperties;
    private volatile boolean live;
    private RestManager.Registry managedResourceRegistry;
    private static final Map<String, String> classNameCache = new ConcurrentHashMap<String, String>();
    private static final Pattern legacyAnalysisPattern = Pattern.compile("((\\Qorg.apache.solr.analysis.\\E)|(\\Qsolr.\\E))([\\p{L}_$][\\p{L}\\p{N}_$]+?)(TokenFilter|Filter|Tokenizer|CharFilter)Factory");
    static final String[] empty = new String[0];
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJECTS = new Object[0];
    private static final Map<Class, Class[]> awareCompatibility = new HashMap<Class, Class[]>();

    public synchronized RestManager.Registry getManagedResourceRegistry() {
        if (this.managedResourceRegistry == null) {
            this.managedResourceRegistry = new RestManager.Registry();
        }
        return this.managedResourceRegistry;
    }

    public SolrResourceLoader() {
        this(SolrResourceLoader.locateSolrHome(), null, null);
    }

    public SolrResourceLoader(Path instanceDir, ClassLoader parent) {
        this(instanceDir, parent, null);
    }

    public SolrResourceLoader(Path instanceDir) {
        this(instanceDir, null, null);
    }

    public SolrResourceLoader(Path instanceDir, ClassLoader parent, Properties coreProperties) {
        Path libDir;
        if (instanceDir == null) {
            this.instanceDir = SolrResourceLoader.locateSolrHome().toAbsolutePath().normalize();
            log.debug("new SolrResourceLoader for deduced Solr Home: '{}'", (Object)this.instanceDir);
        } else {
            this.instanceDir = instanceDir.toAbsolutePath().normalize();
            log.debug("new SolrResourceLoader for directory: '{}'", (Object)this.instanceDir);
        }
        if (parent == null) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        this.classLoader = new URLClassLoader(new URL[0], parent);
        if (!this.instanceDir.equals(SolrResourceLoader.locateSolrHome()) && Files.exists(libDir = this.instanceDir.resolve("lib"), new LinkOption[0])) {
            try {
                this.addToClassLoader(SolrResourceLoader.getURLs(libDir));
            }
            catch (IOException e) {
                log.warn("Couldn't add files from {} to classpath: {}", (Object)libDir, (Object)e.getMessage());
            }
            this.reloadLuceneSPI();
        }
        this.coreProperties = coreProperties;
    }

    void addToClassLoader(List<URL> urls) {
        URLClassLoader newLoader = SolrResourceLoader.addURLsToClassLoader(this.classLoader, urls);
        if (newLoader != this.classLoader) {
            this.classLoader = newLoader;
        }
        log.info("[{}] Added {} libs to classloader, from paths: {}", new Object[]{this.getCoreName("null"), urls.size(), urls.stream().map(u -> u.getPath().substring(0, u.getPath().lastIndexOf("/"))).sorted().distinct().collect(Collectors.toList())});
    }

    private String getCoreName(String defaultVal) {
        if (this.getCoreProperties() != null) {
            return this.getCoreProperties().getProperty(SOLR_CORE_NAME, defaultVal);
        }
        return defaultVal;
    }

    void addToClassLoader(URL ... urls) {
        this.addToClassLoader(Arrays.asList(urls));
    }

    void reloadLuceneSPI() {
        PostingsFormat.reloadPostingsFormats((ClassLoader)this.classLoader);
        DocValuesFormat.reloadDocValuesFormats((ClassLoader)this.classLoader);
        Codec.reloadCodecs((ClassLoader)this.classLoader);
        CharFilterFactory.reloadCharFilters((ClassLoader)this.classLoader);
        TokenFilterFactory.reloadTokenFilters((ClassLoader)this.classLoader);
        TokenizerFactory.reloadTokenizers((ClassLoader)this.classLoader);
    }

    private static URLClassLoader addURLsToClassLoader(URLClassLoader oldLoader, List<URL> urls) {
        if (urls.size() == 0) {
            return oldLoader;
        }
        ArrayList<URL> allURLs = new ArrayList<URL>();
        allURLs.addAll(Arrays.asList(oldLoader.getURLs()));
        allURLs.addAll(urls);
        for (URL url : urls) {
            log.debug("Adding '{}' to classloader", (Object)url.toString());
        }
        ClassLoader oldParent = oldLoader.getParent();
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{oldLoader});
        return URLClassLoader.newInstance(allURLs.toArray(new URL[allURLs.size()]), oldParent);
    }

    public static List<URL> getURLs(Path libDir, DirectoryStream.Filter<Path> filter) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (DirectoryStream<Path> directory = Files.newDirectoryStream(libDir, filter);){
            for (Path element : directory) {
                urls.add(element.toUri().normalize().toURL());
            }
        }
        return urls;
    }

    public static List<URL> getURLs(Path libDir) throws IOException {
        return SolrResourceLoader.getURLs(libDir, new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return true;
            }
        });
    }

    public static List<URL> getFilteredURLs(Path libDir, String regex) throws IOException {
        final PathMatcher matcher = libDir.getFileSystem().getPathMatcher("regex:" + regex);
        return SolrResourceLoader.getURLs(libDir, new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return matcher.matches(entry.getFileName());
            }
        });
    }

    public static String normalizeDir(String path) {
        return path != null && !path.endsWith("/") && !path.endsWith("\\") ? path + File.separator : path;
    }

    public String[] listConfigDir() {
        File configdir = new File(this.getConfigDir());
        if (configdir.exists() && configdir.isDirectory()) {
            return configdir.list();
        }
        return new String[0];
    }

    public String getConfigDir() {
        return this.instanceDir.resolve("conf").toString();
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public Properties getCoreProperties() {
        return this.coreProperties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public InputStream openSchema(String name) throws IOException {
        return this.openResource(name);
    }

    public InputStream openConfig(String name) throws IOException {
        return this.openResource(name);
    }

    private Path checkPathIsSafe(Path pathToCheck) throws IOException {
        if (Boolean.getBoolean("solr.allow.unsafe.resourceloading")) {
            return pathToCheck;
        }
        if ((pathToCheck = pathToCheck.normalize()).startsWith(this.instanceDir)) {
            return pathToCheck;
        }
        throw new IOException("File " + pathToCheck + " is outside resource loader dir " + this.instanceDir + "; set -Dsolr.allow.unsafe.resourceloading=true to allow unsafe loading");
    }

    public InputStream openResource(String resource) throws IOException {
        Path inConfigDir = this.getInstancePath().resolve("conf").resolve(resource);
        if (Files.exists(inConfigDir, new LinkOption[0]) && Files.isReadable(inConfigDir)) {
            return Files.newInputStream(this.checkPathIsSafe(inConfigDir), new OpenOption[0]);
        }
        Path inInstanceDir = this.getInstancePath().resolve(resource);
        if (Files.exists(inInstanceDir, new LinkOption[0]) && Files.isReadable(inInstanceDir)) {
            return Files.newInputStream(this.checkPathIsSafe(inInstanceDir), new OpenOption[0]);
        }
        InputStream is = this.classLoader.getResourceAsStream(resource.replace(File.separatorChar, '/'));
        if (is == null && System.getProperty("jetty.testMode") != null) {
            is = this.classLoader.getResourceAsStream(("conf/" + resource).replace(File.separatorChar, '/'));
        }
        if (is == null) {
            throw new SolrResourceNotFoundException("Can't find resource '" + resource + "' in classpath or '" + this.instanceDir + "'");
        }
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resourceLocation(String resource) {
        Path inConfigDir = this.getInstancePath().resolve("conf").resolve(resource);
        if (Files.exists(inConfigDir, new LinkOption[0]) && Files.isReadable(inConfigDir)) {
            return inConfigDir.toAbsolutePath().normalize().toString();
        }
        Path inInstanceDir = this.getInstancePath().resolve(resource);
        if (Files.exists(inInstanceDir, new LinkOption[0]) && Files.isReadable(inInstanceDir)) {
            return inInstanceDir.toAbsolutePath().normalize().toString();
        }
        try (InputStream is = this.classLoader.getResourceAsStream(resource.replace(File.separatorChar, '/'));){
            if (is == null) return resource;
            String string = "classpath:" + resource;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource;
    }

    public List<String> getLines(String resource) throws IOException {
        return this.getLines(resource, UTF_8);
    }

    public List<String> getLines(String resource, String encoding) throws IOException {
        return this.getLines(resource, Charset.forName(encoding));
    }

    public List<String> getLines(String resource, Charset charset) throws IOException {
        try {
            return WordlistLoader.getLines((InputStream)this.openResource(resource), (Charset)charset);
        }
        catch (CharacterCodingException ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading resource (wrong encoding?): " + resource, (Throwable)ex);
        }
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        return this.findClass(cname, expectedType, empty);
    }

    /*
     * Exception decompiling
     */
    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType, String ... subpackages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 17[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T> T newInstance(String name, Class<T> expectedType) {
        return this.newInstance(name, expectedType, empty);
    }

    public <T> T newInstance(String cname, Class<T> expectedType, String ... subpackages) {
        return this.newInstance(cname, expectedType, subpackages, NO_CLASSES, NO_OBJECTS);
    }

    public CoreAdminHandler newAdminHandlerInstance(CoreContainer coreContainer, String cname, String ... subpackages) {
        Class<CoreAdminHandler> clazz = this.findClass(cname, CoreAdminHandler.class, subpackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cname + " in " + this.classLoader);
        }
        CoreAdminHandler obj = null;
        try {
            Constructor<CoreAdminHandler> ctor = clazz.getConstructor(CoreContainer.class);
            obj = ctor.newInstance(coreContainer);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e);
        }
        if (!this.live && obj instanceof ResourceLoaderAware) {
            SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, obj);
            this.waitingForResources.add((ResourceLoaderAware)obj);
        }
        return obj;
    }

    public <T> T newInstance(String cName, Class<T> expectedType, String[] subPackages, Class[] params, Object[] args) {
        Class<T> clazz = this.findClass(cName, expectedType, subPackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cName + " in " + this.classLoader);
        }
        T obj = null;
        try {
            Constructor<T> constructor = null;
            try {
                constructor = clazz.getConstructor(params);
                obj = constructor.newInstance(args);
            }
            catch (NoSuchMethodException e) {
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                    obj = constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw e;
                }
            }
        }
        catch (Error err) {
            log.error("Loading Class " + cName + " (" + clazz.getName() + ") triggered serious java error: " + err.getClass().getName(), (Throwable)err);
            throw err;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e);
        }
        if (!this.live) {
            if (obj instanceof SolrCoreAware) {
                SolrResourceLoader.assertAwareCompatibility(SolrCoreAware.class, obj);
                this.waitingForCore.add((SolrCoreAware)obj);
            }
            if (obj instanceof ResourceLoaderAware) {
                SolrResourceLoader.assertAwareCompatibility(ResourceLoaderAware.class, obj);
                this.waitingForResources.add((ResourceLoaderAware)obj);
            }
            if (obj instanceof SolrInfoMBean) {
                this.infoMBeans.add((SolrInfoMBean)obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void inform(SolrCore core) {
        this.dataDir = core.getDataDir();
        block2: while (true) {
            if (this.waitingForCore.size() <= 0) {
                this.live = true;
                return;
            }
            SolrCoreAware[] solrCoreAwareArray = this.waitingForCore;
            // MONITORENTER : this.waitingForCore
            SolrCoreAware[] arr = this.waitingForCore.toArray(new SolrCoreAware[this.waitingForCore.size()]);
            this.waitingForCore.clear();
            // MONITOREXIT : solrCoreAwareArray
            solrCoreAwareArray = arr;
            int n = solrCoreAwareArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                SolrCoreAware aware = solrCoreAwareArray[n2];
                aware.inform(core);
                ++n2;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void inform(ResourceLoader loader) throws IOException {
        block2: while (this.waitingForResources.size() > 0) {
            ResourceLoaderAware[] resourceLoaderAwareArray = this.waitingForResources;
            // MONITORENTER : this.waitingForResources
            ResourceLoaderAware[] arr = this.waitingForResources.toArray(new ResourceLoaderAware[this.waitingForResources.size()]);
            this.waitingForResources.clear();
            // MONITOREXIT : resourceLoaderAwareArray
            resourceLoaderAwareArray = arr;
            int n = resourceLoaderAwareArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                ResourceLoaderAware aware = resourceLoaderAwareArray[n2];
                aware.inform(loader);
                ++n2;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inform(Map<String, SolrInfoMBean> infoRegistry) {
        SolrInfoMBean[] solrInfoMBeanArray = this.infoMBeans;
        synchronized (this.infoMBeans) {
            SolrInfoMBean[] arr = this.infoMBeans.toArray(new SolrInfoMBean[this.infoMBeans.size()]);
            this.waitingForResources.clear();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (SolrInfoMBean bean : arr) {
                if (infoRegistry.containsValue(bean)) continue;
                try {
                    infoRegistry.put(bean.getName(), bean);
                }
                catch (Exception e) {
                    log.warn("could not register MBean '" + bean.getName() + "'.", (Throwable)e);
                }
            }
            return;
        }
    }

    public static Path locateSolrHome() {
        String prop;
        String home = null;
        try {
            InitialContext c = new InitialContext();
            home = (String)c.lookup("java:comp/env/solr/home");
            SolrResourceLoader.logOnceInfo("home_using_jndi", "Using JNDI solr.home: " + home);
        }
        catch (NoInitialContextException e) {
            log.debug("JNDI not configured for solr (NoInitialContextEx)");
        }
        catch (NamingException e) {
            log.debug("No /solr/home in JNDI");
        }
        catch (RuntimeException ex) {
            log.warn("Odd RuntimeException while testing for JNDI: " + ex.getMessage());
        }
        if (home == null && (home = System.getProperty(prop = "solr.solr.home")) != null) {
            SolrResourceLoader.logOnceInfo("home_using_sysprop", "Using system property " + prop + ": " + home);
        }
        if (home == null) {
            home = "solr/";
            SolrResourceLoader.logOnceInfo("home_default", "solr home defaulted to '" + home + "' (could not find system property or JNDI)");
        }
        return Paths.get(home, new String[0]);
    }

    private static void logOnceInfo(String key, String msg) {
        if (!loggedOnce.contains(key)) {
            loggedOnce.add(key);
            log.info(msg);
        }
    }

    public Path getInstancePath() {
        return this.instanceDir;
    }

    static void assertAwareCompatibility(Class aware, Object obj) {
        Class[] valid = awareCompatibility.get(aware);
        if (valid == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Aware interface: " + aware);
        }
        for (Class v : valid) {
            if (!v.isInstance(obj)) continue;
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Invalid 'Aware' object: ").append(obj);
        builder.append(" -- ").append(aware.getName());
        builder.append(" must be an instance of: ");
        for (Class v : valid) {
            builder.append("[").append(v.getName()).append("] ");
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, builder.toString());
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.classLoader});
    }

    public List<SolrInfoMBean> getInfoMBeans() {
        return Collections.unmodifiableList(this.infoMBeans);
    }

    public static void persistConfLocally(SolrResourceLoader loader, String resourceName, byte[] content) {
        File confFile = new File(loader.getConfigDir(), resourceName);
        try {
            File parentDir = confFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                String msg = "Can't create managed schema directory " + parentDir.getAbsolutePath();
                log.error(msg);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            try (FileOutputStream out = new FileOutputStream(confFile);){
                ((OutputStream)out).write(content);
            }
            log.info("Written confile " + resourceName);
        }
        catch (IOException e) {
            String msg = "Error persisting conf file " + resourceName;
            log.error(msg, (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        finally {
            try {
                IOUtils.fsync((Path)confFile.toPath(), (boolean)false);
            }
            catch (IOException e) {
                String msg = "Error syncing conf file " + resourceName;
                log.error(msg, (Throwable)e);
            }
        }
    }

    static {
        awareCompatibility.put(SolrCoreAware.class, new Class[]{CodecFactory.class, DirectoryFactory.class, ManagedIndexSchemaFactory.class, QueryResponseWriter.class, SearchComponent.class, ShardHandlerFactory.class, SimilarityFactory.class, SolrRequestHandler.class, UpdateRequestProcessorFactory.class});
        awareCompatibility.put(ResourceLoaderAware.class, new Class[]{CharFilterFactory.class, TokenFilterFactory.class, TokenizerFactory.class, QParserPlugin.class, FieldType.class});
    }
}

