/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

class LimitStream
extends TupleStream {
    private final TupleStream stream;
    private final int limit;
    private int count;

    LimitStream(TupleStream stream, int limit) {
        this.stream = stream;
        this.limit = limit;
    }

    public void open() throws IOException {
        this.stream.open();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public List<TupleStream> children() {
        ArrayList<TupleStream> children = new ArrayList<TupleStream>();
        children.add(this.stream);
        return children;
    }

    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName("SQL LIMIT").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
    }

    public Tuple read() throws IOException {
        ++this.count;
        if (this.count > this.limit) {
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("EOF", "true");
            return new Tuple(fields);
        }
        return this.stream.read();
    }
}

