/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.DirectoryReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.QueryComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.EarlyTerminatingCollectorException;
import org.apache.solr.spelling.PossibilityIterator;
import org.apache.solr.spelling.SpellCheckCollation;
import org.apache.solr.spelling.SpellCheckCorrection;
import org.apache.solr.spelling.SpellingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpellCheckCollator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private int maxCollations = 1;
    private int maxCollationTries = 0;
    private int maxCollationEvaluations = 10000;
    private boolean suggestionsMayOverlap = false;
    private int docCollectionLimit = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SpellCheckCollation> collate(SpellingResult result, String originalQuery, ResponseBuilder ultimateResponse) {
        int maxTries;
        ArrayList<SpellCheckCollation> collations = new ArrayList<SpellCheckCollation>();
        QueryComponent queryComponent = null;
        if (ultimateResponse.components != null) {
            for (SearchComponent sc : ultimateResponse.components) {
                if (!(sc instanceof QueryComponent)) continue;
                queryComponent = (QueryComponent)sc;
                break;
            }
        }
        boolean verifyCandidateWithQuery = true;
        int maxNumberToIterate = maxTries = this.maxCollationTries;
        if (maxTries < 1) {
            maxTries = 1;
            maxNumberToIterate = this.maxCollations;
            verifyCandidateWithQuery = false;
        }
        if (queryComponent == null && verifyCandidateWithQuery) {
            LOG.info("Could not find an instance of QueryComponent.  Disabling collation verification against the index.");
            maxTries = 1;
            verifyCandidateWithQuery = false;
        }
        this.docCollectionLimit = this.docCollectionLimit > 0 ? this.docCollectionLimit : 0;
        int maxDocId = -1;
        if (verifyCandidateWithQuery && this.docCollectionLimit > 0) {
            DirectoryReader reader = ultimateResponse.req.getSearcher().getIndexReader();
            maxDocId = reader.maxDoc();
        }
        int tryNo = 0;
        int collNo = 0;
        PossibilityIterator possibilityIter = new PossibilityIterator(result.getSuggestions(), maxNumberToIterate, this.maxCollationEvaluations, this.suggestionsMayOverlap);
        while (tryNo < maxTries && collNo < this.maxCollations && possibilityIter.hasNext()) {
            PossibilityIterator.RankedSpellPossibility possibility = possibilityIter.next();
            String collationQueryStr = this.getCollation(originalQuery, possibility.corrections);
            int hits = 0;
            if (verifyCandidateWithQuery) {
                ++tryNo;
                SolrParams origParams = ultimateResponse.req.getParams();
                ModifiableSolrParams params = new ModifiableSolrParams(origParams);
                Iterator origParamIterator = origParams.getParameterNamesIterator();
                int pl = "spellcheck.collateParam.".length();
                while (origParamIterator.hasNext()) {
                    String origParamName = (String)origParamIterator.next();
                    if (!origParamName.startsWith("spellcheck.collateParam.") || origParamName.length() <= pl) continue;
                    String[] val = origParams.getParams(origParamName);
                    if (val.length == 1 && val[0].length() == 0) {
                        params.set(origParamName.substring(pl), (String[])null);
                        continue;
                    }
                    params.set(origParamName.substring(pl), val);
                }
                params.set("q", new String[]{collationQueryStr});
                params.remove("start");
                params.set("rows", new String[]{"" + this.docCollectionLimit});
                params.set("fl", new String[]{"id"});
                params.set("sort", new String[]{"_docid_ asc"});
                params.remove("cursorMark");
                params.remove("tie");
                params.remove("pf");
                params.remove("pf2");
                params.remove("pf3");
                params.remove("bq");
                params.remove("bf");
                params.remove("group");
                params.remove("expand");
                String[] filters = params.getParams("fq");
                if (filters != null) {
                    ArrayList<String> filtersToApply = new ArrayList<String>(filters.length);
                    for (String fq : filters) {
                        if (fq.startsWith("{!collapse")) continue;
                        filtersToApply.add(fq);
                    }
                    params.set("fq", filtersToApply.toArray(new String[filtersToApply.size()]));
                }
                ResponseBuilder checkResponse = new ResponseBuilder(new LocalSolrQueryRequest(ultimateResponse.req.getCore(), (SolrParams)params), new SolrQueryResponse(), Arrays.asList(queryComponent));
                checkResponse.setQparser(ultimateResponse.getQparser());
                checkResponse.setFilters(ultimateResponse.getFilters());
                checkResponse.setQueryString(collationQueryStr);
                checkResponse.components = Arrays.asList(queryComponent);
                try {
                    queryComponent.prepare(checkResponse);
                    if (this.docCollectionLimit > 0) {
                        int f = checkResponse.getFieldFlags();
                        checkResponse.setFieldFlags(f |= 4);
                    }
                    queryComponent.process(checkResponse);
                    hits = (Integer)checkResponse.rsp.getToLog().get("hits");
                }
                catch (EarlyTerminatingCollectorException etce) {
                    assert (this.docCollectionLimit > 0);
                    assert (0 < etce.getNumberScanned());
                    assert (0 < etce.getNumberCollected());
                    hits = etce.getNumberScanned() == maxDocId ? etce.getNumberCollected() : (int)((float)(maxDocId * etce.getNumberCollected()) / (float)etce.getNumberScanned());
                }
                catch (Exception e) {
                    LOG.warn("Exception trying to re-query to check if a spell check possibility would return any hits.", (Throwable)e);
                }
                finally {
                    checkResponse.req.close();
                }
            }
            if (hits > 0 || !verifyCandidateWithQuery) {
                ++collNo;
                SpellCheckCollation collation = new SpellCheckCollation();
                collation.setCollationQuery(collationQueryStr);
                collation.setHits(hits);
                collation.setInternalRank(this.suggestionsMayOverlap ? possibility.rank * 1000 + possibility.index : possibility.rank);
                NamedList misspellingsAndCorrections = new NamedList();
                for (SpellCheckCorrection corr : possibility.corrections) {
                    misspellingsAndCorrections.add(corr.getOriginal().toString(), (Object)corr.getCorrection());
                }
                collation.setMisspellingsAndCorrections((NamedList<String>)misspellingsAndCorrections);
                collations.add(collation);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Collation: " + collationQueryStr + (verifyCandidateWithQuery ? " will return " + hits + " hits." : ""));
        }
        return collations;
    }

    private String getCollation(String origQuery, List<SpellCheckCorrection> corrections) {
        StringBuilder collation = new StringBuilder(origQuery);
        int offset = 0;
        String corr = "";
        for (int i = 0; i < corrections.size(); ++i) {
            SpellCheckCorrection correction = corrections.get(i);
            Token tok = correction.getOriginal();
            if (tok.getPositionIncrement() == 0) continue;
            corr = correction.getCorrection();
            boolean addParenthesis = false;
            Character requiredOrProhibited = null;
            int indexOfSpace = corr.indexOf(32);
            StringBuilder corrSb = new StringBuilder(corr);
            int bump = 1;
            while (indexOfSpace > -1 && indexOfSpace < corr.length() - 1) {
                char previousChar;
                addParenthesis = true;
                char c = previousChar = tok.startOffset() > 0 ? (char)origQuery.charAt(tok.startOffset() - 1) : (char)' ';
                if (previousChar == '-' || previousChar == '+') {
                    corrSb.insert(indexOfSpace + bump, previousChar);
                    if (requiredOrProhibited == null) {
                        requiredOrProhibited = Character.valueOf(previousChar);
                    }
                    ++bump;
                } else if ((tok.getFlags() & 0x20000) == 131072) {
                    corrSb.insert(indexOfSpace + bump, "AND ");
                    bump += 4;
                }
                indexOfSpace = correction.getCorrection().indexOf(32, indexOfSpace + bump);
            }
            int oneForReqOrProhib = 0;
            if (addParenthesis) {
                if (requiredOrProhibited != null) {
                    corrSb.insert(0, requiredOrProhibited);
                    ++oneForReqOrProhib;
                }
                corrSb.insert(0, '(');
                corrSb.append(')');
            }
            corr = corrSb.toString();
            int startIndex = tok.startOffset() + offset - oneForReqOrProhib;
            int endIndex = tok.endOffset() + offset;
            collation.replace(startIndex, endIndex, corr);
            offset += corr.length() - oneForReqOrProhib - (tok.endOffset() - tok.startOffset());
        }
        return collation.toString();
    }

    public SpellCheckCollator setMaxCollations(int maxCollations) {
        this.maxCollations = maxCollations;
        return this;
    }

    public SpellCheckCollator setMaxCollationTries(int maxCollationTries) {
        this.maxCollationTries = maxCollationTries;
        return this;
    }

    public SpellCheckCollator setMaxCollationEvaluations(int maxCollationEvaluations) {
        this.maxCollationEvaluations = maxCollationEvaluations;
        return this;
    }

    public SpellCheckCollator setSuggestionsMayOverlap(boolean suggestionsMayOverlap) {
        this.suggestionsMayOverlap = suggestionsMayOverlap;
        return this;
    }

    public SpellCheckCollator setDocCollectionLimit(int docCollectionLimit) {
        this.docCollectionLimit = docCollectionLimit;
        return this;
    }
}

