/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.uninverting;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LegacyNumericUtils;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.uninverting.FieldCacheImpl;

interface FieldCache {
    public static final FieldCache DEFAULT = new FieldCacheImpl();
    public static final Parser INT_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableBytesToInt((byte[])point.bytes, (int)point.offset);
        }

        public String toString() {
            return FieldCache.class.getName() + ".INT_POINT_PARSER";
        }
    };
    public static final Parser LONG_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableBytesToLong((byte[])point.bytes, (int)point.offset);
        }

        public String toString() {
            return FieldCache.class.getName() + ".LONG_POINT_PARSER";
        }
    };
    public static final Parser FLOAT_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableFloatBits((int)NumericUtils.sortableBytesToInt((byte[])point.bytes, (int)point.offset));
        }

        public String toString() {
            return FieldCache.class.getName() + ".FLOAT_POINT_PARSER";
        }
    };
    public static final Parser DOUBLE_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableDoubleBits((long)NumericUtils.sortableBytesToLong((byte[])point.bytes, (int)point.offset));
        }

        public String toString() {
            return FieldCache.class.getName() + ".DOUBLE_POINT_PARSER";
        }
    };
    @Deprecated
    public static final Parser LEGACY_INT_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            return LegacyNumericUtils.prefixCodedToInt((BytesRef)term);
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedInts((TermsEnum)terms.iterator());
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_INT_PARSER";
        }
    };
    @Deprecated
    public static final Parser LEGACY_FLOAT_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            int val = LegacyNumericUtils.prefixCodedToInt((BytesRef)term);
            if (val < 0) {
                val ^= Integer.MAX_VALUE;
            }
            return val;
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_FLOAT_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedInts((TermsEnum)terms.iterator());
        }
    };
    @Deprecated
    public static final Parser LEGACY_LONG_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            return LegacyNumericUtils.prefixCodedToLong((BytesRef)term);
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_LONG_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedLongs((TermsEnum)terms.iterator());
        }
    };
    @Deprecated
    public static final Parser LEGACY_DOUBLE_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            long val = LegacyNumericUtils.prefixCodedToLong((BytesRef)term);
            if (val < 0L) {
                val ^= Long.MAX_VALUE;
            }
            return val;
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_DOUBLE_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedLongs((TermsEnum)terms.iterator());
        }
    };
    public static final BytesRef INT32_TERM_PREFIX = new BytesRef(new byte[]{96});
    public static final BytesRef INT64_TERM_PREFIX = new BytesRef(new byte[]{32});

    public Bits getDocsWithField(LeafReader var1, String var2, Parser var3) throws IOException;

    public NumericDocValues getNumerics(LeafReader var1, String var2, Parser var3, boolean var4) throws IOException;

    public BinaryDocValues getTerms(LeafReader var1, String var2, boolean var3) throws IOException;

    public BinaryDocValues getTerms(LeafReader var1, String var2, boolean var3, float var4) throws IOException;

    public SortedDocValues getTermsIndex(LeafReader var1, String var2) throws IOException;

    public SortedDocValues getTermsIndex(LeafReader var1, String var2, float var3) throws IOException;

    public SortedSetDocValues getDocTermOrds(LeafReader var1, String var2, BytesRef var3) throws IOException;

    public CacheEntry[] getCacheEntries();

    public void purgeAllCaches();

    public void purgeByCacheKey(Object var1);

    public void setInfoStream(PrintStream var1);

    public PrintStream getInfoStream();

    public static final class CacheEntry {
        private final Object readerKey;
        private final String fieldName;
        private final Class<?> cacheType;
        private final Object custom;
        private final Accountable value;

        public CacheEntry(Object readerKey, String fieldName, Class<?> cacheType, Object custom, Accountable value) {
            this.readerKey = readerKey;
            this.fieldName = fieldName;
            this.cacheType = cacheType;
            this.custom = custom;
            this.value = value;
        }

        public Object getReaderKey() {
            return this.readerKey;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class<?> getCacheType() {
            return this.cacheType;
        }

        public Object getCustom() {
            return this.custom;
        }

        public Accountable getValue() {
            return this.value;
        }

        public String getEstimatedSize() {
            long bytesUsed = this.value == null ? 0L : this.value.ramBytesUsed();
            return RamUsageEstimator.humanReadableUnits((long)bytesUsed);
        }

        public String toString() {
            StringBuilder b = new StringBuilder(100);
            b.append("segment='").append(this.getReaderKey().toString()).append("', ");
            b.append("field='").append(this.getFieldName()).append("', ");
            String s = this.getEstimatedSize();
            b.append("size =~ ").append(s);
            return b.toString();
        }
    }

    public static abstract class PointParser
    implements Parser {
        @Override
        public final TermsEnum termsEnum(Terms terms) throws IOException {
            throw new UnsupportedOperationException("makes no sense for parsing points");
        }
    }

    public static interface Parser {
        @Deprecated
        public TermsEnum termsEnum(Terms var1) throws IOException;

        public long parseValue(BytesRef var1);
    }

    public static final class CreationPlaceholder
    implements Accountable {
        Accountable value;

        public long ramBytesUsed() {
            return RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        }
    }
}

