/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dsf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.AudioFileReader;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class DsfAudioFileReader
extends AudioFileReader {
    private static final String DSD_SIGNATURE = "DSD ";
    private static final String FMT_SIGNATURE = "fmt ";
    public static final int SIGNATURE_LENGTH = 4;
    public static final int CHUNKSIZE_LENGTH = 8;
    public static final int FILESIZE_LENGTH = 8;
    public static final int METADATA_OFFSET_LENGTH = 8;
    public static final int FMT_CHUNK_MIN_DATA_SIZE_ = 40;

    @Override
    protected GenericAudioHeader getEncodingInfo(RandomAccessFile raf) throws CannotReadException, IOException {
        ByteBuffer headerBuffer = Utils.readFileDataIntoBufferLE(raf, 4);
        String type = Utils.readFourBytesAsChars(headerBuffer);
        if (DSD_SIGNATURE.equals(type)) {
            raf.skipBytes(24);
            headerBuffer = Utils.readFileDataIntoBufferLE(raf, 12);
            String fmt = Utils.readFourBytesAsChars(headerBuffer);
            if (FMT_SIGNATURE.equals(fmt)) {
                long size = headerBuffer.getLong();
                long sizeExcludingChunkHeader = size - 12L;
                ByteBuffer audioData = Utils.readFileDataIntoBufferLE(raf, (int)sizeExcludingChunkHeader);
                return this.readAudioInfo(audioData);
            }
            throw new CannotReadException("Not a valid dsf file. Content does not start with 'fmt '.");
        }
        throw new CannotReadException("Not a valid dsf file. Content does not start with 'DSD '.");
    }

    private GenericAudioHeader readAudioInfo(ByteBuffer audioInfoChunk) {
        GenericAudioHeader audioHeader = new GenericAudioHeader();
        if (audioInfoChunk.limit() < 40) {
            logger.log(Level.WARNING, "Not enough bytes supplied for Generic audio header. Returning an empty one.");
            return audioHeader;
        }
        audioInfoChunk.order(ByteOrder.LITTLE_ENDIAN);
        int version = audioInfoChunk.getInt();
        int formatId = audioInfoChunk.getInt();
        int channelType = audioInfoChunk.getInt();
        int channelNumber = audioInfoChunk.getInt();
        int samplingFreqency = audioInfoChunk.getInt();
        int bitsPerSample = audioInfoChunk.getInt();
        long sampleCount = audioInfoChunk.getLong();
        int blocksPerSample = audioInfoChunk.getInt();
        audioHeader.setBitRate(bitsPerSample * samplingFreqency * channelNumber);
        audioHeader.setBitsPerSample(bitsPerSample);
        audioHeader.setChannelNumber(channelNumber);
        audioHeader.setSamplingRate(samplingFreqency);
        audioHeader.setNoOfSamples(sampleCount);
        audioHeader.setPreciseLength((float)sampleCount / (float)samplingFreqency);
        audioHeader.setVariableBitRate(false);
        logger.log(Level.FINE, "Created audio header: " + audioHeader);
        return audioHeader;
    }

    @Override
    protected Tag getTag(RandomAccessFile raf) throws CannotReadException, IOException {
        String type = Utils.readFourBytesAsChars(Utils.readFileDataIntoBufferLE(raf, 4));
        if (DSD_SIGNATURE.equals(type)) {
            raf.skipBytes(16);
            long offset = Long.reverseBytes(raf.readLong());
            return this.readTag(raf, offset);
        }
        throw new CannotReadException("Not a valid dsf file. Content does not start with 'DSD '.");
    }

    private Tag readTag(RandomAccessFile file, long tagOffset) throws CannotReadException, IOException {
        file.seek(tagOffset);
        ByteBuffer tagBuffer = Utils.readFileDataIntoBufferLE(file, (int)(file.length() - file.getFilePointer()));
        byte majorVersion = tagBuffer.get(3);
        try {
            logger.log(Level.FINE, "Start creating ID3v2 Tag for version: " + majorVersion);
            switch (majorVersion) {
                case 2: {
                    return new ID3v22Tag(tagBuffer, "");
                }
                case 3: {
                    return new ID3v23Tag(tagBuffer, "");
                }
                case 4: {
                    return new ID3v24Tag(tagBuffer, "");
                }
            }
            logger.log(Level.WARNING, "Unknown major ID3v2 version " + majorVersion + ". Returning an empty ID3v2 Tag.");
            return new ID3v24Tag();
        }
        catch (TagException e) {
            throw new CannotReadException("Could not create ID3v2 Tag");
        }
    }
}

