/*
 * Decompiled with CFR 0.152.
 */
package jam.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;
    private boolean scaled;

    public static void printComponent(Component component) {
        new PrintUtilities(component).print();
    }

    public static void printComponentScaled(Component component) {
        new PrintUtilities(component, true).print();
    }

    public PrintUtilities(Component component) {
        this.componentToBePrinted = component;
    }

    public PrintUtilities(Component component, boolean bl) {
        this(component);
        this.scaled = bl;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                System.out.println("Error printing: " + printerException);
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.scaled) {
            return this.printScaled(graphics, pageFormat, n);
        }
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paint(graphics2D);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public int printScaled(Graphics graphics, PageFormat pageFormat, int n) {
        return PrintUtilities.printScaled(this.componentToBePrinted, graphics, pageFormat, n);
    }

    public static int printScaled(Component component, Graphics graphics, PageFormat pageFormat, int n) {
        double d;
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        double d2 = pageFormat.getImageableX();
        double d3 = pageFormat.getImageableY();
        double d4 = pageFormat.getImageableWidth();
        double d5 = pageFormat.getImageableHeight();
        double d6 = component.getWidth();
        double d7 = d4 / d6 < d5 / (d = (double)component.getHeight()) ? d4 / d6 : d5 / d;
        graphics2D.translate(d2, d3);
        graphics2D.scale(d7, d7);
        PrintUtilities.disableDoubleBuffering(component);
        component.paint(graphics2D);
        PrintUtilities.enableDoubleBuffering(component);
        return 0;
    }

    public static void disableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component component) {
        RepaintManager repaintManager = RepaintManager.currentManager(component);
        repaintManager.setDoubleBufferingEnabled(true);
    }
}

