/*
 * Decompiled with CFR 0.152.
 */
package beast.core.util;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.Loggable;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

@Description(value="Report effective sample size of a parameter or log values from a distribution. This uses the same criterion as Tracer and assumes 10% burn in.")
public class ESS
extends BEASTObject
implements Loggable {
    public final Input<Function> functionInput = new Input("arg", "value (e.g. parameter or distribution) to report ESS for", Input.Validate.REQUIRED);
    List<Double> trace;
    double sum = 0.0;
    List<Double> squareLaggedSums;
    static final int MAX_LAG = 2000;

    @Override
    public void initAndValidate() {
        this.trace = new ArrayList<Double>();
        this.squareLaggedSums = new ArrayList<Double>();
    }

    @Override
    public void init(PrintStream printStream) {
        String string = ((BEASTObject)((Object)this.functionInput.get())).getID();
        printStream.print("ESS(" + string + ")\t");
    }

    @Override
    public void log(int n, PrintStream printStream) {
        Double d = this.functionInput.get().getArrayValue();
        this.trace.add(d);
        this.sum += d.doubleValue();
        int n2 = this.trace.size();
        int n3 = n2 / 10;
        if (n3 != (n2 - 1) / 10) {
            this.sum -= this.trace.get((n2 - 1) / 10).doubleValue();
        }
        int n4 = n2 - n3;
        int n5 = Math.min(n4, 2000);
        double d2 = this.sum / (double)n4;
        if (n3 != (n2 - 1) / 10) {
            int n6 = (n2 - 1) / 10;
            for (int i = 0; i < this.squareLaggedSums.size(); ++i) {
                this.squareLaggedSums.set(i, this.squareLaggedSums.get(i) - this.trace.get(n6) * this.trace.get(n6 + i));
            }
        }
        while (this.squareLaggedSums.size() < n5) {
            this.squareLaggedSums.add(0.0);
        }
        double[] dArray = new double[n5];
        double d3 = this.sum;
        double d4 = this.sum;
        for (int i = 0; i < n5; ++i) {
            this.squareLaggedSums.set(i, this.squareLaggedSums.get(i) + this.trace.get(n2 - i - 1) * this.trace.get(n2 - 1));
            dArray[i] = this.squareLaggedSums.get(i) - (d3 + d4) * d2 + d2 * d2 * (double)(n4 - i);
            int n7 = i;
            dArray[n7] = dArray[n7] / (double)(n4 - i);
            d3 -= this.trace.get(n2 - 1 - i).doubleValue();
            d4 -= this.trace.get(n3 + i).doubleValue();
        }
        double d5 = 0.0;
        for (int i = 0; i < n5; ++i) {
            if (i == 0) {
                d5 = dArray[0];
                continue;
            }
            if (i % 2 != 0) continue;
            if (!(dArray[i - 1] + dArray[i] > 0.0)) break;
            d5 += 2.0 * (dArray[i - 1] + dArray[i]);
        }
        double d6 = d5 / dArray[0];
        double d7 = (double)n4 / d6;
        String string = d7 + "";
        string = string.substring(0, string.indexOf(46) + 2);
        printStream.print(string + "\t");
    }

    @Override
    public void close(PrintStream printStream) {
    }

    public static double calcESS(List<Double> list) {
        return ESS.calcESS(list.toArray(new Double[0]), 1);
    }

    public static double calcESS(Double[] doubleArray, int n) {
        return (double)doubleArray.length / (ESS.ACT(doubleArray, n) / (double)n);
    }

    public static double ACT(Double[] doubleArray, int n) {
        double d;
        int n2;
        double d2 = 0.0;
        double[] dArray = new double[2000];
        double[] dArray2 = new double[2000];
        for (n2 = 0; n2 < doubleArray.length; ++n2) {
            d = (d2 += doubleArray[n2].doubleValue()) / (double)(n2 + 1);
            double d3 = d2;
            double d4 = d2;
            for (int i = 0; i < Math.min(n2 + 1, 2000); ++i) {
                dArray[i] = dArray[i] + doubleArray[n2 - i] * doubleArray[n2];
                dArray2[i] = dArray[i] - (d3 + d4) * d + d * d * (double)(n2 + 1 - i);
                int n3 = i;
                dArray2[n3] = dArray2[n3] / (double)(n2 + 1 - i);
                d3 -= doubleArray[n2 - i].doubleValue();
                d4 -= doubleArray[i].doubleValue();
            }
        }
        n2 = Math.min(doubleArray.length, 2000);
        d = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (i == 0) {
                d = dArray2[0];
                continue;
            }
            if (i % 2 != 0) continue;
            if (!(dArray2[i - 1] + dArray2[i] > 0.0)) break;
            d += 2.0 * (dArray2[i - 1] + dArray2[i]);
        }
        return (double)n * d / dArray2[0];
    }

    public static double stdErrorOfMean(Double[] doubleArray, int n) {
        double d;
        int n2;
        double d2 = 0.0;
        double[] dArray = new double[2000];
        double[] dArray2 = new double[2000];
        for (n2 = 0; n2 < doubleArray.length; ++n2) {
            d = (d2 += doubleArray[n2].doubleValue()) / (double)(n2 + 1);
            double d3 = d2;
            double d4 = d2;
            for (int i = 0; i < Math.min(n2 + 1, 2000); ++i) {
                dArray[i] = dArray[i] + doubleArray[n2 - i] * doubleArray[n2];
                dArray2[i] = dArray[i] - (d3 + d4) * d + d * d * (double)(n2 + 1 - i);
                int n3 = i;
                dArray2[n3] = dArray2[n3] / (double)(n2 + 1 - i);
                d3 -= doubleArray[n2 - i].doubleValue();
                d4 -= doubleArray[i].doubleValue();
            }
        }
        n2 = Math.min(doubleArray.length, 2000);
        d = 0.0;
        for (int i = 0; i < n2; ++i) {
            if (i == 0) {
                d = dArray2[0];
                continue;
            }
            if (i % 2 != 0) continue;
            if (!(dArray2[i - 1] + dArray2[i] > 0.0)) break;
            d += 2.0 * (dArray2[i - 1] + dArray2[i]);
        }
        return Math.sqrt(d / (double)doubleArray.length);
    }
}

