/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.util.Randomizer;

@Description(value="Assign one or more parameter values to a uniformly selected value in its range.")
public class UniformOperator
extends Operator {
    public final Input<Parameter<?>> parameterInput = new Input("parameter", "a real or integer parameter to sample individual values for", Input.Validate.REQUIRED, Parameter.class);
    public final Input<Integer> howManyInput = new Input<Integer>("howMany", "number of items to sample, default 1, must be less than the dimension of the parameter", 1);
    int howMany;
    Parameter<?> parameter;
    double lower;
    double upper;
    int lowerIndex;
    int upperIndex;

    @Override
    public void initAndValidate() {
        this.parameter = this.parameterInput.get();
        if (this.parameter instanceof RealParameter) {
            this.lower = (Double)this.parameter.getLower();
            this.upper = (Double)this.parameter.getUpper();
        } else if (this.parameter instanceof IntegerParameter) {
            this.lowerIndex = (Integer)this.parameter.getLower();
            this.upperIndex = (Integer)this.parameter.getUpper();
        } else {
            throw new IllegalArgumentException("parameter should be a RealParameter or IntergerParameter, not " + this.parameter.getClass().getName());
        }
        this.howMany = this.howManyInput.get();
        if (this.howMany > this.parameter.getDimension()) {
            throw new IllegalArgumentException("howMany it too large: must be less than the dimension of the parameter");
        }
    }

    @Override
    public double proposal() {
        for (int i = 0; i < this.howMany; ++i) {
            int n = Randomizer.nextInt(this.parameter.getDimension());
            if (this.parameter instanceof IntegerParameter) {
                int n2 = Randomizer.nextInt(this.upperIndex - this.lowerIndex + 1) + this.lowerIndex;
                ((IntegerParameter)this.parameter).setValue(n, n2);
                continue;
            }
            double d = Randomizer.nextDouble() * (this.upper - this.lower) + this.lower;
            ((RealParameter)this.parameter).setValue(n, d);
        }
        return 0.0;
    }
}

