/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.evolution.datatype.Aminoacid;
import beast.evolution.datatype.DataType;
import beast.evolution.substitutionmodel.EmpiricalSubstitutionModel;

@Description(value=" * JTT model for amino acid evolution  D.T. Jones, W.R. Taylor, and J.M. Thornton  The rapid generation of mutation data matrices from protein sequences  CABIOS  vol. 8 no. 3 1992 pp. 275-282.")
public class JTT
extends EmpiricalSubstitutionModel {
    @Override
    double[][] getEmpiricalRates() {
        double[][] dArray = new double[20][20];
        dArray[0][1] = 3.1628651460584;
        dArray[0][2] = 3.280493592786;
        dArray[0][3] = 4.8477237048666;
        dArray[0][4] = 3.4612244897959;
        dArray[0][5] = 3.3130910900946;
        dArray[0][6] = 6.3199473337722;
        dArray[0][7] = 10.440154440154;
        dArray[0][8] = 1.3061224489796;
        dArray[0][9] = 2.1726844583987;
        dArray[0][10] = 1.8443597219107;
        dArray[0][11] = 2.2137668626773;
        dArray[0][12] = 2.7210884353741;
        dArray[0][13] = 0.83265306122449;
        dArray[0][14] = 11.537414965986;
        dArray[0][15] = 22.838213546288;
        dArray[0][16] = 27.007955724663;
        dArray[0][17] = 0.5131195335277;
        dArray[0][18] = 0.83673469387755;
        dArray[0][19] = 17.474335188621;
        dArray[1][2] = 2.6598918637222;
        dArray[1][3] = 0.91014867485456;
        dArray[1][4] = 6.1624649859944;
        dArray[1][5] = 18.036482885837;
        dArray[1][6] = 1.8924731182796;
        dArray[1][7] = 8.1810886516769;
        dArray[1][8] = 19.119717452198;
        dArray[1][9] = 1.4410687351864;
        dArray[1][10] = 2.221196170776;
        dArray[1][11] = 39.239234676922;
        dArray[1][12] = 2.5060690943044;
        dArray[1][13] = 0.39439775910364;
        dArray[1][14] = 4.1953094963476;
        dArray[1][15] = 5.9016766126741;
        dArray[1][16] = 3.8437069743152;
        dArray[1][17] = 7.6766706682673;
        dArray[1][18] = 1.4173669467787;
        dArray[1][19] = 1.03081232493;
        dArray[2][3] = 32.226935854843;
        dArray[2][4] = 1.871096345515;
        dArray[2][5] = 4.5351268130622;
        dArray[2][6] = 3.3951344979102;
        dArray[2][7] = 4.598724970818;
        dArray[2][8] = 23.693774375271;
        dArray[2][9] = 2.9235880398671;
        dArray[2][10] = 0.80960899565551;
        dArray[2][11] = 15.024269384537;
        dArray[2][12] = 1.9003322259136;
        dArray[2][13] = 0.43853820598007;
        dArray[2][14] = 0.71083317047749;
        dArray[2][15] = 29.45620877269;
        dArray[2][16] = 13.73590855341;
        dArray[2][17] = 0.16706217370669;
        dArray[2][18] = 4.1661129568106;
        dArray[2][19] = 0.97452934662237;
        dArray[3][4] = 0.62857142857143;
        dArray[3][5] = 3.0662020905923;
        dArray[3][6] = 45.450549450549;
        dArray[3][7] = 7.5402435402435;
        dArray[3][8] = 6.0544672718586;
        dArray[3][9] = 0.68808114961961;
        dArray[3][10] = 0.36130902064968;
        dArray[3][11] = 1.671819705718;
        dArray[3][12] = 1.0879120879121;
        dArray[3][13] = 0.19340659340659;
        dArray[3][14] = 0.73949579831933;
        dArray[3][15] = 3.4196528109572;
        dArray[3][16] = 2.4749487800335;
        dArray[3][17] = 0.34536891679749;
        dArray[3][18] = 2.6895604395604;
        dArray[3][19] = 1.8608058608059;
        dArray[4][5] = 0.55191637630662;
        dArray[4][6] = 0.32442396313364;
        dArray[4][7] = 3.3297297297297;
        dArray[4][8] = 4.3726708074534;
        dArray[4][9] = 0.91868131868132;
        dArray[4][10] = 0.99466248037677;
        dArray[4][11] = 0.29830508474576;
        dArray[4][12] = 2.4095238095238;
        dArray[4][13] = 4.1485714285714;
        dArray[4][14] = 0.73949579831933;
        dArray[4][15] = 12.862939958592;
        dArray[4][16] = 2.8125907990315;
        dArray[4][17] = 6.8244897959184;
        dArray[4][18] = 12.885714285714;
        dArray[4][19] = 3.7714285714286;
        dArray[5][6] = 20.316061593796;
        dArray[5][7] = 1.3922214897825;
        dArray[5][8] = 33.861536130889;
        dArray[5][9] = 0.47172339855267;
        dArray[5][10] = 4.2320327755868;
        dArray[5][11] = 17.835941652395;
        dArray[5][12] = 2.65737514518;
        dArray[5][13] = 0.27595818815331;
        dArray[5][14] = 9.4992143198743;
        dArray[5][15] = 3.2350653941322;
        dArray[5][16] = 3.0973838067678;
        dArray[5][17] = 1.0512692882031;
        dArray[5][18] = 1.5331010452962;
        dArray[5][19] = 1.0778164924506;
        dArray[6][7] = 6.6857641051189;
        dArray[6][8] = 1.4458024443999;
        dArray[6][9] = 0.67068415455512;
        dArray[6][10] = 0.57932850559579;
        dArray[6][11] = 10.365070686558;
        dArray[6][12] = 1.0138248847926;
        dArray[6][13] = 0.26359447004608;
        dArray[6][14] = 1.1291226167887;
        dArray[6][15] = 1.8337006611901;
        dArray[6][16] = 1.9520424900414;
        dArray[6][17] = 0.69519420671494;
        dArray[6][18] = 0.38018433179723;
        dArray[6][19] = 2.7772657450077;
        dArray[7][8] = 1.2113479939567;
        dArray[7][9] = 0.32670032670033;
        dArray[7][10] = 0.41817641817642;
        dArray[7][11] = 1.6354950592239;
        dArray[7][12] = 0.76447876447876;
        dArray[7][13] = 0.30579150579151;
        dArray[7][14] = 1.2391551215081;
        dArray[7][15] = 11.138492529797;
        dArray[7][16] = 1.8888816176952;
        dArray[7][17] = 3.3491450634308;
        dArray[7][18] = 0.31853281853282;
        dArray[7][19] = 2.8416988416988;
        dArray[8][9] = 1.0931677018634;
        dArray[8][10] = 3.219438946147;
        dArray[8][11] = 3.1498052426571;
        dArray[8][12] = 1.9130434782609;
        dArray[8][13] = 2.7329192546584;
        dArray[8][14] = 6.7304834977469;
        dArray[8][15] = 4.3726708074534;
        dArray[8][16] = 2.8162964522581;
        dArray[8][17] = 0.78083407275954;
        dArray[8][18] = 35.11801242236;
        dArray[8][19] = 0.7287784679089;
        dArray[9][10] = 14.069798333535;
        dArray[9][11] = 1.2292791953809;
        dArray[9][12] = 28.3663003663;
        dArray[9][13] = 4.7384615384615;
        dArray[9][14] = 0.58780435251023;
        dArray[9][15] = 2.4105749323141;
        dArray[9][16] = 15.243062022723;
        dArray[9][17] = 0.82888540031397;
        dArray[9][18] = 1.8434065934066;
        dArray[9][19] = 57.699633699634;
        dArray[10][11] = 0.88039805231089;
        dArray[10][12] = 22.425954997384;
        dArray[10][13] = 15.099529042386;
        dArray[10][14] = 6.2626896912611;
        dArray[10][15] = 3.4917298022888;
        dArray[10][16] = 1.6109411169944;
        dArray[10][17] = 3.2366001345593;
        dArray[10][18] = 1.4505494505495;
        dArray[10][19] = 10.557823129252;
        dArray[11][12] = 3.6577885391445;
        dArray[11][13] = 0.14915254237288;
        dArray[11][14] = 1.2868062479229;
        dArray[11][15] = 2.8162964522581;
        dArray[11][16] = 5.7494151926786;
        dArray[11][17] = 0.54790729851263;
        dArray[11][18] = 0.53268765133172;
        dArray[11][19] = 0.74899112187248;
        dArray[12][13] = 2.5666666666667;
        dArray[12][14] = 0.94491129785247;
        dArray[12][15] = 1.639751552795;
        dArray[12][16] = 12.180790960452;
        dArray[12][17] = 1.1972789115646;
        dArray[12][18] = 1.1130952380952;
        dArray[12][19] = 17.746031746032;
        dArray[13][14] = 0.88739495798319;
        dArray[13][15] = 5.6298136645963;
        dArray[13][16] = 0.83099273607748;
        dArray[13][17] = 3.3224489795918;
        dArray[13][18] = 33.392857142857;
        dArray[13][19] = 3.6;
        dArray[14][15] = 16.261762676085;
        dArray[14][16] = 6.8852490148602;
        dArray[14][17] = 0.42256902761104;
        dArray[14][18] = 0.67787114845938;
        dArray[14][19] = 1.2549019607843;
        dArray[15][16] = 27.891216619293;
        dArray[15][17] = 1.8740017746229;
        dArray[15][18] = 3.7349896480331;
        dArray[15][19] = 2.4182194616977;
        dArray[16][17] = 0.487028709789;
        dArray[16][18] = 1.1985472154964;
        dArray[16][19] = 6.7925746569814;
        dArray[17][18] = 4.6020408163265;
        dArray[17][19] = 1.469387755102;
        dArray[18][19] = 1.0;
        return dArray;
    }

    @Override
    public double[] getEmpiricalFrequencies() {
        double[] dArray = new double[]{0.077, 0.051, 0.043, 0.052, 0.02, 0.041, 0.062, 0.074, 0.023, 0.052, 0.091, 0.059, 0.024, 0.04, 0.051, 0.069, 0.059, 0.014, 0.032, 0.066};
        return dArray;
    }

    @Override
    public int[] getEncodingOrder() {
        Aminoacid aminoacid = new Aminoacid();
        String string = aminoacid.getCodeMap();
        int[] nArray = new int[aminoacid.getStateCount()];
        String string2 = "ARNDCQEGHILKMFPSTWYV";
        for (int i = 0; i < aminoacid.getStateCount(); ++i) {
            nArray[i] = string2.indexOf(string.charAt(i));
        }
        return nArray;
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Aminoacid;
    }
}

