/*
 * Decompiled with CFR 0.152.
 */
package jam.toolbar;

import jam.toolbar.ToolbarItem;
import jam.toolbar.ToolbarOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Toolbar
extends JToolBar {
    private ToolbarOptions options;
    private final JRadioButtonMenuItem iconTextMenuItem;
    private final JRadioButtonMenuItem iconOnlyMenuItem;
    private final JRadioButtonMenuItem textOnlyMenuItem;
    private final JCheckBoxMenuItem smallSizeMenuItem;
    private List<ToolbarItem> toolbarItems = new ArrayList<ToolbarItem>();

    public Toolbar() {
        this(new ToolbarOptions(0, false));
    }

    public Toolbar(ToolbarOptions options) {
        this.options = options;
        this.putClientProperty("Quaqua.ToolBar.isDividerDrawn", Boolean.TRUE);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.setLayout(new GridBagLayout());
        if (options != null) {
            final JPopupMenu menu = new JPopupMenu();
            menu.setLightWeightPopupEnabled(false);
            ChangeListener listener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    Toolbar.this.toolbarOptionsChanged();
                }
            };
            ButtonGroup group = new ButtonGroup();
            this.iconTextMenuItem = new JRadioButtonMenuItem("Icon & Text");
            this.iconTextMenuItem.addChangeListener(listener);
            group.add(this.iconTextMenuItem);
            menu.add(this.iconTextMenuItem);
            this.iconOnlyMenuItem = new JRadioButtonMenuItem("Icon Only");
            this.iconOnlyMenuItem.addChangeListener(listener);
            group.add(this.iconOnlyMenuItem);
            menu.add(this.iconOnlyMenuItem);
            this.textOnlyMenuItem = new JRadioButtonMenuItem("Text Only");
            this.textOnlyMenuItem.addChangeListener(listener);
            group.add(this.textOnlyMenuItem);
            menu.add(this.textOnlyMenuItem);
            menu.add(new JSeparator());
            this.smallSizeMenuItem = new JCheckBoxMenuItem("Small Size");
            this.smallSizeMenuItem.addChangeListener(listener);
            menu.add(this.smallSizeMenuItem);
            menu.add(new JSeparator());
            JMenuItem item = new JMenuItem("Customize Toolbar...");
            item.setEnabled(false);
            menu.add(item);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        menu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        menu.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            });
            this.iconTextMenuItem.setSelected(options.getDisplay() == 0);
            this.iconOnlyMenuItem.setSelected(options.getDisplay() == 1);
            this.textOnlyMenuItem.setSelected(options.getDisplay() == 2);
            this.smallSizeMenuItem.setSelected(options.getSmallSize());
        } else {
            this.iconTextMenuItem = null;
            this.iconOnlyMenuItem = null;
            this.textOnlyMenuItem = null;
            this.smallSizeMenuItem = null;
        }
    }

    public void addComponent(JComponent component) {
        if (component instanceof ToolbarItem) {
            ToolbarItem item = (ToolbarItem)((Object)component);
            this.toolbarItems.add(item);
            item.setToolbarOptions(this.options);
        }
        this.addItem(component);
    }

    @Override
    public void addSeparator() {
        super.addSeparator();
    }

    public void addSpace() {
        this.addItem(new JToolBar.Separator());
    }

    private void addItem(JComponent item) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = 0;
        c.weightx = 0.0;
        this.add((Component)item, c);
    }

    public void addFlexibleSpace() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = -1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add((Component)new JToolBar.Separator(), c);
    }

    private void toolbarOptionsChanged() {
        int display = this.iconTextMenuItem.isSelected() ? 0 : (this.iconOnlyMenuItem.isSelected() ? 1 : 2);
        boolean smallSize = this.smallSizeMenuItem.isSelected();
        this.setToolbarOptions(new ToolbarOptions(display, smallSize));
    }

    private void setToolbarOptions(ToolbarOptions toolbarOptions) {
        this.options = toolbarOptions;
        for (ToolbarItem item : this.toolbarItems) {
            item.setToolbarOptions(this.options);
        }
        this.validate();
        this.repaint();
    }
}

