/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.mouse;

import blue.score.ScoreObject;
import blue.score.layers.LayerGroup;
import blue.soundObject.PolyObject;
import blue.ui.core.score.ModeManager;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScoreMode;
import blue.ui.core.score.layers.soundObject.ScoreObjectEditorTopComponent;
import blue.ui.core.score.mouse.BlueMouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import org.openide.windows.WindowManager;

public class ScoreObjectSelectionListener
extends BlueMouseAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
        if (ModeManager.getInstance().getMode() != ScoreMode.SCORE) {
            return;
        }
        if (currentScoreObjectView == null) {
            return;
        }
        Object scoreObj = currentScoreObjectView.getScoreObject();
        Collection selectedScoreObjects = scoreTC.getLookup().lookupAll(ScoreObject.class);
        if (e.isShiftDown()) {
            if (selectedScoreObjects.contains(scoreObj)) {
                ScoreController.getInstance().removeSelectedScoreObject((ScoreObject)scoreObj);
            } else {
                ScoreController.getInstance().addSelectedScoreObject((ScoreObject)scoreObj);
            }
            e.consume();
        } else if (!selectedScoreObjects.contains(scoreObj)) {
            ScoreController.getInstance().setSelectedScoreObjects(Collections.singleton(scoreObj));
            e.consume();
        } else if (e.getClickCount() == 2) {
            this.editScoreObject(selectedScoreObjects, (ScoreObject)scoreObj);
            e.consume();
        }
    }

    protected void editScoreObject(Collection<? extends ScoreObject> selectedScoreObjects, ScoreObject scoreObj) {
        if (scoreObj instanceof PolyObject) {
            PolyObject pObj = (PolyObject)scoreObj;
            ScoreController.getInstance().editLayerGroup((LayerGroup)pObj);
        } else if (selectedScoreObjects.size() == 1) {
            ScoreObjectEditorTopComponent editor = (ScoreObjectEditorTopComponent)WindowManager.getDefault().findTopComponent("ScoreObjectEditorTopComponent");
            if (!editor.isOpened()) {
                editor.open();
            }
            editor.requestActive();
        }
    }

    @Override
    public boolean acceptsMode(ScoreMode mode) {
        return mode == ScoreMode.SCORE;
    }
}

