/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.soundLayer;

import blue.BlueSystem;
import blue.SoundLayer;
import blue.noteProcessor.NoteProcessorChainMap;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.soundObject.PolyObject;
import blue.ui.core.score.soundLayer.SoundLayerLayout;
import blue.ui.core.score.soundLayer.SoundLayerPanel;
import blue.ui.utilities.SelectionModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import skt.swing.SwingUtil;

public class LayersPanel
extends JComponent
implements LayerGroupListener {
    private SoundLayerLayout layout = new SoundLayerLayout();
    private PolyObject pObj = null;
    private NoteProcessorChainMap npcMap = null;
    private SelectionModel selection = new SelectionModel();
    JPopupMenu menu;

    public LayersPanel() {
        this.setLayout(this.layout);
        this.setMinimumSize(new Dimension(0, 0));
        LayerAddAction layerAddAction = new LayerAddAction();
        final LayerRemoveAction layerRemoveAction = new LayerRemoveAction();
        final PushUpAction pushUpAction = new PushUpAction();
        final PushDownAction pushDownAction = new PushDownAction();
        this.menu = new JPopupMenu("Layer Operations"){

            @Override
            public void show(Component invoker, int x, int y) {
                if (LayersPanel.this.pObj == null) {
                    return;
                }
                layerRemoveAction.setEnabled(LayersPanel.this.pObj.size() >= 2);
                pushUpAction.setEnabled(LayersPanel.this.selection.getStartIndex() >= 1);
                pushDownAction.setEnabled(LayersPanel.this.selection.getEndIndex() < LayersPanel.this.pObj.size() - 1);
                super.show(invoker, x, y);
            }
        };
        this.menu.add(layerAddAction);
        this.menu.add(layerRemoveAction);
        this.menu.add(pushUpAction);
        this.menu.add(pushDownAction);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                LayersPanel.this.requestFocus();
                if (me.isPopupTrigger()) {
                    Component c = LayersPanel.this.getComponentAt(me.getPoint());
                    int index = LayersPanel.this.getIndexOfComponent(c);
                    if (index > LayersPanel.this.selection.getEndIndex() || index < LayersPanel.this.selection.getStartIndex()) {
                        LayersPanel.this.selection.setAnchor(index);
                    }
                    LayersPanel.this.menu.show(me.getComponent(), me.getX(), me.getY());
                } else if (SwingUtilities.isLeftMouseButton(me)) {
                    Component c;
                    if (me.getClickCount() == 1) {
                        Component c2 = LayersPanel.this.getComponentAt(me.getPoint());
                        int index = LayersPanel.this.getIndexOfComponent(c2);
                        if (index < 0) {
                            return;
                        }
                        if (me.isShiftDown()) {
                            LayersPanel.this.selection.setEnd(index);
                        } else {
                            LayersPanel.this.selection.setAnchor(index);
                        }
                    } else if (me.getClickCount() == 2 && (c = SwingUtilities.getDeepestComponentAt(LayersPanel.this, me.getX(), me.getY())) != null && c instanceof JLabel) {
                        Component panel = LayersPanel.this.getComponentAt(me.getPoint());
                        ((SoundLayerPanel)panel).editName();
                    }
                }
            }
        });
        this.selection.addChangeListener(e -> this.updateSelection());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    LayersPanel.this.selection.setAnchor(-1);
                }
            }
        });
        this.initActions();
    }

    private void initActions() {
        SwingUtil.installActions((JComponent)this, (Action[])new Action[]{new ShiftUpAction(), new UpAction(), new ShiftDownAction(), new DownAction()}, (int)1);
    }

    private int getIndexOfComponent(Component c) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void setPolyObject(PolyObject pObj) {
        if (this.pObj != null) {
            this.pObj.removeLayerGroupListener((LayerGroupListener)this);
        }
        this.layout.setPolyObject((LayerGroup)pObj);
        this.pObj = pObj;
        this.populate();
    }

    private void populate() {
        this.checkSize();
        this.removeAll();
        if (this.pObj == null) {
            return;
        }
        for (SoundLayer sLayer : this.pObj) {
            SoundLayerPanel panel = new SoundLayerPanel(sLayer, this.npcMap);
            this.add(panel);
        }
        this.revalidate();
    }

    public void checkSize() {
        if (this.pObj == null || this.getParent() == null) {
            this.setSize(0, 0);
            return;
        }
        int w = this.getParent().getWidth();
        int h = this.pObj.getTotalHeight();
        this.setSize(w, h * this.pObj.size());
    }

    private void updateSelection() {
        int start = this.selection.getStartIndex();
        int end = this.selection.getEndIndex();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            SoundLayerPanel panel = (SoundLayerPanel)comps[i];
            panel.setSelected(i >= start && i <= end);
        }
    }

    public SelectionModel getSelectionModel() {
        return this.selection;
    }

    public void setNoteProcessorChainMap(NoteProcessorChainMap npcMap) {
        this.npcMap = npcMap;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.pObj != null) {
            this.pObj.addLayerGroupListener((LayerGroupListener)this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.pObj != null) {
            this.pObj.removeLayerGroupListener((LayerGroupListener)this);
        }
    }

    public void layerGroupChanged(LayerGroupDataEvent event) {
        switch (event.getType()) {
            case 0: {
                this.layersAdded(event);
                break;
            }
            case 1: {
                this.layersRemoved(event);
                break;
            }
            case 2: {
                this.contentsChanged(event);
            }
        }
    }

    public void layersAdded(LayerGroupDataEvent e) {
        int index = e.getStartIndex();
        SoundLayer sLayer = (SoundLayer)this.pObj.get(index);
        SoundLayerPanel panel = new SoundLayerPanel(sLayer, this.npcMap);
        this.add((Component)panel, index);
        this.checkSize();
        this.revalidate();
    }

    public void layersRemoved(LayerGroupDataEvent e) {
        int end;
        int start = e.getStartIndex();
        for (int i = end = e.getEndIndex(); i >= start; --i) {
            this.remove(i);
        }
        this.checkSize();
        this.selection.setAnchor(-1);
        this.revalidate();
    }

    public void contentsChanged(LayerGroupDataEvent e) {
        boolean isUp;
        int start = e.getStartIndex();
        int end = e.getEndIndex();
        boolean bl = isUp = start >= 0 && end >= 0;
        if (isUp) {
            Component c = this.getComponent(start);
            SoundLayerPanel panel = (SoundLayerPanel)c;
            this.remove(start);
            this.add(c, end);
            int i1 = this.selection.getStartIndex() - 1;
            int i2 = this.selection.getEndIndex() - 1;
            this.selection.setAnchor(i1);
            this.selection.setEnd(i2);
        } else {
            Component c = this.getComponent(-start);
            SoundLayerPanel panel = (SoundLayerPanel)c;
            this.remove(-start);
            this.add(c, -end);
            int i1 = this.selection.getStartIndex() + 1;
            int i2 = this.selection.getEndIndex() + 1;
            this.selection.setAnchor(i1);
            this.selection.setEnd(i2);
        }
        this.revalidate();
    }

    class LayerRemoveAction
    extends AbstractAction {
        public LayerRemoveAction() {
            super("Remove Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = LayersPanel.this.selection.getStartIndex();
            int end = LayersPanel.this.selection.getEndIndex();
            if (end < 0 || LayersPanel.this.pObj.size() < 2) {
                return;
            }
            int len = end - start + 1;
            String message = BlueSystem.getString((String)"soundLayerEditPanel.delete.message1") + " " + len + " " + BlueSystem.getString((String)"soundLayerEditPanel.delete.message2");
            if (JOptionPane.showConfirmDialog(null, message) == 0) {
                LayersPanel.this.pObj.removeLayers(start, end);
                LayersPanel.this.selection.setAnchor(-1);
            }
        }
    }

    class LayerAddAction
    extends AbstractAction {
        public LayerAddAction() {
            super("Add Layer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int end = LayersPanel.this.selection.getEndIndex();
            if (end < 0) {
                return;
            }
            LayersPanel.this.pObj.newLayerAt(++end);
        }
    }

    class PushDownAction
    extends AbstractAction {
        public PushDownAction() {
            super("Push Down Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = LayersPanel.this.selection.getStartIndex();
            int end = LayersPanel.this.selection.getEndIndex();
            if (end < 0 || end >= LayersPanel.this.pObj.size() - 1) {
                return;
            }
            LayersPanel.this.pObj.pushDownLayers(start, end);
            LayersPanel.this.selection.setAnchor(start + 1);
        }
    }

    class PushUpAction
    extends AbstractAction {
        public PushUpAction() {
            super("Push Up Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = LayersPanel.this.selection.getStartIndex();
            int end = LayersPanel.this.selection.getEndIndex();
            if (end < 0 || start == 0) {
                return;
            }
            LayersPanel.this.pObj.pushUpLayers(start, end);
            LayersPanel.this.selection.setAnchor(start - 1);
        }
    }

    class ShiftDownAction
    extends AbstractAction {
        public ShiftDownAction() {
            super("shift-Down");
            this.putValue("ShortDescription", "Shift-Down Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 64));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            int index = LayersPanel.this.selection.getLastIndexSet() + 1;
            index = index >= (length = LayersPanel.this.getComponents().length) ? length - 1 : index;
            LayersPanel.this.selection.setEnd(index);
        }
    }

    class DownAction
    extends AbstractAction {
        public DownAction() {
            super("down");
            this.putValue("ShortDescription", "Down Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            int index = LayersPanel.this.selection.getLastIndexSet() + 1;
            index = index >= (length = LayersPanel.this.getComponents().length) ? length - 1 : index;
            LayersPanel.this.selection.setAnchor(index);
        }
    }

    class ShiftUpAction
    extends AbstractAction {
        public ShiftUpAction() {
            super("shift-up");
            this.putValue("ShortDescription", "Shift-Up Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 64));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = LayersPanel.this.selection.getLastIndexSet() - 1;
            index = index < 0 ? 0 : index;
            LayersPanel.this.selection.setEnd(index);
        }
    }

    class UpAction
    extends AbstractAction {
        public UpAction() {
            super("up");
            this.putValue("ShortDescription", "Up Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = LayersPanel.this.selection.getLastIndexSet() - 1;
            index = index < 0 ? 0 : index;
            LayersPanel.this.selection.setAnchor(index);
        }
    }
}

