/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.Arrangement;
import blue.Tables;
import blue.automation.Automatable;
import blue.automation.Parameter;
import blue.automation.ParameterList;
import blue.automation.ParameterNameManager;
import blue.mixer.Channel;
import blue.orchestra.Instrument;
import blue.orchestra.blueSynthBuilder.StringChannel;
import blue.orchestra.blueSynthBuilder.StringChannelNameManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CompileData {
    private final HashMap compileMap = new HashMap();
    private final Arrangement arrangement;
    private final Tables tables;
    private final Map<Channel, Integer> channelIdAssignments;
    private final Map<Instrument, String> instrSourceId;
    private boolean handleParametersAndChannels = true;
    private StringBuilder globalOrc;
    private ArrayList<StringChannel> stringChannels = null;
    private ArrayList originalParameters = null;
    private StringChannelNameManager scnm = null;
    private ParameterNameManager pnm;

    public static CompileData createEmptyCompileData() {
        CompileData compileData = new CompileData(new Arrangement(), new Tables());
        return compileData;
    }

    public CompileData(Arrangement arrangement, Tables tables) {
        this.arrangement = arrangement;
        this.tables = tables;
        this.channelIdAssignments = new HashMap<Channel, Integer>();
        this.instrSourceId = new HashMap<Instrument, String>();
        this.globalOrc = new StringBuilder();
        this.setHandleParametersAndChannels(false);
    }

    public CompileData(Arrangement arrangement, Tables tables, ArrayList<StringChannel> stringChannels, ArrayList originalParameters, StringChannelNameManager scnm, ParameterNameManager pnm) {
        this.arrangement = arrangement;
        this.tables = tables;
        this.stringChannels = stringChannels;
        this.originalParameters = originalParameters;
        this.scnm = scnm;
        this.pnm = pnm;
        this.channelIdAssignments = new HashMap<Channel, Integer>();
        this.instrSourceId = new HashMap<Instrument, String>();
        this.globalOrc = new StringBuilder();
        this.setHandleParametersAndChannels(true);
    }

    public void setHandleParametersAndChannels(boolean handleParametersAndChannels) {
        this.handleParametersAndChannels = handleParametersAndChannels;
    }

    public int addInstrument(Instrument instrument) {
        if (this.handleParametersAndChannels && this.stringChannels != null && this.originalParameters != null && instrument instanceof Automatable) {
            ParameterList paramList;
            Automatable auto = (Automatable)((Object)instrument);
            ArrayList<StringChannel> tempStringChannels = auto.getStringChannels();
            if (tempStringChannels != null) {
                this.stringChannels.addAll(tempStringChannels);
                for (StringChannel sChan : tempStringChannels) {
                    sChan.setChannelName(this.scnm.getUniqueStringChannel());
                }
            }
            if ((paramList = auto.getParameterList()) != null) {
                this.originalParameters.addAll(paramList);
                Iterator iterator = paramList.iterator();
                while (iterator.hasNext()) {
                    Parameter param = (Parameter)iterator.next();
                    param.setCompilationVarName(this.pnm.getUniqueParamName());
                }
            }
        }
        return this.arrangement.addInstrument(instrument);
    }

    public Object getCompilationVariable(Object key) {
        if (!this.compileMap.containsKey(key)) {
            return null;
        }
        return this.compileMap.get(key);
    }

    public void setCompilationVariable(Object key, Object value) {
        this.compileMap.put(key, value);
    }

    public int getOpenFTableNumber() {
        return this.tables.getOpenFTableNumber();
    }

    public void appendTables(String tablesString) {
        this.tables.setTables(this.tables.getTables() + "\n" + tablesString);
    }

    public Map<Channel, Integer> getChannelIdAssignments() {
        return this.channelIdAssignments;
    }

    public void addInstrSourceId(Instrument instr, String sourceId) {
        this.instrSourceId.put(instr, sourceId);
    }

    public String getInstrSourceId(Instrument instr) {
        return this.instrSourceId.get(instr);
    }

    public void appendGlobalOrc(String orcText) {
        if (orcText != null) {
            this.globalOrc.append(orcText).append("\n");
        }
    }

    public String getGlobalOrc() {
        return this.globalOrc.toString();
    }
}

