/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueSynthBuilder;

import blue.automation.Parameter;
import blue.automation.ParameterListener;
import blue.automation.ParameterTimeManagerFactory;
import blue.orchestra.blueSynthBuilder.AutomatableBSBObject;
import blue.orchestra.blueSynthBuilder.BSBCompilationUnit;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.BSBVSlider;
import blue.orchestra.blueSynthBuilder.ClampedValue;
import blue.orchestra.blueSynthBuilder.ClampedValueListener;
import blue.orchestra.blueSynthBuilder.Randomizable;
import blue.utility.NumberUtilities;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class BSBVSliderBank
extends AutomatableBSBObject
implements ParameterListener,
Randomizable {
    private static MessageFormat KEY_FMT = new MessageFormat("{0}_{1}");
    private ClampedValue value;
    private IntegerProperty sliderHeight = new SimpleIntegerProperty(150);
    private IntegerProperty gap = new SimpleIntegerProperty(5);
    private BooleanProperty randomizable = new SimpleBooleanProperty(true);
    private BooleanProperty valueDisplayEnabled = new SimpleBooleanProperty(true);
    private final ObservableList<BSBVSlider> sliders = FXCollections.observableArrayList();
    final ChangeListener<? super Number> cl = (obs, old, newVal) -> {
        if (this.parameters != null) {
            int index = this.sliders.indexOf((Object)obs);
            if (index < 0) {
                return;
            }
            Object[] vals = new Object[]{this.getObjectName(), new Integer(index)};
            String key = KEY_FMT.format(vals);
            Parameter param = this.parameters.getParameter(key);
            if (param != null) {
                param.setValue(newVal.doubleValue());
            }
        }
    };
    private final ListChangeListener<BSBVSlider> listChangeListener = new ListChangeListener<BSBVSlider>(){

        public void onChanged(ListChangeListener.Change<? extends BSBVSlider> c) {
            while (c.next()) {
                if (c.wasPermutated() || c.wasUpdated()) continue;
                for (BSBVSlider remItem : c.getRemoved()) {
                    remItem.maximumProperty().unbind();
                    remItem.minimumProperty().unbind();
                    remItem.sliderHeightProperty().unbind();
                    remItem.randomizableProperty().unbind();
                    remItem.valueDisplayEnabledProperty().unbind();
                    remItem.resolutionProperty().unbind();
                    remItem.valueProperty().removeListener(BSBVSliderBank.this.cl);
                }
                for (BSBVSlider addItem : c.getAddedSubList()) {
                    addItem.maximumProperty().bind((ObservableValue)BSBVSliderBank.this.maximumProperty());
                    addItem.minimumProperty().bind((ObservableValue)BSBVSliderBank.this.minimumProperty());
                    addItem.sliderHeightProperty().bind((ObservableValue)BSBVSliderBank.this.sliderHeightProperty());
                    addItem.randomizableProperty().bind((ObservableValue)BSBVSliderBank.this.randomizableProperty());
                    addItem.resolutionProperty().bind(BSBVSliderBank.this.resolutionProperty());
                    addItem.valueDisplayEnabledProperty().bind((ObservableValue)BSBVSliderBank.this.valueDisplayEnabledProperty());
                    addItem.valueProperty().addListener(BSBVSliderBank.this.cl);
                }
            }
        }
    };
    ClampedValueListener cvl = (pType, bType) -> {
        if (null != pType) {
            switch (pType) {
                case MIN: {
                    double v = this.getMinimum();
                    for (Parameter param : this.getParameters()) {
                        param.setMin(v, bType == ClampedValueListener.BoundaryType.TRUNCATE);
                    }
                    break;
                }
                case MAX: {
                    double v = this.getMaximum();
                    for (Parameter param : this.getParameters()) {
                        param.setMax(v, bType == ClampedValueListener.BoundaryType.TRUNCATE);
                    }
                    break;
                }
                case VALUE: {
                    double v = this.getMaximum();
                    for (Parameter param : this.getParameters()) {
                        if (param.isAutomationEnabled()) continue;
                        param.setMax(v, bType == ClampedValueListener.BoundaryType.TRUNCATE);
                    }
                    break;
                }
                case RESOLUTION: {
                    BigDecimal bdv = this.getResolution();
                    for (Parameter param : this.getParameters()) {
                        param.setResolution(bdv);
                    }
                    break;
                }
            }
        }
    };

    public BSBVSliderBank() {
        this.value = new ClampedValue(0.0, 1.0, 0.0, new BigDecimal("0.1"));
        this.value.addListener(this.cvl);
        this.sliders.addListener(this.listChangeListener);
        this.sliders.add((Object)new BSBVSlider());
    }

    public BSBVSliderBank(BSBVSliderBank bank) {
        super(bank);
        this.value = new ClampedValue(bank.value);
        this.value.addListener(this.cvl);
        this.sliders.addListener(this.listChangeListener);
        this.setValueDisplayEnabled(bank.isValueDisplayEnabled());
        for (BSBVSlider slider : bank.sliders) {
            this.sliders.add((Object)new BSBVSlider(slider));
        }
    }

    public final void setMinimum(double val) {
        this.value.setMin(val);
    }

    public final double getMinimum() {
        return this.value.getMin();
    }

    public final DoubleProperty minimumProperty() {
        return this.value.minProperty();
    }

    public final void setMaximum(double val) {
        this.value.setMax(val);
    }

    public final double getMaximum() {
        return this.value.getMax();
    }

    public final DoubleProperty maximumProperty() {
        return this.value.maxProperty();
    }

    public final void setResolution(BigDecimal val) {
        this.value.setResolution(val);
    }

    public final BigDecimal getResolution() {
        return this.value.getResolution();
    }

    public final ObjectProperty<BigDecimal> resolutionProperty() {
        return this.value.resolutionProperty();
    }

    public final void setSliderHeight(int value) {
        this.sliderHeight.set(value);
    }

    public final int getSliderHeight() {
        return this.sliderHeight.get();
    }

    public final IntegerProperty sliderHeightProperty() {
        return this.sliderHeight;
    }

    public final void setGap(int value) {
        this.gap.set(value);
    }

    public final int getGap() {
        return this.gap.get();
    }

    public final IntegerProperty gapProperty() {
        return this.gap;
    }

    @Override
    public final void setRandomizable(boolean value) {
        this.randomizable.set(value);
    }

    @Override
    public final boolean isRandomizable() {
        return this.randomizable.get();
    }

    public final BooleanProperty randomizableProperty() {
        return this.randomizable;
    }

    public final boolean isValueDisplayEnabled() {
        return this.valueDisplayEnabled.get();
    }

    public final void setValueDisplayEnabled(boolean enabled) {
        this.valueDisplayEnabled.set(enabled);
    }

    public final BooleanProperty valueDisplayEnabledProperty() {
        return this.valueDisplayEnabled;
    }

    @Override
    public void setObjectName(String objectName) {
        if (objectName == null || objectName.equals(this.getObjectName())) {
            return;
        }
        if (this.unm != null && !objectName.isEmpty()) {
            Object[] vals = new Object[2];
            vals[0] = objectName;
            for (int i = 0; i < this.sliders.size(); ++i) {
                vals[1] = new Integer(i);
                String objName = KEY_FMT.format(vals);
                if (this.unm.isUnique(objName)) continue;
                return;
            }
        }
        String oldName = this.getObjectName();
        boolean doInitialize = false;
        if (this.parameters != null && this.automationAllowed) {
            Object[] vals = new Object[2];
            vals[0] = oldName;
            Object[] vals2 = new Object[2];
            vals2[0] = objectName;
            if (!objectName.isEmpty()) {
                for (int i = 0; i < this.sliders.size(); ++i) {
                    vals[1] = new Integer(i);
                    String oldKey = KEY_FMT.format(vals);
                    this.parameters.removeParameter(oldKey);
                }
            } else {
                String oldKey;
                int i;
                boolean missingParameters = false;
                for (i = 0; i < this.sliders.size(); ++i) {
                    vals[1] = new Integer(i);
                    vals2[1] = new Integer(i);
                    oldKey = KEY_FMT.format(vals);
                    String newKey = KEY_FMT.format(vals2);
                    Parameter param = this.parameters.getParameter(oldKey);
                    if (param == null) {
                        missingParameters = true;
                        break;
                    }
                    param.setName(newKey);
                }
                if (missingParameters) {
                    for (i = 0; i < this.sliders.size(); ++i) {
                        vals[1] = new Integer(i);
                        oldKey = KEY_FMT.format(vals);
                        this.parameters.removeParameter(oldKey);
                    }
                    doInitialize = true;
                }
            }
        }
        this.objectNameProperty().set((Object)objectName);
        if (doInitialize) {
            this.initializeParameters();
        }
    }

    public ObservableList<BSBVSlider> getSliders() {
        return this.sliders;
    }

    private final void setValueProperty(ClampedValue value) {
        if (this.value != null) {
            this.value.removeListener(this.cvl);
        }
        this.value = value;
        value.addListener(this.cvl);
    }

    public static BSBObject loadFromXML(Element data) {
        BSBVSliderBank sliderBank = new BSBVSliderBank();
        double minVal = 0.0;
        double maxVal = 1.0;
        BigDecimal resolution = new BigDecimal("0.1");
        BSBVSliderBank.initBasicFromXML(data, sliderBank);
        Elements nodes = data.getElements();
        sliderBank.getSliders().clear();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "minimum": {
                    minVal = Double.parseDouble(node.getTextString());
                    break;
                }
                case "maximum": {
                    maxVal = Double.parseDouble(node.getTextString());
                    break;
                }
                case "resolution": {
                    resolution = new BigDecimal(Double.parseDouble(node.getTextString())).setScale(5, RoundingMode.HALF_UP).stripTrailingZeros();
                    break;
                }
                case "bdresolution": {
                    resolution = new BigDecimal(node.getTextString());
                    break;
                }
                case "sliderHeight": {
                    sliderBank.setSliderHeight(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "gap": {
                    sliderBank.setGap(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "randomizable": {
                    sliderBank.setRandomizable(XMLUtilities.readBoolean(node));
                    break;
                }
                case "valueDisplayEnabled": {
                    sliderBank.setValueDisplayEnabled(XMLUtilities.readBoolean(node));
                    break;
                }
                case "bsbObject": {
                    BSBVSlider hSlider = (BSBVSlider)BSBVSlider.loadFromXML(node);
                    sliderBank.getSliders().add((Object)hSlider);
                }
            }
        }
        sliderBank.setValueProperty(new ClampedValue(minVal, maxVal, 0.0, resolution));
        return sliderBank;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = BSBVSliderBank.getBasicXML(this);
        retVal.addElement(XMLUtilities.writeDouble("minimum", this.getMinimum()));
        retVal.addElement(XMLUtilities.writeDouble("maximum", this.getMaximum()));
        retVal.addElement("bdresolution").setText(this.getResolution().toString());
        retVal.addElement(XMLUtilities.writeInt("sliderHeight", this.getSliderHeight()));
        retVal.addElement(XMLUtilities.writeInt("gap", this.getGap()));
        retVal.addElement(XMLUtilities.writeBoolean("randomizable", this.isRandomizable()));
        retVal.addElement(XMLUtilities.writeBoolean("valueDisplayEnabled", this.isValueDisplayEnabled()));
        for (BSBVSlider hSlider : this.sliders) {
            retVal.addElement(hSlider.saveAsXML());
        }
        return retVal;
    }

    public int getNumberOfSliders() {
        return this.sliders.size();
    }

    public boolean willBeUnique(int numSliders) {
        Object[] vals = new Object[2];
        vals[0] = this.getObjectName();
        for (int i = this.getNumberOfSliders(); i < numSliders; ++i) {
            vals[1] = new Integer(i);
            String key = KEY_FMT.format(vals);
            if (this.unm.isUnique(key)) continue;
            return false;
        }
        return true;
    }

    public void setNumberOfSliders(int numSliders) {
        if (numSliders > 0 && numSliders != this.sliders.size()) {
            int diff = numSliders - this.sliders.size();
            String objectName = this.getObjectName();
            Object[] vals = new Object[2];
            vals[0] = objectName;
            if (diff > 0) {
                if (!this.willBeUnique(numSliders)) {
                    return;
                }
                BSBVSlider lastSlider = (BSBVSlider)this.sliders.get(this.sliders.size() - 1);
                for (int i = 0; i < diff; ++i) {
                    BSBVSlider copy = new BSBVSlider(lastSlider);
                    this.sliders.add((Object)copy);
                    if (this.parameters == null || objectName == null || objectName.trim().length() <= 0) continue;
                    vals[1] = new Integer(this.sliders.size() - 1);
                    String key = KEY_FMT.format(vals);
                    Parameter param = new Parameter();
                    param.setName(key);
                    if (this.getMinimum() > param.getMax()) {
                        param.setMax(this.getMaximum(), true);
                        param.setMin(this.getMinimum(), true);
                    } else {
                        param.setMin(this.getMinimum(), true);
                        param.setMax(this.getMaximum(), true);
                    }
                    param.setResolution(this.getResolution());
                    param.setValue(copy.getValue());
                    param.addParameterListener(this);
                    this.parameters.add(param);
                }
            } else {
                for (int i = 0; i < -diff; ++i) {
                    BSBVSlider slider = (BSBVSlider)this.sliders.get(this.sliders.size() - 1);
                    this.sliders.remove((Object)slider);
                    if (this.parameters == null || objectName == null || objectName.trim().length() <= 0) continue;
                    vals[1] = new Integer(this.sliders.size());
                    String key = KEY_FMT.format(vals);
                    this.parameters.removeParameter(key);
                }
            }
        }
        this.fireBSBObjectChanged();
    }

    @Override
    public void setupForCompilation(BSBCompilationUnit compilationUnit) {
        Object[] vals = new Object[2];
        vals[0] = this.getObjectName();
        for (int i = 0; i < this.sliders.size(); ++i) {
            Parameter param;
            BSBVSlider slider = (BSBVSlider)this.sliders.get(i);
            vals[1] = new Integer(i);
            String key = KEY_FMT.format(vals);
            if (this.parameters != null && (param = this.parameters.getParameter(key)) != null && param.getCompilationVarName() != null) {
                compilationUnit.addReplacementValue(key, param.getCompilationVarName());
                continue;
            }
            compilationUnit.addReplacementValue(key, NumberUtilities.formatDouble(slider.getValue()));
        }
    }

    @Override
    public String getPresetValue() {
        boolean first = true;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.sliders.size(); ++i) {
            if (first) {
                first = false;
            } else {
                buffer.append(":");
            }
            BSBVSlider slider = (BSBVSlider)this.sliders.get(i);
            buffer.append(Double.toString(slider.getValue()));
        }
        return buffer.toString();
    }

    @Override
    public void setPresetValue(String val) {
        String[] vals = val.split(":");
        int size = this.sliders.size() < vals.length ? this.sliders.size() : vals.length;
        for (int i = 0; i < size; ++i) {
            BSBVSlider slider = (BSBVSlider)this.sliders.get(i);
            slider.setValue(Double.parseDouble(vals[i]));
        }
    }

    @Override
    public String[] getReplacementKeys() {
        String objName = this.getObjectName().trim();
        if (objName.length() == 0) {
            return null;
        }
        String[] retVal = new String[this.sliders.size()];
        Object[] vals = new Object[2];
        vals[0] = this.getObjectName();
        for (int i = 0; i < this.sliders.size(); ++i) {
            String key;
            vals[1] = new Integer(i);
            retVal[i] = key = KEY_FMT.format(vals);
        }
        return retVal;
    }

    @Override
    public void initializeParameters() {
        int i;
        Object[] vals;
        if (this.parameters == null) {
            return;
        }
        String objectName = this.getObjectName();
        if (!this.automationAllowed && this.parameters != null && objectName != null && objectName.length() != 0) {
            vals = new Object[]{objectName, new Integer(0)};
            Parameter param = this.parameters.getParameter(KEY_FMT.format(vals));
            if (param != null && param.isAutomationEnabled()) {
                this.automationAllowed = true;
            } else {
                for (int i2 = 0; i2 < this.sliders.size(); ++i2) {
                    vals[1] = new Integer(i2);
                    String oldKey = KEY_FMT.format(vals);
                    this.parameters.removeParameter(oldKey);
                }
                return;
            }
        }
        if (objectName == null || objectName.trim().length() == 0) {
            return;
        }
        vals = new Object[2];
        vals[0] = this.getObjectName();
        boolean missingParameters = false;
        for (i = 0; i < this.sliders.size(); ++i) {
            vals[1] = new Integer(i);
            String key = KEY_FMT.format(vals);
            Parameter param = this.parameters.getParameter(key);
            if (param == null) {
                missingParameters = true;
                break;
            }
            if (!param.isAutomationEnabled()) {
                BSBVSlider slider = (BSBVSlider)this.sliders.get(i);
                param.setValue(slider.getValue());
            }
            param.addParameterListener(this);
        }
        if (!missingParameters) {
            return;
        }
        for (i = 0; i < this.sliders.size(); ++i) {
            BSBVSlider slider = (BSBVSlider)this.sliders.get(i);
            vals[1] = new Integer(i);
            String key = KEY_FMT.format(vals);
            this.parameters.removeParameter(key);
            Parameter param = new Parameter();
            param.setName(key);
            if (this.getMinimum() > param.getMax()) {
                param.setMax(this.getMaximum(), true);
                param.setMin(this.getMinimum(), true);
            } else {
                param.setMin(this.getMinimum(), true);
                param.setMax(this.getMaximum(), true);
            }
            param.setResolution(this.getResolution());
            param.setValue(slider.getValue());
            param.addParameterListener(this);
            this.parameters.add(param);
        }
    }

    @Override
    public void lineDataChanged(Parameter param) {
        double time = ParameterTimeManagerFactory.getInstance().getTime();
        String paramName = param.getName();
        String strIndex = paramName.substring(paramName.lastIndexOf(95) + 1);
        int sliderIndex = Integer.parseInt(strIndex);
        double val = param.getLine().getValue(time);
        BSBVSlider slider = (BSBVSlider)this.sliders.get(sliderIndex);
        slider.setValue(val);
    }

    @Override
    public void parameterChanged(Parameter param) {
    }

    @Override
    public void setAutomationAllowed(boolean allowAutomation) {
        this.automationAllowed = allowAutomation;
        String objectName = this.getObjectName();
        if (this.parameters != null) {
            if (allowAutomation) {
                this.initializeParameters();
            } else if (objectName != null && objectName.length() != 0) {
                Object[] vals = new Object[2];
                vals[0] = objectName;
                if (objectName != null && objectName.length() != 0) {
                    for (int i = 0; i < this.sliders.size(); ++i) {
                        vals[1] = new Integer(i);
                        String oldKey = KEY_FMT.format(vals);
                        this.parameters.removeParameter(oldKey);
                    }
                }
            }
        }
    }

    @Override
    public void randomize() {
        if (this.isRandomizable()) {
            this.sliders.stream().forEach(BSBVSlider::randomize);
        }
    }

    @Override
    public BSBObject deepCopy() {
        return new BSBVSliderBank(this);
    }

    private List<Parameter> getParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        if (this.parameters != null) {
            Object[] vals = new Object[2];
            vals[0] = this.getObjectName();
            for (int i = 0; i < this.sliders.size(); ++i) {
                vals[1] = new Integer(i);
                String key = KEY_FMT.format(vals);
                Parameter param = this.parameters.getParameter(key);
                if (param == null) continue;
                params.add(param);
            }
        }
        return params;
    }
}

