/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TTFDataStream;

public class KerningSubtable {
    private static final Log LOG = LogFactory.getLog(KerningSubtable.class);
    private static final int COVERAGE_HORIZONTAL = 1;
    private static final int COVERAGE_MINIMUMS = 2;
    private static final int COVERAGE_CROSS_STREAM = 4;
    private static final int COVERAGE_FORMAT = 65280;
    private static final int COVERAGE_HORIZONTAL_SHIFT = 0;
    private static final int COVERAGE_MINIMUMS_SHIFT = 1;
    private static final int COVERAGE_CROSS_STREAM_SHIFT = 2;
    private static final int COVERAGE_FORMAT_SHIFT = 8;
    private boolean horizontal;
    private boolean minimums;
    private boolean crossStream;
    private PairData pairs;

    KerningSubtable() {
    }

    public void read(TTFDataStream tTFDataStream, int n) throws IOException {
        if (n == 0) {
            this.readSubtable0(tTFDataStream);
        } else if (n == 1) {
            this.readSubtable1(tTFDataStream);
        } else {
            throw new IllegalStateException();
        }
    }

    public boolean isHorizontalKerning() {
        return this.isHorizontalKerning(false);
    }

    public boolean isHorizontalKerning(boolean bl) {
        if (!this.horizontal) {
            return false;
        }
        if (this.minimums) {
            return false;
        }
        if (bl) {
            return this.crossStream;
        }
        return !this.crossStream;
    }

    public int[] getKerning(int[] nArray) {
        int[] nArray2 = null;
        if (this.pairs != null) {
            int n = nArray.length;
            nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                int n3 = -1;
                for (int j = i + 1; j < n; ++j) {
                    int n4 = nArray[j];
                    if (n4 < 0) continue;
                    n3 = n4;
                    break;
                }
                nArray2[i] = this.getKerning(n2, n3);
            }
        } else {
            LOG.warn((Object)"No kerning subtable data available due to an unsupported kerning subtable version");
        }
        return nArray2;
    }

    public int getKerning(int n, int n2) {
        if (this.pairs == null) {
            LOG.warn((Object)"No kerning subtable data available due to an unsupported kerning subtable version");
            return 0;
        }
        return this.pairs.getKerning(n, n2);
    }

    private void readSubtable0(TTFDataStream tTFDataStream) throws IOException {
        int n;
        int n2 = tTFDataStream.readUnsignedShort();
        if (n2 != 0) {
            LOG.info((Object)("Unsupported kerning sub-table version: " + n2));
            return;
        }
        int n3 = tTFDataStream.readUnsignedShort();
        if (n3 < 6) {
            throw new IOException("Kerning sub-table too short, got " + n3 + " bytes, expect 6 or more.");
        }
        int n4 = tTFDataStream.readUnsignedShort();
        if (KerningSubtable.isBitsSet(n4, 1, 0)) {
            this.horizontal = true;
        }
        if (KerningSubtable.isBitsSet(n4, 2, 1)) {
            this.minimums = true;
        }
        if (KerningSubtable.isBitsSet(n4, 4, 2)) {
            this.crossStream = true;
        }
        if ((n = KerningSubtable.getBits(n4, 65280, 8)) == 0) {
            this.readSubtable0Format0(tTFDataStream);
        } else if (n == 2) {
            this.readSubtable0Format2(tTFDataStream);
        } else {
            LOG.debug((Object)("Skipped kerning subtable due to an unsupported kerning subtable version: " + n));
        }
    }

    private void readSubtable0Format0(TTFDataStream tTFDataStream) throws IOException {
        this.pairs = new PairData0Format0();
        this.pairs.read(tTFDataStream);
    }

    private void readSubtable0Format2(TTFDataStream tTFDataStream) throws IOException {
        LOG.info((Object)"Kerning subtable format 2 not yet supported.");
    }

    private void readSubtable1(TTFDataStream tTFDataStream) throws IOException {
        LOG.info((Object)"Kerning subtable format 1 not yet supported.");
    }

    private static boolean isBitsSet(int n, int n2, int n3) {
        return KerningSubtable.getBits(n, n2, n3) != 0;
    }

    private static int getBits(int n, int n2, int n3) {
        return (n & n2) >> n3;
    }

    private static class PairData0Format0
    implements Comparator<int[]>,
    PairData {
        private int searchRange;
        private int[][] pairs;

        private PairData0Format0() {
        }

        @Override
        public void read(TTFDataStream tTFDataStream) throws IOException {
            int n = tTFDataStream.readUnsignedShort();
            this.searchRange = tTFDataStream.readUnsignedShort() / 6;
            int n2 = tTFDataStream.readUnsignedShort();
            int n3 = tTFDataStream.readUnsignedShort();
            this.pairs = new int[n][3];
            for (int i = 0; i < n; ++i) {
                int n4 = tTFDataStream.readUnsignedShort();
                int n5 = tTFDataStream.readUnsignedShort();
                short s = tTFDataStream.readSignedShort();
                this.pairs[i][0] = n4;
                this.pairs[i][1] = n5;
                this.pairs[i][2] = s;
            }
        }

        @Override
        public int getKerning(int n, int n2) {
            int[] nArray = new int[]{n, n2, 0};
            int n3 = Arrays.binarySearch(this.pairs, nArray, this);
            if (n3 >= 0) {
                return this.pairs[n3][2];
            }
            return 0;
        }

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            assert (nArray != null);
            assert (nArray.length >= 2);
            assert (nArray2 != null);
            assert (nArray2.length >= 2);
            int n = nArray[0];
            int n2 = nArray2[0];
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            int n3 = nArray[1];
            int n4 = nArray2[1];
            if (n3 < n4) {
                return -1;
            }
            if (n3 > n4) {
                return 1;
            }
            return 0;
        }
    }

    private static interface PairData {
        public void read(TTFDataStream var1) throws IOException;

        public int getKerning(int var1, int var2);
    }
}

