/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.WGL4Names;

public class PostScriptTable
extends TTFTable {
    private float formatType;
    private float italicAngle;
    private short underlinePosition;
    private short underlineThickness;
    private long isFixedPitch;
    private long minMemType42;
    private long maxMemType42;
    private long mimMemType1;
    private long maxMemType1;
    private String[] glyphNames = null;
    public static final String TAG = "post";

    PostScriptTable(TrueTypeFont trueTypeFont) {
        super(trueTypeFont);
    }

    @Override
    public void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        this.formatType = tTFDataStream.read32Fixed();
        this.italicAngle = tTFDataStream.read32Fixed();
        this.underlinePosition = tTFDataStream.readSignedShort();
        this.underlineThickness = tTFDataStream.readSignedShort();
        this.isFixedPitch = tTFDataStream.readUnsignedInt();
        this.minMemType42 = tTFDataStream.readUnsignedInt();
        this.maxMemType42 = tTFDataStream.readUnsignedInt();
        this.mimMemType1 = tTFDataStream.readUnsignedInt();
        this.maxMemType1 = tTFDataStream.readUnsignedInt();
        if (this.formatType == 1.0f) {
            this.glyphNames = new String[258];
            System.arraycopy(WGL4Names.MAC_GLYPH_NAMES, 0, this.glyphNames, 0, 258);
        } else if (this.formatType == 2.0f) {
            int n;
            int n2;
            int n3 = tTFDataStream.readUnsignedShort();
            int[] nArray = new int[n3];
            this.glyphNames = new String[n3];
            int n4 = Integer.MIN_VALUE;
            for (int i = 0; i < n3; ++i) {
                nArray[i] = n2 = tTFDataStream.readUnsignedShort();
                if (n2 > Short.MAX_VALUE) continue;
                n4 = Math.max(n4, n2);
            }
            String[] stringArray = null;
            if (n4 >= 258) {
                stringArray = new String[n4 - 258 + 1];
                for (n2 = 0; n2 < n4 - 258 + 1; ++n2) {
                    n = tTFDataStream.readUnsignedByte();
                    stringArray[n2] = tTFDataStream.readString(n);
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray[n2];
                this.glyphNames[n2] = n < 258 ? WGL4Names.MAC_GLYPH_NAMES[n] : (n >= 258 && n <= Short.MAX_VALUE ? stringArray[n - 258] : ".undefined");
            }
        } else if (this.formatType == 2.5f) {
            int n;
            int[] nArray = new int[trueTypeFont.getNumberOfGlyphs()];
            for (n = 0; n < nArray.length; ++n) {
                int n5 = tTFDataStream.readSignedByte();
                nArray[n] = n + 1 + n5;
            }
            this.glyphNames = new String[nArray.length];
            for (n = 0; n < this.glyphNames.length; ++n) {
                String string = WGL4Names.MAC_GLYPH_NAMES[nArray[n]];
                if (string == null) continue;
                this.glyphNames[n] = string;
            }
        } else if (this.formatType == 3.0f) {
            // empty if block
        }
        this.initialized = true;
    }

    public float getFormatType() {
        return this.formatType;
    }

    public void setFormatType(float f) {
        this.formatType = f;
    }

    public long getIsFixedPitch() {
        return this.isFixedPitch;
    }

    public void setIsFixedPitch(long l) {
        this.isFixedPitch = l;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(float f) {
        this.italicAngle = f;
    }

    public long getMaxMemType1() {
        return this.maxMemType1;
    }

    public void setMaxMemType1(long l) {
        this.maxMemType1 = l;
    }

    public long getMaxMemType42() {
        return this.maxMemType42;
    }

    public void setMaxMemType42(long l) {
        this.maxMemType42 = l;
    }

    public long getMinMemType1() {
        return this.mimMemType1;
    }

    public void setMimMemType1(long l) {
        this.mimMemType1 = l;
    }

    public long getMinMemType42() {
        return this.minMemType42;
    }

    public void setMinMemType42(long l) {
        this.minMemType42 = l;
    }

    public short getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(short s) {
        this.underlinePosition = s;
    }

    public short getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(short s) {
        this.underlineThickness = s;
    }

    public String[] getGlyphNames() {
        return this.glyphNames;
    }

    public void setGlyphNames(String[] stringArray) {
        this.glyphNames = stringArray;
    }

    public String getName(int n) {
        if (n < 0 || this.glyphNames == null || n > this.glyphNames.length) {
            return null;
        }
        return this.glyphNames[n];
    }
}

