/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.ChannelManager;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomMemberIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.IrcStack;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import org.easymock.EasyMock;

public class ChatRoomIrcImplTest
extends TestCase {
    private ProtocolProviderServiceIrcImpl providerMock;
    private IrcStack stackMock;
    private IrcConnection connectionMock;
    private ChannelManager channelMock;

    public void setUp() throws Exception {
        super.setUp();
        this.providerMock = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        this.stackMock = (IrcStack)EasyMock.createMock(IrcStack.class);
        this.connectionMock = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        this.channelMock = (ChannelManager)EasyMock.createMock(ChannelManager.class);
        EasyMock.expect((Object)this.providerMock.getIrcStack()).andReturn((Object)this.stackMock);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        EasyMock.expect(this.channelMock.getChannelTypes()).andReturn(Collections.unmodifiableSet(Sets.newHashSet((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('&')})));
    }

    public void testConstruction() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        new ChatRoomIrcImpl("#test", this.providerMock);
    }

    public void testConstructionNullIdentifier() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        try {
            new ChatRoomIrcImpl(null, this.providerMock);
            ChatRoomIrcImplTest.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testConstructionNullProvider() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock});
        try {
            new ChatRoomIrcImpl("#test", null);
            ChatRoomIrcImplTest.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyName() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        try {
            new ChatRoomIrcImpl("", this.providerMock);
            ChatRoomIrcImplTest.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTooLongName() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        try {
            new ChatRoomIrcImpl("thisjustalittlebittoolongtobeachannelnamethereforeiexpectthetesttofailsoweshallseifthisisthecasethisjustalittlebittoolongtobeachannelnamethereforeiexpectthetesttofailsorweshallseeifthisisthecaseorweshallseeifthisisthecase", this.providerMock);
            ChatRoomIrcImplTest.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAutoPrefixBadChannelName() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("!test", this.providerMock);
        Assert.assertEquals((String)"#!test", (String)room.getIdentifier());
    }

    public void testIllegalNameSpace() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        try {
            new ChatRoomIrcImpl("#test test", this.providerMock);
            ChatRoomIrcImplTest.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIllegalNameComma() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        try {
            new ChatRoomIrcImpl("#test,test", this.providerMock);
            ChatRoomIrcImplTest.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidName() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
    }

    public void testCorrectConstruction() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertEquals((String)"#my-cool-channel", (String)room.getIdentifier());
        Assert.assertEquals((String)"#my-cool-channel", (String)room.getName());
        Assert.assertSame((Object)((Object)this.providerMock), (Object)room.getParentProvider());
    }

    public void testHashCodeNotFailing() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        room.hashCode();
    }

    public void testRoomIsJoined() {
        EasyMock.expect((Object)this.providerMock.getIrcStack()).andReturn((Object)this.stackMock).times(2);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock).times(2);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock).times(2);
        EasyMock.expect((Object)this.channelMock.isJoined((ChatRoomIrcImpl)((Object)EasyMock.anyObject(ChatRoomIrcImpl.class)))).andReturn((Object)false).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertFalse((boolean)room.isJoined());
        Assert.assertTrue((boolean)room.isJoined());
    }

    public void testIsPersistentRoom() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertTrue((boolean)room.isPersistent());
    }

    public void testDestroyRoom() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertTrue((boolean)room.destroy("whatever", null));
    }

    public void testSetLocalUserNull() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        try {
            room.setLocalUser(null);
            Assert.fail((String)"Should have failed with IAE.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetLocalUser() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertEquals((Object)ChatRoomMemberRole.SILENT_MEMBER, (Object)room.getUserRole());
        ChatRoomMemberIrcImpl user = (ChatRoomMemberIrcImpl)EasyMock.createMock(ChatRoomMemberIrcImpl.class);
        EasyMock.expect((Object)user.getRole()).andReturn((Object)ChatRoomMemberRole.ADMINISTRATOR).andReturn((Object)ChatRoomMemberRole.MEMBER);
        EasyMock.replay((Object[])new Object[]{user});
        room.setLocalUser(user);
        Assert.assertEquals((Object)ChatRoomMemberRole.ADMINISTRATOR, (Object)room.getUserRole());
        Assert.assertEquals((Object)ChatRoomMemberRole.MEMBER, (Object)room.getUserRole());
    }

    public void testMemberCount() {
        ChatRoomMemberIrcImpl user = (ChatRoomMemberIrcImpl)EasyMock.createMock(ChatRoomMemberIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock, user});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertEquals((int)0, (int)room.getMembersCount());
        room.addChatRoomMember("user", user);
        Assert.assertEquals((int)1, (int)room.getMembersCount());
        room.clearChatRoomMemberList();
        Assert.assertEquals((int)0, (int)room.getMembersCount());
    }

    public void testAddMember() {
        ChatRoomMemberIrcImpl user = (ChatRoomMemberIrcImpl)EasyMock.createMock(ChatRoomMemberIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock, user});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertNull((Object)room.getChatRoomMember("user"));
        room.addChatRoomMember("user", user);
        Assert.assertSame((Object)user, (Object)room.getChatRoomMember("user"));
    }

    public void testRemoveMember() {
        ChatRoomMemberIrcImpl user = (ChatRoomMemberIrcImpl)EasyMock.createMock(ChatRoomMemberIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock, user});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        room.addChatRoomMember("user", user);
        Assert.assertSame((Object)user, (Object)room.getChatRoomMember("user"));
        room.removeChatRoomMember("user");
        Assert.assertNull((Object)room.getChatRoomMember("user"));
    }

    public void testEqualsSame() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertTrue((boolean)room.equals((Object)room));
    }

    public void testEqualsNull() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertFalse((boolean)room.equals(null));
    }

    public void testEqualsOtherClassInstance() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertFalse((boolean)room.equals(new Object()));
    }

    public void testEqualsOtherProviderInstance() {
        ProtocolProviderServiceIrcImpl providerMock2 = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        EasyMock.expect((Object)providerMock2.getIrcStack()).andReturn((Object)this.stackMock);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        EasyMock.expect(this.channelMock.getChannelTypes()).andReturn(Collections.unmodifiableSet(Sets.newHashSet((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('$')})));
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock, providerMock2});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        ChatRoomIrcImpl room2 = new ChatRoomIrcImpl("#my-cool-channel", providerMock2);
        Assert.assertFalse((boolean)room.equals((Object)room2));
    }

    public void testEqualsOtherRoomInstance() {
        EasyMock.expect((Object)this.providerMock.getIrcStack()).andReturn((Object)this.stackMock);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        EasyMock.expect(this.channelMock.getChannelTypes()).andReturn(Collections.unmodifiableSet(Sets.newHashSet((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('$')})));
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        ChatRoomIrcImpl room2 = new ChatRoomIrcImpl("#my-cool-channel-2", this.providerMock);
        Assert.assertFalse((boolean)room.equals((Object)room2));
    }

    public void testEqualsSameRoomRepresentation() {
        EasyMock.expect((Object)this.providerMock.getIrcStack()).andReturn((Object)this.stackMock);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        EasyMock.expect(this.channelMock.getChannelTypes()).andReturn(Collections.unmodifiableSet(Sets.newHashSet((Object[])new Character[]{Character.valueOf('#'), Character.valueOf('$')})));
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        ChatRoomIrcImpl room2 = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertTrue((boolean)room.equals((Object)room2));
    }

    public void testGetChatRoomSubject() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertEquals((String)"", (String)room.getSubject());
    }

    public void testSetChatRoomSubject() throws OperationFailedException {
        String newSubject = "My test subject!";
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        this.channelMock.setSubject((ChatRoomIrcImpl)((Object)EasyMock.anyObject(ChatRoomIrcImpl.class)), (String)EasyMock.eq((Object)"My test subject!"));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.providerMock.getIrcStack()).andReturn((Object)this.stackMock);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        this.channelMock.setSubject((ChatRoomIrcImpl)((Object)EasyMock.anyObject(ChatRoomIrcImpl.class)), (String)EasyMock.eq((Object)"My test subject!"));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertEquals((String)"", (String)room.getSubject());
        room.setSubject("My test subject!");
        Assert.assertEquals((String)"", (String)room.getSubject());
    }

    public void testSetChatRoomSubjectFailedByIndirectIOException() throws OperationFailedException {
        String newSubject = "My test subject!";
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        this.channelMock.setSubject((ChatRoomIrcImpl)((Object)EasyMock.anyObject(ChatRoomIrcImpl.class)), (String)EasyMock.eq((Object)"My test subject!"));
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Some error", new IOException("Real cause")));
        EasyMock.expect((Object)this.providerMock.getIrcStack()).andReturn((Object)this.stackMock);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        this.channelMock.setSubject((ChatRoomIrcImpl)((Object)EasyMock.anyObject(ChatRoomIrcImpl.class)), (String)EasyMock.eq((Object)"My test subject!"));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertEquals((String)"", (String)room.getSubject());
        try {
            room.setSubject("My test subject!");
            Assert.fail((String)"Should have failed with OFE.");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public void testSetChatRoomSubjectFailedByOtherRuntimeException() throws OperationFailedException {
        String newSubject = "My test subject!";
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        this.channelMock.setSubject((ChatRoomIrcImpl)((Object)EasyMock.anyObject(ChatRoomIrcImpl.class)), (String)EasyMock.eq((Object)"My test subject!"));
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("Some error"));
        EasyMock.expect((Object)this.providerMock.getIrcStack()).andReturn((Object)this.stackMock);
        EasyMock.expect((Object)this.stackMock.getConnection()).andReturn((Object)this.connectionMock);
        EasyMock.expect((Object)this.connectionMock.getChannelManager()).andReturn((Object)this.channelMock);
        this.channelMock.setSubject((ChatRoomIrcImpl)((Object)EasyMock.anyObject(ChatRoomIrcImpl.class)), (String)EasyMock.eq((Object)"My test subject!"));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl room = new ChatRoomIrcImpl("#my-cool-channel", this.providerMock);
        Assert.assertEquals((String)"", (String)room.getSubject());
        try {
            room.setSubject("My test subject!");
            Assert.fail((String)"Should have failed with OFE.");
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }

    public void testChatRoomWithAlternativePrefix() {
        EasyMock.replay((Object[])new Object[]{this.providerMock, this.stackMock, this.connectionMock, this.channelMock});
        ChatRoomIrcImpl alternative = new ChatRoomIrcImpl("&MyAlternative-channel-prefix", this.providerMock);
        Assert.assertEquals((String)"&MyAlternative-channel-prefix", (String)alternative.getIdentifier());
    }

    public void testOnlyAlternativeChannelTypesWithDefault() {
        ProtocolProviderServiceIrcImpl specialProviderMock = (ProtocolProviderServiceIrcImpl)((Object)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class));
        IrcStack specialStackMock = (IrcStack)EasyMock.createMock(IrcStack.class);
        IrcConnection specialConnectionMock = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        ChannelManager specialChannelMock = (ChannelManager)EasyMock.createMock(ChannelManager.class);
        EasyMock.expect((Object)specialProviderMock.getIrcStack()).andReturn((Object)specialStackMock);
        EasyMock.expect((Object)specialStackMock.getConnection()).andReturn((Object)specialConnectionMock);
        EasyMock.expect((Object)specialConnectionMock.getChannelManager()).andReturn((Object)specialChannelMock);
        EasyMock.expect(specialChannelMock.getChannelTypes()).andReturn((Object)Sets.newHashSet((Object[])new Character[]{Character.valueOf('&')}));
        EasyMock.replay((Object[])new Object[]{specialProviderMock, specialStackMock, specialConnectionMock, specialChannelMock});
        ChatRoomIrcImpl alternative = new ChatRoomIrcImpl("channel-name-without-prefix", specialProviderMock);
        Assert.assertEquals((String)"#channel-name-without-prefix", (String)alternative.getIdentifier());
    }
}

