/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.ClockStoppedException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.StopTimeSetError;
import javax.media.Time;
import javax.media.TimeBase;

public class AbstractClock
implements Clock {
    private TimeBase systemtimebase;
    private TimeBase timebase;
    private Time mediaStartTime;
    private Time mediaStopTime;
    private Time timeBaseStartTime;
    private float rate;
    private boolean isStarted;

    public AbstractClock() {
        this.timebase = this.systemtimebase = Manager.getSystemTimeBase();
        this.mediaStartTime = new Time(0L);
        this.mediaStopTime = Clock.RESET;
        this.rate = 1.0f;
        this.isStarted = false;
    }

    private synchronized Time calculateMediaTime() {
        long tbStart;
        long tbCurrent = this.timebase.getNanoseconds();
        if (tbCurrent < (tbStart = this.timeBaseStartTime.getNanoseconds())) {
            return this.mediaStartTime;
        }
        long mStart = this.mediaStartTime.getNanoseconds();
        long mCurrent = (long)((float)(tbCurrent - tbStart) * this.rate + (float)mStart);
        return new Time(mCurrent);
    }

    @Override
    public synchronized long getMediaNanoseconds() {
        return this.getMediaTime().getNanoseconds();
    }

    protected Time getMediaStartTime() {
        return this.mediaStartTime;
    }

    @Override
    public synchronized Time getMediaTime() {
        if (!this.isStarted) {
            return this.mediaStartTime;
        }
        return this.calculateMediaTime();
    }

    @Override
    public synchronized float getRate() {
        return this.rate;
    }

    @Override
    public synchronized Time getStopTime() {
        return this.mediaStopTime;
    }

    @Override
    public synchronized Time getSyncTime() {
        long nowNano;
        long startNano;
        if (this.isStarted && (startNano = this.timeBaseStartTime.getNanoseconds()) >= (nowNano = this.getTimeBase().getNanoseconds())) {
            return new Time(nowNano - startNano);
        }
        return this.getMediaTime();
    }

    @Override
    public synchronized TimeBase getTimeBase() {
        return this.timebase;
    }

    protected Time getTimeBaseStartTime() {
        return this.timeBaseStartTime;
    }

    @Override
    public synchronized Time mapToTimeBase(Time t) throws ClockStoppedException {
        if (!this.isStarted) {
            throw new ClockStoppedException("Cannot map media time to time-base time on a Stopped Clock");
        }
        long mCurrent = t.getNanoseconds();
        long mStart = this.mediaStartTime.getNanoseconds();
        long tbStart = this.timeBaseStartTime.getNanoseconds();
        return new Time((long)((float)(mCurrent - mStart) / this.rate + (float)tbStart));
    }

    @Override
    public synchronized void setMediaTime(Time t) {
        if (this.isStarted) {
            throw new ClockStartedError("Cannot set media time on a Started Clock");
        }
        this.mediaStartTime = t;
    }

    @Override
    public synchronized float setRate(float rate) {
        if (this.isStarted) {
            throw new ClockStartedError("Cannot set rate on a Started Clock");
        }
        if (rate != 0.0f) {
            this.rate = rate;
        }
        return this.rate;
    }

    @Override
    public synchronized void setStopTime(Time mediaStopTime) {
        if (this.isStarted && this.mediaStopTime != RESET) {
            throw new StopTimeSetError("Stop time may be set only once on a Started Clock");
        }
        this.mediaStopTime = mediaStopTime;
    }

    @Override
    public synchronized void setTimeBase(TimeBase timebase) throws IncompatibleTimeBaseException {
        if (this.isStarted) {
            throw new ClockStartedError("Cannot set time base on a Started Clock");
        }
        this.timebase = timebase == null ? this.systemtimebase : timebase;
    }

    @Override
    public synchronized void stop() {
        if (this.isStarted) {
            this.mediaStartTime = this.calculateMediaTime();
            this.isStarted = false;
        }
    }

    @Override
    public synchronized void syncStart(Time t) {
        if (this.isStarted) {
            throw new ClockStartedError("syncStart() cannot be called on a started Clock");
        }
        long now = this.getTimeBase().getNanoseconds();
        long start = t.getNanoseconds();
        this.timeBaseStartTime = start - now > 0L ? new Time(start) : new Time(now);
        this.isStarted = true;
    }
}

