/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig.autoaway;

import java.beans.PropertyChangeListener;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;

public final class Preferences {
    private static final String ENABLE = "net.java.sip.communicator.plugin.statusupdate.enable";
    private static final String TIMER = "net.java.sip.communicator.plugin.statusupdate.timer";
    public static final int DEFAULT_TIMER = 15;

    static boolean isEnabled() {
        String enabledDefault = GeneralConfigPluginActivator.getResources().getSettingsString(ENABLE);
        return GeneralConfigPluginActivator.getConfigurationService().getBoolean(ENABLE, Boolean.parseBoolean(enabledDefault));
    }

    static int getTimer() {
        ConfigurationService cfg = GeneralConfigPluginActivator.getConfigurationService();
        ResourceManagementService resources = GeneralConfigPluginActivator.getResources();
        String enabledDefault = resources.getSettingsString(ENABLE);
        String timerDefaultStr = resources.getSettingsString(TIMER);
        int timerDefault = 15;
        if (timerDefaultStr != null) {
            try {
                timerDefault = Integer.parseInt(timerDefaultStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return cfg.getBoolean(ENABLE, Boolean.parseBoolean(enabledDefault)) ? cfg.getInt(TIMER, timerDefault) : 0;
    }

    static void saveData(boolean enabled, String timer) {
        ConfigurationService cfg = GeneralConfigPluginActivator.getConfigurationService();
        cfg.setProperty(ENABLE, (Object)Boolean.toString(enabled));
        cfg.setProperty(TIMER, (Object)timer);
    }

    static void addEnableChangeListener(PropertyChangeListener listener) {
        GeneralConfigPluginActivator.getConfigurationService().addPropertyChangeListener(ENABLE, listener);
    }

    static void addTimerChangeListener(PropertyChangeListener listener) {
        GeneralConfigPluginActivator.getConfigurationService().addPropertyChangeListener(TIMER, listener);
    }
}

