/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.DataModelHelperImpl;
import org.apache.felix.bundlerepository.impl.LocalRepositoryImpl;
import org.apache.felix.bundlerepository.impl.Referral;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.ResolverImpl;
import org.apache.felix.bundlerepository.impl.ResourceComparator;
import org.apache.felix.bundlerepository.impl.SystemRepositoryImpl;
import org.apache.felix.utils.collections.MapToDictionary;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class RepositoryAdminImpl
implements RepositoryAdmin {
    private final BundleContext m_context;
    private final Logger m_logger;
    private final SystemRepositoryImpl m_system;
    private final LocalRepositoryImpl m_local;
    private final DataModelHelper m_helper = new DataModelHelperImpl();
    private Map m_repoMap = new HashMap();
    private boolean m_initialized = false;
    private Comparator m_nameComparator = new ResourceComparator();
    public static final String REPOSITORY_URL_PROP = "obr.repository.url";
    public static final String EXTERN_REPOSITORY_TAG = "extern-repositories";

    public RepositoryAdminImpl(BundleContext context, Logger logger) {
        this.m_context = context;
        this.m_logger = logger;
        this.m_system = new SystemRepositoryImpl(context, logger);
        this.m_local = new LocalRepositoryImpl(context, logger);
    }

    public DataModelHelper getHelper() {
        return this.m_helper;
    }

    public Repository getLocalRepository() {
        return this.m_local;
    }

    public Repository getSystemRepository() {
        return this.m_system;
    }

    public void dispose() {
        this.m_local.dispose();
    }

    public Repository addRepository(String uri) throws Exception {
        return this.addRepository(new URL(uri));
    }

    public Repository addRepository(URL url) throws Exception {
        return this.addRepository(url, Integer.MAX_VALUE);
    }

    public synchronized RepositoryImpl addRepository(final URL url, int hopCount) throws Exception {
        this.initialize();
        try {
            RepositoryImpl repository = (RepositoryImpl)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RepositoryAdminImpl.this.m_helper.repository(url);
                }
            });
            this.m_repoMap.put(url.toExternalForm(), repository);
            if (--hopCount > 0 && repository.getReferrals() != null) {
                for (int i = 0; i < repository.getReferrals().length; ++i) {
                    Referral referral = repository.getReferrals()[i];
                    URL referralUrl = new URL(url, referral.getUrl());
                    hopCount = referral.getDepth() > hopCount ? hopCount : referral.getDepth();
                    this.addRepository(referralUrl, hopCount);
                }
            }
            return repository;
        }
        catch (PrivilegedActionException ex) {
            throw (Exception)ex.getCause();
        }
    }

    public synchronized boolean removeRepository(String uri) {
        this.initialize();
        return this.m_repoMap.remove(uri) != null;
    }

    public synchronized Repository[] listRepositories() {
        this.initialize();
        return this.m_repoMap.values().toArray(new Repository[this.m_repoMap.size()]);
    }

    public synchronized Resolver resolver() {
        this.initialize();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        repositories.add(this.m_system);
        repositories.add(this.m_local);
        repositories.addAll(this.m_repoMap.values());
        return this.resolver(repositories.toArray(new Repository[repositories.size()]));
    }

    public synchronized Resolver resolver(Repository[] repositories) {
        this.initialize();
        if (repositories == null) {
            return this.resolver();
        }
        return new ResolverImpl(this.m_context, repositories, this.m_logger);
    }

    public synchronized Resource[] discoverResources(String filterExpr) throws InvalidSyntaxException {
        Resource[] resources;
        this.initialize();
        Filter filter = filterExpr != null ? this.m_helper.filter(filterExpr) : null;
        MapToDictionary dict = new MapToDictionary(null);
        Repository[] repos = this.listRepositories();
        ArrayList<Resource> matchList = new ArrayList<Resource>();
        for (int repoIdx = 0; repos != null && repoIdx < repos.length; ++repoIdx) {
            resources = repos[repoIdx].getResources();
            for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                dict.setSourceMap(resources[resIdx].getProperties());
                if (filter != null && !filter.match((Dictionary)dict)) continue;
                matchList.add(resources[resIdx]);
            }
        }
        resources = matchList.toArray(new Resource[matchList.size()]);
        Arrays.sort(resources, this.m_nameComparator);
        return resources;
    }

    public synchronized Resource[] discoverResources(Requirement[] requirements) {
        this.initialize();
        Resource[] resources = null;
        MapToDictionary dict = new MapToDictionary(null);
        Repository[] repos = this.listRepositories();
        ArrayList<Resource> matchList = new ArrayList<Resource>();
        for (int repoIdx = 0; repos != null && repoIdx < repos.length; ++repoIdx) {
            resources = repos[repoIdx].getResources();
            for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                dict.setSourceMap(resources[resIdx].getProperties());
                boolean match = true;
                for (int reqIdx = 0; requirements != null && reqIdx < requirements.length; ++reqIdx) {
                    boolean reqMatch = false;
                    Capability[] caps = resources[resIdx].getCapabilities();
                    for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
                        if (!requirements[reqIdx].isSatisfied(caps[capIdx])) continue;
                        reqMatch = true;
                        break;
                    }
                    if (!(match &= reqMatch)) break;
                }
                if (!match) continue;
                matchList.add(resources[resIdx]);
            }
        }
        resources = matchList.toArray(new Resource[matchList.size()]);
        Arrays.sort(resources, this.m_nameComparator);
        return resources;
    }

    private void initialize() {
        StringTokenizer st;
        if (this.m_initialized) {
            return;
        }
        this.m_initialized = true;
        String urlStr = this.m_context.getProperty(REPOSITORY_URL_PROP);
        if (urlStr != null && (st = new StringTokenizer(urlStr)).countTokens() > 0) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    this.addRepository(token);
                }
                catch (Exception ex) {
                    this.m_logger.log(2, "Repository url " + token + " cannot be used. Skipped.", ex);
                }
            }
        }
    }
}

