/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.parser;

import gov.nist.javax.sdp.fields.PhoneField;
import gov.nist.javax.sdp.fields.SDPField;
import gov.nist.javax.sdp.parser.Lexer;
import gov.nist.javax.sdp.parser.SDPParser;
import java.text.ParseException;

public class PhoneFieldParser
extends SDPParser {
    public PhoneFieldParser(String phoneField) {
        this.lexer = new Lexer("charLexer", phoneField);
    }

    public String getDisplayName(String rest) {
        String retval = null;
        try {
            int begin = rest.indexOf("(");
            int end = rest.indexOf(")");
            if (begin != -1) {
                retval = rest.substring(begin + 1, end);
            } else {
                int ind = rest.indexOf("<");
                if (ind != -1) {
                    retval = rest.substring(0, ind);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    public String getPhoneNumber(String rest) throws ParseException {
        String phoneNumber = null;
        try {
            int begin = rest.indexOf("(");
            if (begin != -1) {
                phoneNumber = rest.substring(0, begin).trim();
            } else {
                int ind = rest.indexOf("<");
                int end = rest.indexOf(">");
                phoneNumber = ind != -1 ? rest.substring(ind + 1, end) : rest.trim();
            }
        }
        catch (Exception e) {
            throw new ParseException(this.lexer.getBuffer(), this.lexer.getPtr());
        }
        return phoneNumber;
    }

    public PhoneField phoneField() throws ParseException {
        try {
            this.lexer.match(112);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            PhoneField phoneField = new PhoneField();
            String rest = this.lexer.getRest();
            String displayName = this.getDisplayName(rest.trim());
            phoneField.setName(displayName);
            String phoneNumber = this.getPhoneNumber(rest);
            phoneField.setPhoneNumber(phoneNumber);
            return phoneField;
        }
        catch (Exception e) {
            throw new ParseException(this.lexer.getBuffer(), this.lexer.getPtr());
        }
    }

    @Override
    public SDPField parse() throws ParseException {
        return this.phoneField();
    }
}

