/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.RTPPacketParser;
import net.sf.fmj.media.rtp.util.RTPPacketReceiver;
import net.sf.fmj.media.rtp.util.UDPPacketReceiver;

public class RTPRawReceiver
extends PacketFilter {
    private OverallStats stats = null;
    private boolean recvBufSizeSet = false;
    public DatagramSocket socket;
    private RTPConnector rtpConnector = null;
    private final RTPPacketParser parser = new RTPPacketParser();

    public RTPRawReceiver() {
    }

    public RTPRawReceiver(DatagramSocket datagramsocket, OverallStats overallstats) {
        this.setSource(new UDPPacketReceiver(datagramsocket, 2000));
        this.stats = overallstats;
    }

    public RTPRawReceiver(int i, String s, OverallStats overallstats) throws UnknownHostException, IOException, SocketException {
        UDPPacketReceiver udppacketreceiver = new UDPPacketReceiver(i & 0xFFFFFFFE, s, -1, null, 2000, null);
        this.setSource(udppacketreceiver);
        this.socket = udppacketreceiver.getSocket();
        this.stats = overallstats;
    }

    public RTPRawReceiver(RTPConnector rtpconnector, OverallStats overallstats) {
        try {
            this.setSource(new RTPPacketReceiver(rtpconnector.getDataInputStream()));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
        this.rtpConnector = rtpconnector;
        this.stats = overallstats;
    }

    public RTPRawReceiver(RTPPushDataSource rtppushdatasource, OverallStats overallstats) {
        this.setSource(new RTPPacketReceiver(rtppushdatasource));
        this.stats = overallstats;
    }

    public RTPRawReceiver(SessionAddress sessionaddress, SessionAddress sessionaddress1, OverallStats overallstats, DatagramSocket datagramsocket) throws UnknownHostException, IOException, SocketException {
        this.stats = overallstats;
        UDPPacketReceiver udppacketreceiver = new UDPPacketReceiver(sessionaddress.getDataPort(), sessionaddress.getDataHostAddress(), sessionaddress1.getDataPort(), sessionaddress1.getDataHostAddress(), 2000, datagramsocket);
        this.setSource(udppacketreceiver);
        this.socket = udppacketreceiver.getSocket();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    @Override
    public String filtername() {
        return "RTP Raw Packet Receiver";
    }

    public int getRecvBufSize() {
        try {
            Class<?> class1 = this.socket.getClass();
            Method method = class1.getMethod("getReceiveBufferSize", new Class[0]);
            Integer integer = (Integer)method.invoke((Object)this.socket, new Object[0]);
            return integer;
        }
        catch (Exception e) {
            if (this.rtpConnector != null) {
                return this.rtpConnector.getReceiveBufferSize();
            }
            return -1;
        }
    }

    @Override
    public Packet handlePacket(Packet packet) {
        RTPPacket rtppacket;
        this.stats.update(0, 1);
        this.stats.update(1, packet.length);
        try {
            rtppacket = this.parser.parse(packet);
        }
        catch (BadFormatException badformatexception) {
            this.stats.update(2, 1);
            return null;
        }
        if (!this.recvBufSizeSet) {
            this.recvBufSizeSet = true;
            switch (rtppacket.payloadType) {
                case 14: 
                case 26: 
                case 34: 
                case 42: {
                    this.setRecvBufSize(64000);
                    break;
                }
                case 31: {
                    this.setRecvBufSize(128000);
                    break;
                }
                case 32: {
                    this.setRecvBufSize(128000);
                    break;
                }
                default: {
                    if (rtppacket.payloadType < 96 || rtppacket.payloadType > 127) break;
                    this.setRecvBufSize(64000);
                }
            }
        }
        return rtppacket;
    }

    @Override
    public Packet handlePacket(Packet packet, int i) {
        return null;
    }

    @Override
    public Packet handlePacket(Packet packet, SessionAddress sessionaddress) {
        return null;
    }

    public Packet handlePacket(Packet packet, SessionAddress sessionaddress, boolean flag) {
        return null;
    }

    public void setRecvBufSize(int i) {
        try {
            if (this.socket == null && this.rtpConnector != null) {
                this.rtpConnector.setReceiveBufferSize(i);
            }
        }
        catch (Exception exception) {
            Log.comment("Cannot set receive buffer size: " + exception);
        }
    }
}

