/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.io.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;

public class UnicodeReader
extends Reader {
    private final InputStreamReader internalInputStreamReader;
    private final String defaultEnc;
    private static final int BOM_SIZE = 4;

    public UnicodeReader(InputStream in, String defaultEnc) throws IOException {
        int unread;
        String encoding;
        this.defaultEnc = defaultEnc;
        byte[] bom = new byte[4];
        PushbackInputStream pushbackStream = new PushbackInputStream(in, 4);
        int n = pushbackStream.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = "UTF-16LE";
            unread = n - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = "UTF-32LE";
            unread = n - 4;
        } else {
            encoding = defaultEnc;
            unread = n;
        }
        if (unread > 0) {
            pushbackStream.unread(bom, n - unread, unread);
        } else if (unread < -1) {
            pushbackStream.unread(bom, 0, 0);
        }
        this.internalInputStreamReader = encoding == null ? new InputStreamReader(pushbackStream) : new InputStreamReader((InputStream)pushbackStream, encoding);
    }

    public String getDefaultEncoding() {
        return this.defaultEnc;
    }

    public String getEncoding() {
        return this.internalInputStreamReader.getEncoding();
    }

    @Override
    public void close() throws IOException {
        this.internalInputStreamReader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.internalInputStreamReader.read(cbuf, off, len);
    }
}

