/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr.authdialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.security.PublicKey;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.authdialog.CustomTextArea;

public class FingerprintAuthenticationPanel
extends TransparentPanel
implements DocumentListener {
    private final OtrContactManager.OtrContact otrContact;
    private SIPCommTextField txtRemoteFingerprintComparison;
    private JTextArea txtLocalFingerprint;
    private JTextArea txtRemoteFingerprint;
    private JComboBox cbAction;
    private ActionComboBoxItem actionIHave = new ActionComboBoxItem(ActionComboBoxItemIndex.I_HAVE);
    private ActionComboBoxItem actionIHaveNot = new ActionComboBoxItem(ActionComboBoxItemIndex.I_HAVE_NOT);
    private JTextArea txtAction;

    FingerprintAuthenticationPanel(OtrContactManager.OtrContact contact) {
        this.otrContact = contact;
        this.initComponents();
        this.loadContact();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setPreferredSize(new Dimension(350, 300));
        CustomTextArea generalInformation = new CustomTextArea();
        generalInformation.setText(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.AUTHENTICATION_FINGERPRINT"));
        this.add(generalInformation);
        this.add(Box.createVerticalStrut(10));
        this.txtLocalFingerprint = new CustomTextArea();
        this.add(this.txtLocalFingerprint);
        this.add(Box.createVerticalStrut(10));
        this.txtRemoteFingerprint = new CustomTextArea();
        this.add(this.txtRemoteFingerprint);
        this.add(Box.createVerticalStrut(10));
        JPanel pnlAction = new JPanel(new GridBagLayout());
        pnlAction.setBorder(BorderFactory.createEtchedBorder());
        this.add(pnlAction);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 0.0;
        this.cbAction = new JComboBox();
        this.cbAction.addItem(this.actionIHave);
        this.cbAction.addItem(this.actionIHaveNot);
        PublicKey pubKey = OtrActivator.scOtrEngine.getRemotePublicKey(this.otrContact);
        String remoteFingerprint = OtrActivator.scOtrKeyManager.getFingerprintFromPublicKey(pubKey);
        this.cbAction.setSelectedItem(OtrActivator.scOtrKeyManager.isVerified(this.otrContact.contact, remoteFingerprint) ? this.actionIHave : this.actionIHaveNot);
        pnlAction.add((Component)this.cbAction, c);
        this.txtAction = new CustomTextArea();
        c.weightx = 1.0;
        pnlAction.add((Component)this.txtAction, c);
        String resourceName = this.otrContact.resource != null ? "/" + this.otrContact.resource.getResourceName() : "";
        this.txtRemoteFingerprintComparison = new SIPCommTextField(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.FINGERPRINT_CHECK", new String[]{this.otrContact.contact.getDisplayName() + resourceName}));
        this.txtRemoteFingerprintComparison.getDocument().addDocumentListener(this);
        c.gridwidth = 2;
        c.gridy = 1;
        pnlAction.add((Component)this.txtRemoteFingerprintComparison, c);
        c.gridwidth = 1;
        c.gridy = 0;
    }

    public JComboBox getCbAction() {
        return this.cbAction;
    }

    private void loadContact() {
        String account = this.otrContact.contact.getProtocolProvider().getAccountID().getDisplayName();
        String localFingerprint = OtrActivator.scOtrKeyManager.getLocalFingerprint(this.otrContact.contact.getProtocolProvider().getAccountID());
        this.txtLocalFingerprint.setText(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.LOCAL_FINGERPRINT", new String[]{account, localFingerprint}));
        String user = this.otrContact.contact.getDisplayName();
        PublicKey pubKey = OtrActivator.scOtrEngine.getRemotePublicKey(this.otrContact);
        String remoteFingerprint = OtrActivator.scOtrKeyManager.getFingerprintFromPublicKey(pubKey);
        this.txtRemoteFingerprint.setText(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.REMOTE_FINGERPRINT", new String[]{user, remoteFingerprint}));
        this.txtAction.setText(OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.VERIFY_ACTION", new String[]{user}));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.compareFingerprints();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.compareFingerprints();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.compareFingerprints();
    }

    public void compareFingerprints() {
        PublicKey pubKey = OtrActivator.scOtrEngine.getRemotePublicKey(this.otrContact);
        String remoteFingerprint = OtrActivator.scOtrKeyManager.getFingerprintFromPublicKey(pubKey);
        if (this.txtRemoteFingerprintComparison.getText() == null || this.txtRemoteFingerprintComparison.getText().length() == 0) {
            this.txtRemoteFingerprintComparison.setBackground(Color.white);
            return;
        }
        if (this.txtRemoteFingerprintComparison.getText().toLowerCase().contains(remoteFingerprint.toLowerCase())) {
            this.txtRemoteFingerprintComparison.setBackground(Color.green);
            this.cbAction.setSelectedItem(this.actionIHave);
        } else {
            this.txtRemoteFingerprintComparison.setBackground(new Color(243, 72, 48));
            this.cbAction.setSelectedItem(this.actionIHaveNot);
        }
    }

    class ActionComboBoxItem {
        public ActionComboBoxItemIndex action;
        private String text;

        public ActionComboBoxItem(ActionComboBoxItemIndex actionIndex) {
            this.action = actionIndex;
            switch (this.action) {
                case I_HAVE: {
                    this.text = OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.I_HAVE");
                    break;
                }
                case I_HAVE_NOT: {
                    this.text = OtrActivator.resourceService.getI18NString("plugin.otr.authbuddydialog.I_HAVE_NOT");
                }
            }
        }

        public String toString() {
            return this.text;
        }
    }

    static enum ActionComboBoxItemIndex {
        I_HAVE,
        I_HAVE_NOT;

    }
}

