/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.jdic;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.impl.osdependent.Resources;
import net.java.sip.communicator.plugin.desktoputil.LightGrayFilter;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;

public class StatusSimpleSelector
implements ActionListener,
ItemListener {
    private final ProtocolProviderService provider;
    private final Object menu;

    public StatusSimpleSelector(ProtocolProviderService protocolProvider, boolean swing) {
        this.provider = protocolProvider;
        String text = this.provider.getAccountID().getDisplayName();
        this.menu = swing ? new JMenu(text) : new Menu(text);
        this.createMenuItem("service.gui.ONLINE", "online");
        this.createMenuItem("service.gui.OFFLINE", "offline");
        this.updateStatus();
    }

    private void createMenuItem(String textKey, String name) {
        String text = Resources.getString(textKey);
        if (this.menu instanceof JMenu) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(text);
            menuItem.setName(name);
            menuItem.addActionListener(this);
            ((JMenu)this.menu).add(menuItem);
        } else {
            CheckboxMenuItem menuItem = new CheckboxMenuItem(text);
            menuItem.setName(name);
            menuItem.addItemListener(this);
            ((Menu)this.menu).add(menuItem);
        }
    }

    public Object getMenu() {
        return this.menu;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.changeStatus(evt.getSource());
    }

    private void changeStatus(Object source) {
        String itemName = source instanceof Component ? ((Component)source).getName() : ((MenuComponent)source).getName();
        if (itemName.equals("online")) {
            OsDependentActivator.getGlobalStatusService().publishStatus(this.provider, (PresenceStatus)GlobalStatusEnum.ONLINE);
        } else {
            OsDependentActivator.getGlobalStatusService().publishStatus(this.provider, (PresenceStatus)GlobalStatusEnum.OFFLINE);
        }
    }

    public void updateStatus() {
        block11: {
            String offlineText;
            String onlineText;
            block10: {
                byte[] iconBytes;
                if (this.menu instanceof AbstractButton && (iconBytes = this.provider.getProtocolIcon().getIcon("IconSize16x16")) != null && iconBytes.length > 0) {
                    ImageIcon icon = new ImageIcon(iconBytes);
                    if (!this.provider.isRegistered()) {
                        icon = new ImageIcon(LightGrayFilter.createDisabledImage((Image)icon.getImage()));
                    }
                    ((AbstractButton)this.menu).setIcon(icon);
                }
                onlineText = Resources.getString("service.gui.ONLINE");
                offlineText = Resources.getString("service.gui.OFFLINE");
                if (!(this.menu instanceof Menu)) break block10;
                Menu theMenu = (Menu)this.menu;
                for (int i = 0; i < theMenu.getItemCount(); ++i) {
                    MenuItem item = theMenu.getItem(i);
                    if (!(item instanceof CheckboxMenuItem)) continue;
                    if (item.getLabel().equals(onlineText)) {
                        if (this.provider.isRegistered()) {
                            ((CheckboxMenuItem)item).setState(true);
                            continue;
                        }
                        ((CheckboxMenuItem)item).setState(false);
                        continue;
                    }
                    if (!item.getLabel().equals(offlineText)) continue;
                    if (this.provider.isRegistered()) {
                        ((CheckboxMenuItem)item).setState(false);
                        continue;
                    }
                    ((CheckboxMenuItem)item).setState(true);
                }
                break block11;
            }
            if (!(this.menu instanceof JMenu)) break block11;
            JMenu theMenu = (JMenu)this.menu;
            for (int i = 0; i < theMenu.getItemCount(); ++i) {
                JMenuItem item = theMenu.getItem(i);
                if (!(item instanceof JCheckBoxMenuItem)) continue;
                if (item.getText().equals(onlineText)) {
                    if (this.provider.isRegistered()) {
                        item.setSelected(true);
                        continue;
                    }
                    item.setSelected(false);
                    continue;
                }
                if (!item.getText().equals(offlineText)) continue;
                if (this.provider.isRegistered()) {
                    item.setSelected(false);
                    continue;
                }
                item.setSelected(true);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object soutceItem = e.getSource();
        if (e.getStateChange() == 1) {
            if (soutceItem instanceof CheckboxMenuItem) {
                this.changeStatus(soutceItem);
            }
        } else if (e.getStateChange() == 2 && soutceItem instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)soutceItem).setState(true);
        }
    }
}

