/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.OperationSetPersistentPresenceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.PresenceWatcher;
import net.java.sip.communicator.util.Logger;

class MonitorPresenceWatcher
implements PresenceWatcher {
    private static final int MONITOR_ADD_CMD_STATIC_OVERHEAD = 10;
    private static final Logger LOGGER = Logger.getLogger(MonitorPresenceWatcher.class);
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final Set<String> nickWatchList;
    private final Set<String> monitoredList;

    MonitorPresenceWatcher(IRCApi irc, IIRCState connectionState, Set<String> nickWatchList, Set<String> monitored, OperationSetPersistentPresenceIrcImpl operationSet, int maxListSize) {
        if (irc == null) {
            throw new IllegalArgumentException("irc cannot be null");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState cannot be null");
        }
        this.connectionState = connectionState;
        if (nickWatchList == null) {
            throw new IllegalArgumentException("nickWatchList cannot be null");
        }
        this.nickWatchList = nickWatchList;
        if (monitored == null) {
            throw new IllegalArgumentException("monitored cannot be null");
        }
        this.monitoredList = monitored;
        this.irc.addListener((IMessageListener)new MonitorReplyListener(this.monitoredList, operationSet));
        MonitorPresenceWatcher.setUpMonitor(this.irc, this.nickWatchList, maxListSize);
        LOGGER.debug((Object)"MONITOR presence watcher initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUpMonitor(IRCApi irc, Collection<String> nickWatchList, int maxListSize) {
        List<String> current;
        Collection<String> collection = nickWatchList;
        synchronized (collection) {
            current = new LinkedList<String>(nickWatchList);
        }
        if (current.size() > maxListSize) {
            current = current.subList(0, maxListSize);
        }
        int maxLength = 500;
        StringBuilder query = new StringBuilder();
        for (String nick : current) {
            if (query.length() + nick.length() + 1 > 500) {
                irc.rawMessage("MONITOR + " + query);
                query.delete(0, query.length());
            } else if (query.length() > 0) {
                query.append(",");
            }
            query.append(nick);
        }
        if (query.length() > 0) {
            irc.rawMessage("MONITOR + " + query);
        }
    }

    @Override
    public void add(String nick) {
        LOGGER.trace((Object)("Adding nick '" + nick + "' to MONITOR watch list."));
        this.nickWatchList.add(nick);
        this.irc.rawMessage("MONITOR + " + nick);
    }

    @Override
    public void remove(String nick) {
        LOGGER.trace((Object)("Removing nick '" + nick + "' from MONITOR watch list."));
        this.nickWatchList.remove(nick);
        this.irc.rawMessage("MONITOR - " + nick);
        this.monitoredList.remove(nick);
    }

    private final class MonitorReplyListener
    extends AbstractIrcMessageListener {
        private static final int IRC_RPL_MONONLINE = 730;
        private static final int IRC_RPL_MONOFFLINE = 731;
        private static final int IRC_ERR_MONLISTFULL = 734;
        private final OperationSetPersistentPresenceIrcImpl operationSet;
        private final Set<String> monitoredNickList;

        public MonitorReplyListener(Set<String> monitored, OperationSetPersistentPresenceIrcImpl operationSet) {
            super(MonitorPresenceWatcher.this.irc, MonitorPresenceWatcher.this.connectionState);
            if (operationSet == null) {
                throw new IllegalArgumentException("operationSet cannot be null");
            }
            this.operationSet = operationSet;
            if (monitored == null) {
                throw new IllegalArgumentException("monitored cannot be null");
            }
            this.monitoredNickList = monitored;
        }

        public void onServerNumericMessage(ServerNumericMessage msg) {
            switch (msg.getNumericCode()) {
                case 730: {
                    List<String> acknowledged = this.parseMonitorResponse(msg.getText());
                    for (String nick : acknowledged) {
                        this.update(nick, IrcStatusEnum.ONLINE);
                    }
                    this.monitoredNickList.addAll(acknowledged);
                    break;
                }
                case 731: {
                    List<String> acknowledged = this.parseMonitorResponse(msg.getText());
                    for (String nick : acknowledged) {
                        this.update(nick, IrcStatusEnum.OFFLINE);
                    }
                    this.monitoredNickList.addAll(acknowledged);
                    break;
                }
                case 734: {
                    LOGGER.debug((Object)("MONITOR list full. Nick was not added. Fall back Basic Poller will be used if it is enabled. (" + msg.getText() + ")"));
                }
            }
        }

        @Override
        public void onUserQuit(QuitMessage msg) {
            super.onUserQuit(msg);
            if (this.localUser(msg.getSource().getNick())) {
                this.updateAll(IrcStatusEnum.OFFLINE);
            }
        }

        @Override
        public void onError(ErrorMessage msg) {
            super.onError(msg);
            this.updateAll(IrcStatusEnum.OFFLINE);
        }

        @Override
        public void onClientError(ClientErrorMessage msg) {
            super.onClientError(msg);
            this.updateAll(IrcStatusEnum.OFFLINE);
        }

        private List<String> parseMonitorResponse(String message) {
            String[] targets;
            LinkedList<String> acknowledged = new LinkedList<String>();
            for (String target : targets = message.substring(1).split(",")) {
                String[] parts = target.trim().split("!");
                acknowledged.add(parts[0]);
            }
            return acknowledged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateAll(IrcStatusEnum status) {
            LinkedList<String> nicks;
            Set<String> set = this.monitoredNickList;
            synchronized (set) {
                nicks = new LinkedList<String>(this.monitoredNickList);
            }
            for (String nick : nicks) {
                this.update(nick, status);
            }
        }

        private void update(String nick, IrcStatusEnum status) {
            this.operationSet.updateNickContactPresence(nick, status);
        }
    }
}

