/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.engine;

import cern.colt.PersistentObject;
import cern.jet.random.engine.RandomSeedTable;

public class RandomSeedGenerator
extends PersistentObject {
    protected int row;
    protected int column;

    public RandomSeedGenerator() {
        this(0, 0);
    }

    public RandomSeedGenerator(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public static void main(String[] args) {
        int row = Integer.parseInt(args[0]);
        int column = Integer.parseInt(args[1]);
        int size = Integer.parseInt(args[2]);
        new RandomSeedGenerator(row, column).print(size);
    }

    public int nextSeed() {
        return RandomSeedTable.getSeedAtRowColumn(this.row++, this.column);
    }

    public void print(int size) {
        System.out.println("Generating " + size + " random seeds...");
        RandomSeedGenerator copy = (RandomSeedGenerator)this.clone();
        for (int i = 0; i < size; ++i) {
            int seed = copy.nextSeed();
            System.out.println(seed);
        }
        System.out.println("\ndone.");
    }
}

