/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.LocalityUtils;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLayout;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPaintListener;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import com.touchgraph.graphlayout.graphelements.ImmutableGraphEltSet;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.graphelements.VisibleLocality;
import com.touchgraph.graphlayout.interaction.GLEditUI;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class TGPanel
extends Panel {
    public static Color BACK_COLOR = Color.white;
    private GraphEltSet completeEltSet;
    private VisibleLocality visibleLocality;
    private LocalityUtils localityUtils;
    public TGLayout tgLayout;
    protected BasicMouseMotionListener basicMML;
    protected Edge mouseOverE;
    protected Node mouseOverN;
    protected boolean maintainMouseOver = false;
    protected Node select;
    Node dragNode;
    protected Point mousePos;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    private Vector graphListeners;
    private Vector paintListeners;
    TGLensSet tgLensSet;
    AdjustOriginLens adjustOriginLens;
    SwitchSelectUI switchSelectUI;
    TGPoint2D topLeftDraw = null;
    TGPoint2D bottomRightDraw = null;

    public TGPanel() {
        this.setLayout(null);
        this.setGraphEltSet(new GraphEltSet());
        this.addMouseListener(new BasicMouseListener());
        this.basicMML = new BasicMouseMotionListener();
        this.addMouseMotionListener(this.basicMML);
        this.graphListeners = new Vector();
        this.paintListeners = new Vector();
        this.adjustOriginLens = new AdjustOriginLens();
        this.switchSelectUI = new SwitchSelectUI();
        TGLayout tgLayout = new TGLayout(this);
        this.setTGLayout(tgLayout);
        tgLayout.start();
        this.setGraphEltSet(new GraphEltSet());
    }

    public void setLensSet(TGLensSet lensSet) {
        this.tgLensSet = lensSet;
    }

    public void setTGLayout(TGLayout tgl) {
        this.tgLayout = tgl;
    }

    public void setGraphEltSet(GraphEltSet ges) {
        this.completeEltSet = ges;
        this.visibleLocality = new VisibleLocality(this.completeEltSet);
        this.localityUtils = new LocalityUtils(this.visibleLocality, this);
    }

    public AdjustOriginLens getAdjustOriginLens() {
        return this.adjustOriginLens;
    }

    public SwitchSelectUI getSwitchSelectUI() {
        return this.switchSelectUI;
    }

    public void setBackColor(Color color) {
        BACK_COLOR = color;
    }

    public ImmutableGraphEltSet getGES() {
        return this.visibleLocality;
    }

    public int getNodeCount() {
        return this.completeEltSet.nodeCount();
    }

    public int nodeNum() {
        return this.visibleLocality.nodeCount();
    }

    public int visibleNodeCount() {
        return this.visibleLocality.nodeCount();
    }

    public Node findNode(String id) {
        if (id == null) {
            return null;
        }
        return this.completeEltSet.findNode(id);
    }

    public Node findNodeByURL(String strURL) {
        if (strURL == null) {
            return null;
        }
        return this.completeEltSet.findNodeByURL(strURL);
    }

    public Node findNodeLabelContaining(String substring) {
        if (substring == null) {
            return null;
        }
        return this.completeEltSet.findNodeLabelContaining(substring);
    }

    public Node addNode() throws TGException {
        String id = String.valueOf(this.getNodeCount() + 1);
        return this.addNode(id, null);
    }

    public Node addNode(String label) throws TGException {
        return this.addNode(null, label);
    }

    public Node addNode(String id, String label) throws TGException {
        Node node = label == null ? new Node(id) : new Node(id, label);
        this.updateDrawPos(node);
        this.addNode(node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node node) throws TGException {
        LocalityUtils localityUtils = this.localityUtils;
        synchronized (localityUtils) {
            this.visibleLocality.addNode(node);
            this.resetDamper();
        }
    }

    public boolean deleteNodeById(String id) {
        if (id == null) {
            return false;
        }
        Node node = this.findNode(id);
        if (node == null) {
            return false;
        }
        return this.deleteNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNode(Node node) {
        LocalityUtils localityUtils = this.localityUtils;
        synchronized (localityUtils) {
            if (this.visibleLocality.deleteNode(node)) {
                if (node == this.select) {
                    this.clearSelect();
                }
                this.resetDamper();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        LocalityUtils localityUtils = this.localityUtils;
        synchronized (localityUtils) {
            this.visibleLocality.clearAll();
        }
    }

    public Node getSelect() {
        return this.select;
    }

    public Node getMouseOverN() {
        return this.mouseOverN;
    }

    public synchronized void setMouseOverN(Node node) {
        if (this.dragNode != null || this.maintainMouseOver) {
            return;
        }
        if (this.mouseOverN != node) {
            Node oldMouseOverN = this.mouseOverN;
            this.mouseOverN = node;
        }
        if (this.mouseOverN == null) {
            this.setCursor(new Cursor(13));
        } else {
            this.setCursor(new Cursor(12));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEdge(Edge edge) {
        LocalityUtils localityUtils = this.localityUtils;
        synchronized (localityUtils) {
            this.visibleLocality.deleteEdge(edge);
            this.resetDamper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEdge(Node from, Node to) {
        LocalityUtils localityUtils = this.localityUtils;
        synchronized (localityUtils) {
            this.visibleLocality.deleteEdge(from, to);
        }
    }

    public int getEdgeCount() {
        return this.completeEltSet.edgeCount();
    }

    public int edgeNum() {
        return this.visibleLocality.edgeCount();
    }

    public int visibleEdgeCount() {
        return this.visibleLocality.edgeCount();
    }

    public Edge findEdge(Node f, Node t) {
        return this.visibleLocality.findEdge(f, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(Edge e) {
        LocalityUtils localityUtils = this.localityUtils;
        synchronized (localityUtils) {
            this.visibleLocality.addEdge(e);
            this.resetDamper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edge addEdge(Node f, Node t, int tens) {
        LocalityUtils localityUtils = this.localityUtils;
        synchronized (localityUtils) {
            return this.visibleLocality.addEdge(f, t, tens);
        }
    }

    public Edge getMouseOverE() {
        return this.mouseOverE;
    }

    public synchronized void setMouseOverE(Edge edge) {
        if (this.dragNode != null || this.maintainMouseOver) {
            return;
        }
        if (this.mouseOverE != edge) {
            Edge oldMouseOverE = this.mouseOverE;
            this.mouseOverE = edge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMovedEvent() {
        Vector listeners;
        TGPanel tGPanel = this;
        synchronized (tGPanel) {
            listeners = (Vector)this.graphListeners.clone();
        }
        for (int i = 0; i < listeners.size(); ++i) {
            GraphListener gl = (GraphListener)listeners.elementAt(i);
            gl.graphMoved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireResetEvent() {
        Vector listeners;
        TGPanel tGPanel = this;
        synchronized (tGPanel) {
            listeners = (Vector)this.graphListeners.clone();
        }
        for (int i = 0; i < listeners.size(); ++i) {
            GraphListener gl = (GraphListener)listeners.elementAt(i);
            gl.graphReset();
        }
    }

    public synchronized void addGraphListener(GraphListener gl) {
        this.graphListeners.addElement(gl);
    }

    public synchronized void removeGraphListener(GraphListener gl) {
        this.graphListeners.removeElement(gl);
    }

    public synchronized void addPaintListener(TGPaintListener pl) {
        this.paintListeners.addElement(pl);
    }

    public synchronized void removePaintListener(TGPaintListener pl) {
        this.paintListeners.removeElement(pl);
    }

    private void redraw() {
        this.resetDamper();
    }

    public void setMaintainMouseOver(boolean maintain) {
        this.maintainMouseOver = maintain;
    }

    public void clearSelect() {
        if (this.select != null) {
            this.select = null;
            this.repaint();
        }
    }

    public void selectFirstNode() {
        this.setSelect(this.getGES().getFirstNode());
    }

    public void setSelect(Node node) {
        if (node != null) {
            this.select = node;
            this.repaint();
        } else if (node == null) {
            this.clearSelect();
        }
    }

    public void multiSelect(TGPoint2D from, TGPoint2D to) {
        double minY;
        double maxY;
        double minX;
        double maxX;
        if (from.x > to.x) {
            maxX = from.x;
            minX = to.x;
        } else {
            minX = from.x;
            maxX = to.x;
        }
        if (from.y > to.y) {
            maxY = from.y;
            minY = to.y;
        } else {
            minY = from.y;
            maxY = to.y;
        }
        final Vector selectedNodes = new Vector();
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node node) {
                double x = node.drawx;
                double y = node.drawy;
                if (x > minX && x < maxX && y > minY && y < maxY) {
                    selectedNodes.addElement(node);
                }
            }
        };
        this.visibleLocality.forAllNodes(fen);
        if (selectedNodes.size() > 0) {
            int r = (int)(Math.random() * (double)selectedNodes.size());
            this.setSelect((Node)selectedNodes.elementAt(r));
        } else {
            this.clearSelect();
        }
    }

    public void updateLocalityFromVisibility() throws TGException {
        this.visibleLocality.updateLocalityFromVisibility();
    }

    public void setLocale(Node node, int radius, int maxAddEdgeCount, int maxExpandEdgeCount, boolean unidirectional) throws TGException {
        this.localityUtils.setLocale(node, radius, maxAddEdgeCount, maxExpandEdgeCount, unidirectional);
    }

    public void fastFinishAnimation() {
        this.localityUtils.fastFinishAnimation();
    }

    public void setLocale(Node node, int radius) throws TGException {
        this.localityUtils.setLocale(node, radius);
    }

    public void expandNode(Node node) {
        this.localityUtils.expandNode(node);
    }

    public void hideNode(Node hideNode) {
        this.localityUtils.hideNode(hideNode);
    }

    public void collapseNode(Node collapseNode) {
        this.localityUtils.collapseNode(collapseNode);
    }

    public void hideEdge(Edge hideEdge) {
        this.visibleLocality.removeEdge(hideEdge);
        if (this.mouseOverE == hideEdge) {
            this.setMouseOverE(null);
        }
        this.resetDamper();
    }

    public void setDragNode(Node node) {
        this.dragNode = node;
        this.tgLayout.setDragNode(node);
    }

    public Node getDragNode() {
        return this.dragNode;
    }

    void setMousePos(Point p) {
        this.mousePos = p;
    }

    public Point getMousePos() {
        return this.mousePos;
    }

    public void startDamper() {
        if (this.tgLayout != null) {
            this.tgLayout.startDamper();
        }
    }

    public void stopDamper() {
        if (this.tgLayout != null) {
            this.tgLayout.stopDamper();
        }
    }

    public void resetDamper() {
        if (this.tgLayout != null) {
            this.tgLayout.resetDamper();
        }
    }

    public void stopMotion() {
        if (this.tgLayout != null) {
            this.tgLayout.stopMotion();
        }
    }

    protected synchronized void findMouseOver() {
        if (this.mousePos == null) {
            this.setMouseOverN(null);
            this.setMouseOverE(null);
            return;
        }
        final int mpx = this.mousePos.x;
        final int mpy = this.mousePos.y;
        final Node[] monA = new Node[1];
        final Edge[] moeA = new Edge[1];
        TGForEachNode fen = new TGForEachNode(){
            double minoverdist = 100.0;

            @Override
            public void forEachNode(Node node) {
                double x = node.drawx;
                double y = node.drawy;
                double dist = Math.sqrt(((double)mpx - x) * ((double)mpx - x) + ((double)mpy - y) * ((double)mpy - y));
                if (dist < this.minoverdist && node.containsPoint(mpx, mpy)) {
                    this.minoverdist = dist;
                    monA[0] = node;
                }
            }
        };
        this.visibleLocality.forAllNodes(fen);
        TGForEachEdge fee = new TGForEachEdge(){
            double minDist = 8.0;
            double minFromDist = 1000.0;

            @Override
            public void forEachEdge(Edge edge) {
                double fromDist;
                double x = edge.from.drawx;
                double y = edge.from.drawy;
                double dist = edge.distFromPoint(mpx, mpy);
                if (dist < this.minDist) {
                    this.minDist = dist;
                    this.minFromDist = Math.sqrt(((double)mpx - x) * ((double)mpx - x) + ((double)mpy - y) * ((double)mpy - y));
                    moeA[0] = edge;
                } else if (dist == this.minDist && (fromDist = Math.sqrt(((double)mpx - x) * ((double)mpx - x) + ((double)mpy - y) * ((double)mpy - y))) < this.minFromDist) {
                    this.minFromDist = fromDist;
                    moeA[0] = edge;
                }
            }
        };
        this.visibleLocality.forAllEdges(fee);
        this.setMouseOverN(monA[0]);
        if (monA[0] == null) {
            this.setMouseOverE(moeA[0]);
        } else {
            this.setMouseOverE(null);
        }
    }

    public TGPoint2D getTopLeftDraw() {
        return new TGPoint2D(this.topLeftDraw);
    }

    public TGPoint2D getBottomRightDraw() {
        return new TGPoint2D(this.bottomRightDraw);
    }

    public TGPoint2D getCenter() {
        return this.tgLensSet.convDrawToReal(this.getSize().width / 2, this.getSize().height / 2);
    }

    public TGPoint2D getDrawCenter() {
        return new TGPoint2D(this.getSize().width / 2, this.getSize().height / 2);
    }

    public void updateGraphSize() {
        if (this.topLeftDraw == null) {
            this.topLeftDraw = new TGPoint2D(0.0, 0.0);
        }
        if (this.bottomRightDraw == null) {
            this.bottomRightDraw = new TGPoint2D(0.0, 0.0);
        }
        TGForEachNode fen = new TGForEachNode(){
            boolean firstNode = true;

            @Override
            public void forEachNode(Node node) {
                if (this.firstNode) {
                    TGPanel.this.topLeftDraw.setLocation(node.drawx, node.drawy);
                    TGPanel.this.bottomRightDraw.setLocation(node.drawx, node.drawy);
                    this.firstNode = false;
                } else {
                    TGPanel.this.topLeftDraw.setLocation(Math.min(node.drawx, TGPanel.this.topLeftDraw.x), Math.min(node.drawy, TGPanel.this.topLeftDraw.y));
                    TGPanel.this.bottomRightDraw.setLocation(Math.max(node.drawx, TGPanel.this.bottomRightDraw.x), Math.max(node.drawy, TGPanel.this.bottomRightDraw.y));
                }
            }
        };
        this.visibleLocality.forAllNodes(fen);
    }

    public synchronized void processGraphMove() {
        this.updateDrawPositions();
        this.updateGraphSize();
    }

    public synchronized void repaintAfterMove() {
        this.processGraphMove();
        this.findMouseOver();
        this.fireMovedEvent();
        this.repaint();
    }

    public void updateDrawPos(Node node) {
        TGPoint2D p = this.tgLensSet.convRealToDraw(node.x, node.y);
        node.drawx = p.x;
        node.drawy = p.y;
    }

    public void updatePosFromDraw(Node node) {
        TGPoint2D p = this.tgLensSet.convDrawToReal(node.drawx, node.drawy);
        node.x = p.x;
        node.y = p.y;
    }

    public void updateDrawPositions() {
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node node) {
                TGPanel.this.updateDrawPos(node);
            }
        };
        this.visibleLocality.forAllNodes(fen);
    }

    Color myBrighter(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        r = Math.min(r + 96, 255);
        g = Math.min(g + 96, 255);
        b = Math.min(b + 96, 255);
        return new Color(r, g, b);
    }

    @Override
    public synchronized void paint(Graphics g) {
        this.update(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.processGraphMove();
            this.findMouseOver();
            this.fireMovedEvent();
        }
        this.offgraphics.setColor(BACK_COLOR);
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        TGPanel tGPanel = this;
        synchronized (tGPanel) {
            this.paintListeners = (Vector)this.paintListeners.clone();
        }
        for (int i = 0; i < this.paintListeners.size(); ++i) {
            TGPaintListener pl = (TGPaintListener)this.paintListeners.elementAt(i);
            pl.paintFirst(this.offgraphics);
        }
        TGForEachEdge fee = new TGForEachEdge(){

            @Override
            public void forEachEdge(Edge edge) {
                edge.paint(TGPanel.this.offgraphics, TGPanel.this);
            }
        };
        this.visibleLocality.forAllEdges(fee);
        for (int i = 0; i < this.paintListeners.size(); ++i) {
            TGPaintListener pl = (TGPaintListener)this.paintListeners.elementAt(i);
            pl.paintAfterEdges(this.offgraphics);
        }
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node node) {
                node.paint(TGPanel.this.offgraphics, TGPanel.this);
            }
        };
        this.visibleLocality.forAllNodes(fen);
        if (this.mouseOverE != null) {
            this.mouseOverE.paint(this.offgraphics, this);
            this.mouseOverE.from.paint(this.offgraphics, this);
            this.mouseOverE.to.paint(this.offgraphics, this);
        }
        if (this.select != null) {
            this.select.paint(this.offgraphics, this);
        }
        if (this.mouseOverN != null) {
            this.mouseOverN.paint(this.offgraphics, this);
        }
        for (int i = 0; i < this.paintListeners.size(); ++i) {
            TGPaintListener pl = (TGPaintListener)this.paintListeners.elementAt(i);
            pl.paintLast(this.offgraphics);
        }
        this.paintComponents(this.offgraphics);
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public static void main(String[] args) {
        Frame frame = new Frame("TGPanel");
        TGPanel tgPanel = new TGPanel();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        TGLensSet tgls = new TGLensSet();
        tgls.addLens(tgPanel.getAdjustOriginLens());
        tgPanel.setLensSet(tgls);
        try {
            tgPanel.addNode();
        }
        catch (TGException tge) {
            System.err.println(tge.getMessage());
        }
        tgPanel.setVisible(true);
        new GLEditUI(tgPanel).activate();
        frame.add("Center", tgPanel);
        frame.setSize(500, 500);
        frame.setVisible(true);
    }

    class BasicMouseMotionListener
    implements MouseMotionListener {
        BasicMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TGPanel.this.mousePos = e.getPoint();
            TGPanel.this.findMouseOver();
            try {
                Thread.currentThread();
                Thread.sleep(6L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent e) {
            TGPanel.this.mousePos = e.getPoint();
            BasicMouseMotionListener basicMouseMotionListener = this;
            synchronized (basicMouseMotionListener) {
                Edge oldMouseOverE = TGPanel.this.mouseOverE;
                Node oldMouseOverN = TGPanel.this.mouseOverN;
                TGPanel.this.findMouseOver();
                if (oldMouseOverE != TGPanel.this.mouseOverE || oldMouseOverN != TGPanel.this.mouseOverN) {
                    TGPanel.this.repaint();
                }
            }
        }
    }

    class BasicMouseListener
    extends MouseAdapter {
        BasicMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TGPanel.this.addMouseMotionListener(TGPanel.this.basicMML);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TGPanel.this.removeMouseMotionListener(TGPanel.this.basicMML);
            TGPanel.this.mousePos = null;
            TGPanel.this.setMouseOverN(null);
            TGPanel.this.setMouseOverE(null);
            TGPanel.this.repaint();
        }
    }

    public class SwitchSelectUI
    extends TGAbstractClickUI {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (TGPanel.this.mouseOverN != null) {
                if (TGPanel.this.mouseOverN != TGPanel.this.select) {
                    TGPanel.this.setSelect(TGPanel.this.mouseOverN);
                } else {
                    TGPanel.this.clearSelect();
                }
            }
        }
    }

    protected class AdjustOriginLens
    extends TGAbstractLens {
        protected AdjustOriginLens() {
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            p.x += (double)(TGPanel.this.getSize().width / 2);
            p.y += (double)(TGPanel.this.getSize().height / 2);
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            p.x -= (double)(TGPanel.this.getSize().width / 2);
            p.y -= (double)(TGPanel.this.getSize().height / 2);
        }
    }
}

