/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.jai;

import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.jai.PerspectiveShapeTransformer;
import edu.uci.ics.jung.visualization.jai.PerspectiveTransformSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public abstract class AbstractPerspectiveTransformSupport<V, E>
implements PerspectiveTransformSupport {
    protected VisualizationViewer<V, E> vv;
    protected PerspectiveShapeTransformer perspectiveTransformer;
    protected Lens lens;
    protected String defaultToolTipText;
    protected static final String instructions = "<html><center>The mouse mode button is<p>in the lower-right corner<p>of the scroll-pane.</center></html>";

    public AbstractPerspectiveTransformSupport(VisualizationViewer<V, E> vv) {
        this.vv = vv;
        this.defaultToolTipText = vv.getToolTipText();
    }

    @Override
    public void activate(boolean state) {
        if (state) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    @Override
    public PerspectiveShapeTransformer getPerspectiveTransformer() {
        return this.perspectiveTransformer;
    }

    public void setPerspectiveTransformer(PerspectiveShapeTransformer perspectiveTransformer) {
        this.perspectiveTransformer = perspectiveTransformer;
    }

    public static class Lens
    implements VisualizationServer.Paintable {
        PerspectiveShapeTransformer perspectiveTransformer;
        Rectangle2D rectangle;

        public Lens(PerspectiveShapeTransformer perspectiveTransformer, Dimension d) {
            this.perspectiveTransformer = perspectiveTransformer;
            this.rectangle = new Rectangle2D.Float(d.width / 8, d.height / 8, 3 * d.width / 4, 3 * d.height / 4);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(Color.decode("0xdddddd"));
            Shape shape = this.perspectiveTransformer.perspectiveTransform(this.rectangle);
            g2d.fill(shape);
            g.setColor(Color.gray);
            g2d.draw(shape);
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

