/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.jai;

import edu.uci.ics.jung.visualization.jai.PerspectiveTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import javax.media.jai.PerspectiveTransform;

public class PerspectiveShapeTransformer
extends PerspectiveTransformer
implements ShapeTransformer {
    public PerspectiveShapeTransformer(PerspectiveTransform perspectiveTransform) {
        this(perspectiveTransform, null);
    }

    public PerspectiveShapeTransformer(PerspectiveTransform perspectiveTransform, MutableTransformer delegate) {
        super(perspectiveTransform, delegate);
    }

    @Override
    public Shape transform(Shape shape) {
        return this.transform(shape, 0.0f);
    }

    public Shape transform(Shape shape, float flatness) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = null;
        iterator = flatness == 0.0f ? shape.getPathIterator(null) : shape.getPathIterator(null, flatness);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.transform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this.transform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.transform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this.transform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    @Override
    public Shape inverseTransform(Shape shape) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this.inverseTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.inverseTransform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this.inverseTransform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    public Shape perspectiveTransform(Shape shape) {
        return this.perspectiveTransform(shape, 0.0f);
    }

    public Shape perspectiveTransform(Shape shape, float flatness) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = null;
        iterator = flatness == 0.0f ? shape.getPathIterator(null) : shape.getPathIterator(null, flatness);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this.perspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this.perspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this.perspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.perspectiveTransform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this.perspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.perspectiveTransform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this.perspectiveTransform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }

    public Shape inversePerspectiveTransform(Shape shape) {
        GeneralPath newPath = new GeneralPath();
        float[] coords = new float[6];
        PathIterator iterator = shape.getPathIterator(null);
        while (!iterator.isDone()) {
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    Point2D p = this.inversePerspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.moveTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 1: {
                    Point2D p = this.inversePerspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    newPath.lineTo((float)p.getX(), (float)p.getY());
                    break;
                }
                case 2: {
                    Point2D p = this.inversePerspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.inversePerspectiveTransform(new Point2D.Float(coords[2], coords[3]));
                    newPath.quadTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY());
                    break;
                }
                case 3: {
                    Point2D p = this.inversePerspectiveTransform(new Point2D.Float(coords[0], coords[1]));
                    Point2D q = this.inversePerspectiveTransform(new Point2D.Float(coords[2], coords[3]));
                    Point2D r = this.inversePerspectiveTransform(new Point2D.Float(coords[4], coords[5]));
                    newPath.curveTo((float)p.getX(), (float)p.getY(), (float)q.getX(), (float)q.getY(), (float)r.getX(), (float)r.getY());
                    break;
                }
                case 4: {
                    newPath.closePath();
                }
            }
            iterator.next();
        }
        return newPath;
    }
}

