/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import lcmc.data.Host;
import lcmc.gui.ClustersPanel;
import lcmc.gui.TerminalPanel;
import lcmc.utilities.Tools;

public final class MainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean expandingDone = false;
    private final Lock mExpanding = new ReentrantLock();

    public MainPanel() {
        super(new BorderLayout());
        TerminalPanel terminalPanel = new TerminalPanel(new Host());
        JSplitPane splitPane = new JSplitPane(0, new ClustersPanel(), terminalPanel);
        Tools.getGUIData().setTerminalSplitPane(splitPane);
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        splitPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                MainPanel.this.mExpanding.lock();
                if (!MainPanel.this.expandingDone && (e.getChangeFlags() & 4L) != 0L) {
                    MainPanel.this.expandingDone = true;
                    MainPanel.this.mExpanding.unlock();
                    Tools.getGUIData().expandTerminalSplitPane(1);
                } else {
                    MainPanel.this.mExpanding.unlock();
                }
            }
        });
        this.add((Component)splitPane, "Center");
    }
}

