/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import lcmc.configs.AppDefaults;
import lcmc.gui.Browser;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public final class ProgressIndicatorPanel
extends JComponent
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private boolean started = false;
    private int alphaLevel = 0;
    private int rampDelay = 1000;
    private static final int RAMP_DELAY_STOP = 1000;
    private float shield = 0.8f;
    private final Map<String, Integer> texts = new LinkedHashMap<String, Integer>();
    private final Map<String, Point2D> textsPositions = new HashMap<String, Point2D>();
    private final List<String> failuresMap = new LinkedList<String>();
    private static final float FPS = Tools.getConfigData().getAnimFPS();
    private RenderingHints hints = null;
    private final Lock mAnimatorLock = new ReentrantLock();
    private final Lock mTextsLock = new ReentrantLock();
    private static final ImageIcon CANCEL_ICON = Tools.createImageIcon(Tools.getDefault("ProgressIndicatorPanel.CancelIcon"));
    private final MyButton cancelButton = new MyButton(Tools.getString("ProgressIndicatorPanel.Cancel"), CANCEL_ICON);
    private Animator animator;
    private int oldWidth = this.getWidth();
    private int oldHeight = this.getHeight();
    private double barPos = -1.0;
    private double barWidth = 10.0;
    private static final int MAX_ALPHA_LEVEL = 255;
    private static final Color VEIL2_COLOR = Browser.STATUS_BACKGROUND;
    private static final Color VEIL_COLOR = Browser.PANEL_BACKGROUND;

    public ProgressIndicatorPanel() {
        this(0.4f);
    }

    ProgressIndicatorPanel(float shieldA) {
        this(shieldA, 300);
    }

    ProgressIndicatorPanel(float shield, int rampDelay) {
        this.rampDelay = rampDelay >= 0 ? rampDelay : 0;
        this.shield = shield >= 0.0f ? shield : 0.0f;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.cancelButton.setBounds(0, 0, this.cancelButton.getPreferredSize().width, this.cancelButton.getPreferredSize().height);
    }

    public void failure(String text) {
        Tools.appWarning(text);
        if (text == null) {
            return;
        }
        this.failuresMap.add(text);
        this.start(text, null);
        Tools.sleep(1000);
        this.stop(text);
    }

    public void failure(String text, int n) {
        Tools.appWarning(text);
        if (text == null || n < 0) {
            return;
        }
        this.failuresMap.add(text);
        this.start(text, null);
        Tools.sleep(n);
        this.stop(text);
    }

    public void start(String text, Point2D position) {
        if (text == null) {
            return;
        }
        this.mAnimatorLock.lock();
        this.mTextsLock.lock();
        if (this.texts.containsKey(text)) {
            this.texts.put(text, 255);
            this.textsPositions.put(text, position);
            this.mTextsLock.unlock();
            this.animator.setRampUp(true);
            this.mAnimatorLock.unlock();
            return;
        }
        this.texts.put(text, 255);
        this.textsPositions.put(text, position);
        if (this.texts.size() > 1) {
            this.mTextsLock.unlock();
            this.animator.setRampUp(true);
            this.mAnimatorLock.unlock();
            return;
        }
        this.mTextsLock.unlock();
        Tools.getGUIData().getMainMenu().turnOff();
        this.cancelButton.setEnabled(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.animator = new Animator();
        Thread t = new Thread(this.animator);
        t.start();
        this.mAnimatorLock.unlock();
    }

    public void stop(String text) {
        if (text == null) {
            return;
        }
        this.mAnimatorLock.lock();
        this.mTextsLock.lock();
        if (!this.texts.containsKey(text)) {
            Tools.appWarning("progress indicator already stopped for: --" + text + "--");
            this.mTextsLock.unlock();
            this.mAnimatorLock.unlock();
            Tools.printStackTrace();
            return;
        }
        this.texts.put(text, 250);
        for (String t : this.texts.keySet()) {
            int a = this.texts.get(t);
            if (a != 255) continue;
            this.mTextsLock.unlock();
            this.mAnimatorLock.unlock();
            return;
        }
        this.mTextsLock.unlock();
        this.animator.setRampUp(false);
        this.removeMouseListener(this);
        this.removeKeyListener(this);
        Tools.getGUIData().getMainMenu().turnOn();
        this.mAnimatorLock.unlock();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.started) {
            int width = this.getWidth();
            double maxY = 0.0;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this.hints);
            g2.setColor(new Color(VEIL_COLOR.getRed(), VEIL_COLOR.getGreen(), VEIL_COLOR.getBlue(), (int)((float)this.alphaLevel * this.shield)));
            int startAtHeight = 22;
            g2.fillRect(0, 22, width, Tools.getGUIData().getTerminalPanelPos() - 22);
            if (this.barPos < 0.0) {
                this.barPos = width / 2;
            }
            if (this.barPos < (double)width) {
                int he = Tools.getGUIData().getTerminalPanelPos() - 22;
                g2.setColor(new Color(VEIL2_COLOR.getRed(), VEIL2_COLOR.getGreen(), VEIL2_COLOR.getBlue(), (int)((double)((float)this.alphaLevel * this.shield) * 0.3)));
                if (this.barPos < (double)(width / 2)) {
                    g2.fillRect((int)this.barPos, 22, (int)((double)width - this.barPos * 2.0), he);
                } else {
                    g2.fillRect((int)((double)width - this.barPos), 22, (int)(this.barPos * 2.0 - (double)width), he);
                }
            }
            this.barPos += 100.0 / (double)FPS;
            if (this.barPos >= (double)(width / 2) + this.barWidth / 2.0) {
                this.barPos = (double)(width / 2) - this.barWidth / 2.0;
            }
            this.mTextsLock.lock();
            if (!this.texts.isEmpty()) {
                FontRenderContext context = g2.getFontRenderContext();
                Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), (int)((double)this.getFont().getSize() * 1.75));
                maxY = this.getHeight() / 2 - 30;
                int y = 0;
                int x = 0;
                for (String text : this.texts.keySet()) {
                    float textPosY;
                    float textPosX;
                    if (text == null || text.length() == 0) continue;
                    int alpha = this.texts.get(text);
                    TextLayout layout = new TextLayout(text, new Font(font.getName(), font.getStyle(), font.getSize()), context);
                    Rectangle2D bounds = layout.getBounds();
                    Color f = this.failuresMap.contains(text) ? new Color(255, 0, 0) : AppDefaults.BACKGROUND_DARK;
                    g2.setColor(new Color(f.getRed(), f.getGreen(), f.getBlue(), alpha));
                    Point2D textPos = this.textsPositions.get(text);
                    if (textPos == null) {
                        textPosX = (float)((double)width - bounds.getWidth()) / 2.0f;
                        textPosY = (float)(maxY + (double)layout.getLeading() + (double)(2.0f * layout.getAscent()));
                    } else {
                        textPosX = (float)textPos.getX();
                        textPosY = (float)textPos.getY();
                    }
                    layout.draw(g2, textPosX, textPosY + (float)y);
                    x = (int)((float)x + (float)(10 + 15 * text.length()) / 255.0f * (float)alpha);
                    y = (int)((float)y + 0.105882354f * (float)alpha);
                    if (!(bounds.getWidth() > this.barWidth)) continue;
                    this.barWidth = bounds.getWidth() + 30.0;
                }
            }
            this.mTextsLock.unlock();
            super.paintComponent(g2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class Animator
    implements Runnable {
        private volatile boolean rampUp = true;

        protected Animator() {
        }

        private void setRampUp(boolean rampUp) {
            this.rampUp = rampUp;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            if (ProgressIndicatorPanel.this.rampDelay == 0) {
                ProgressIndicatorPanel.this.alphaLevel = this.rampUp ? 255 : 0;
            }
            ProgressIndicatorPanel.this.started = true;
            while (true) {
                int newAlphaLevel;
                boolean lRampUp = this.rampUp;
                if (ProgressIndicatorPanel.this.getWidth() != ProgressIndicatorPanel.this.oldWidth || ProgressIndicatorPanel.this.getHeight() != ProgressIndicatorPanel.this.oldHeight) {
                    ProgressIndicatorPanel.this.oldWidth = ProgressIndicatorPanel.this.getWidth();
                    ProgressIndicatorPanel.this.oldHeight = ProgressIndicatorPanel.this.getHeight();
                }
                long time = System.currentTimeMillis();
                if (lRampUp) {
                    newAlphaLevel = ProgressIndicatorPanel.this.alphaLevel + (int)(255L * (time - start) / (long)ProgressIndicatorPanel.this.rampDelay);
                    if (newAlphaLevel >= 255) {
                        newAlphaLevel = 255;
                    }
                    ProgressIndicatorPanel.this.alphaLevel = newAlphaLevel;
                } else {
                    newAlphaLevel = ProgressIndicatorPanel.this.alphaLevel - (int)(255L * (time - start) / 1000L);
                    if (newAlphaLevel <= 0) {
                        newAlphaLevel = 0;
                        ProgressIndicatorPanel.this.mTextsLock.lock();
                        if (ProgressIndicatorPanel.this.texts.size() <= 0) break;
                        ProgressIndicatorPanel.this.mTextsLock.unlock();
                    }
                    ProgressIndicatorPanel.this.alphaLevel = newAlphaLevel;
                }
                ArrayList<String> toRemove = new ArrayList<String>();
                ProgressIndicatorPanel.this.mTextsLock.lock();
                for (String text : ProgressIndicatorPanel.this.texts.keySet()) {
                    int alpha = (Integer)ProgressIndicatorPanel.this.texts.get(text);
                    if (alpha >= 255) continue;
                    int delay = 1000;
                    if (ProgressIndicatorPanel.this.failuresMap.contains(text)) {
                        delay = 10000;
                    }
                    if ((alpha -= (int)(255L * (time - start) / (long)delay)) < 0) {
                        toRemove.add(text);
                        continue;
                    }
                    ProgressIndicatorPanel.this.texts.put(text, alpha);
                }
                for (String text : toRemove) {
                    ProgressIndicatorPanel.this.texts.remove(text);
                    ProgressIndicatorPanel.this.textsPositions.remove(text);
                    ProgressIndicatorPanel.this.failuresMap.remove(text);
                }
                ProgressIndicatorPanel.this.mTextsLock.unlock();
                try {
                    Thread.sleep((int)(1000.0f / FPS));
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                start = time;
                ProgressIndicatorPanel.this.repaint();
                Thread.yield();
            }
            ProgressIndicatorPanel.this.mTextsLock.unlock();
            ProgressIndicatorPanel.this.started = false;
            ProgressIndicatorPanel.this.barWidth = 10.0;
        }
    }
}

