/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.Color;
import java.util.ArrayList;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.resources.CategoryInfo;
import lcmc.gui.resources.HostInfo;
import lcmc.utilities.MyButton;

public final class ClusterHostsInfo
extends CategoryInfo {
    public ClusterHostsInfo(String name, Browser browser) {
        super(name, browser);
    }

    @Override
    protected ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    @Override
    protected String[] getColumnNames(String tableName) {
        return new String[]{"Host", "DRBD", "Cluster Software"};
    }

    @Override
    protected Object[][] getTableData(String tableName) {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (Host host : this.getBrowser().getClusterHosts()) {
            MyButton hostLabel = new MyButton(host.getName(), HostBrowser.HOST_ICON_LARGE);
            hostLabel.setOpaque(true);
            rows.add(new Object[]{hostLabel, host.getBrowser().getDrbdInfo(), host.getBrowser().getPacemakerInfo()});
        }
        return (Object[][])rows.toArray((T[])new Object[rows.size()][]);
    }

    @Override
    protected void rowClicked(String tableName, String key, int column) {
        Host host = this.getBrowser().getCluster().getHostByName(key);
        HostInfo hi = host.getBrowser().getHostInfo();
        if (hi != null) {
            hi.selectMyself();
        }
    }

    @Override
    protected Color getTableRowColor(String tableName, String key) {
        Host host = this.getBrowser().getCluster().getHostByName(key);
        Color c = host.getPmColors()[0];
        if (c == null) {
            return Browser.PANEL_BACKGROUND;
        }
        return c;
    }
}

