/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import lcmc.ProxyHostWizard;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.DrbdGraph;
import lcmc.gui.HostBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.drbd.DrbdsLog;
import lcmc.gui.resources.Info;
import lcmc.utilities.DRBD;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class ProxyHostInfo
extends Info {
    private final Host host;
    private final String NAME_PREFIX = Tools.getString("ProxyHostInfo.NameInfo");
    private final String NOT_CONNECTABLE_STRING = Tools.getString("ProxyHostInfo.NotConnectable");

    public ProxyHostInfo(Host host, Browser browser) {
        super(host.getName(), browser);
        this.host = host;
    }

    @Override
    protected HostBrowser getBrowser() {
        return (HostBrowser)super.getBrowser();
    }

    @Override
    public ImageIcon getMenuIcon(boolean testOnly) {
        return HostBrowser.HOST_ICON;
    }

    @Override
    public String getId() {
        return this.host.getName();
    }

    @Override
    public ImageIcon getCategoryIcon(boolean testOnly) {
        return HostBrowser.HOST_ICON;
    }

    @Override
    public JComponent getInfoPanel() {
        Font f = new Font("Monospaced", 0, Tools.getConfigData().scaled(12));
        final JTextArea ta = new JTextArea();
        ta.setFont(f);
        final String stacktrace = Tools.getStackTrace();
        final ExecCallback execCallback = new ExecCallback(){

            @Override
            public void done(String ans) {
                ta.setText(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                ta.setText("error");
                Tools.sshError(ProxyHostInfo.this.host, "", ans, stacktrace, exitCode);
            }
        };
        MyButton procDrbdButton = new MyButton("Show Proxy Info");
        procDrbdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxyHostInfo.this.host.execCommand("DRBD.showProxyInfo", execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            }
        });
        this.host.registerEnableOnConnect(procDrbdButton);
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(HostBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(HostBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, Tools.getConfigData().scaled(50)));
        buttonPanel.setPreferredSize(new Dimension(0, Tools.getConfigData().scaled(50)));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Tools.getConfigData().scaled(50)));
        mainPanel.add(buttonPanel);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        JPanel p = new JPanel(new SpringLayout());
        p.setBackground(HostBrowser.BUTTON_PANEL_BACKGROUND);
        p.add(procDrbdButton);
        SpringUtilities.makeCompactGrid(p, 1, 1, 1, 1, 1, 1);
        mainPanel.setMinimumSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        mainPanel.setPreferredSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        buttonPanel.add(p);
        mainPanel.add(new JScrollPane(ta));
        this.host.execCommand("DRBD.showProxyInfo", execCallback, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        return mainPanel;
    }

    public Host getHost() {
        return this.host;
    }

    boolean equals(ProxyHostInfo otherHI) {
        if (otherHI == null) {
            return false;
        }
        return otherHI.toString().equals(this.host.getName());
    }

    @Override
    public String toString() {
        return this.NAME_PREFIX + this.host.getName();
    }

    @Override
    public String getName() {
        return this.host.getName();
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        MyMenuItem connectItem = new MyMenuItem(Tools.getString("HostDrbdInfo.Connect"), null, Tools.getString("HostDrbdInfo.Connect"), Tools.getString("HostDrbdInfo.Disconnect"), null, Tools.getString("HostDrbdInfo.Disconnect"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return !ProxyHostInfo.this.getHost().isConnected();
            }

            @Override
            public String enablePredicate() {
                if (ProxyHostInfo.this.getHost().getUsername() == null) {
                    return ProxyHostInfo.this.NOT_CONNECTABLE_STRING;
                }
                return null;
            }

            @Override
            public void action() {
                if (ProxyHostInfo.this.getHost().isConnected()) {
                    ProxyHostInfo.this.getHost().disconnect();
                } else {
                    ProxyHostInfo.this.host.connect(null, null);
                }
                ProxyHostInfo.this.getBrowser().getClusterBrowser().updateProxyHWInfo(ProxyHostInfo.this.host);
            }
        };
        items.add(connectItem);
        MyMenuItem hostWizardItem = new MyMenuItem(Tools.getString("HostBrowser.ProxyHostWizard"), HostBrowser.HOST_ICON_LARGE, Tools.getString("HostBrowser.ProxyHostWizard"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                ProxyHostWizard dialog = new ProxyHostWizard(ProxyHostInfo.this.host, null);
                dialog.showDialogs();
            }
        };
        items.add(hostWizardItem);
        Tools.getGUIData().registerAddHostButton(hostWizardItem);
        boolean testOnly = false;
        MyMenuItem proxyItem = new MyMenuItem(Tools.getString("HostDrbdInfo.Drbd.StopProxy"), null, this.getMenuToolTip("DRBD.stopProxy", ""), Tools.getString("HostDrbdInfo.Drbd.StartProxy"), null, this.getMenuToolTip("DRBD.startProxy", ""), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean predicate() {
                return ProxyHostInfo.this.getHost().isDrbdProxyRunning();
            }

            @Override
            public String enablePredicate() {
                if (!ProxyHostInfo.this.getHost().isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                if (ProxyHostInfo.this.getHost().isDrbdProxyRunning()) {
                    DRBD.stopProxy(ProxyHostInfo.this.getHost(), false);
                } else {
                    DRBD.startProxy(ProxyHostInfo.this.getHost(), false);
                }
                ProxyHostInfo.this.getBrowser().getClusterBrowser().updateProxyHWInfo(ProxyHostInfo.this.host);
            }
        };
        items.add(proxyItem);
        MyMenuItem allProxyUpItem = new MyMenuItem(Tools.getString("HostDrbdInfo.Drbd.AllProxyUp"), null, this.getMenuToolTip("DRBD.proxyUp", "all"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                if (!ProxyHostInfo.this.host.isConnected()) {
                    return false;
                }
                return ProxyHostInfo.this.host.isDrbdProxyRunning();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                DRBD.proxyUp(ProxyHostInfo.this.host, "all", null, false);
                ProxyHostInfo.this.getBrowser().getClusterBrowser().updateProxyHWInfo(ProxyHostInfo.this.host);
            }
        };
        items.add(allProxyUpItem);
        MyMenuItem allProxyDownItem = new MyMenuItem(Tools.getString("HostDrbdInfo.Drbd.AllProxyDown"), null, this.getMenuToolTip("DRBD.proxyDown", "all"), new AccessMode(ConfigData.AccessType.ADMIN, true), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean visiblePredicate() {
                if (!ProxyHostInfo.this.host.isConnected()) {
                    return false;
                }
                return ProxyHostInfo.this.host.isDrbdProxyRunning();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                DRBD.proxyDown(ProxyHostInfo.this.host, "all", null, false);
                ProxyHostInfo.this.getBrowser().getClusterBrowser().updateProxyHWInfo(ProxyHostInfo.this.host);
            }
        };
        items.add(allProxyDownItem);
        MyMenuItem viewLogsItem = new MyMenuItem(Tools.getString("HostBrowser.Drbd.ViewLogs"), LOGFILE_ICON, Tools.getString("HostBrowser.Drbd.ViewLogs"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!ProxyHostInfo.this.getHost().isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                DrbdsLog l = new DrbdsLog(ProxyHostInfo.this.host);
                l.showDialog();
            }
        };
        items.add(viewLogsItem);
        MyMenuItem removeHostItem = new MyMenuItem(Tools.getString("HostBrowser.RemoveHost"), HostBrowser.HOST_REMOVE_ICON, Tools.getString("HostBrowser.RemoveHost"), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ProxyHostInfo.this.getHost().getCluster() != null) {
                    return "it is a member of a cluster";
                }
                return null;
            }

            @Override
            public void action() {
                ProxyHostInfo.this.getHost().disconnect();
                Tools.getConfigData().removeHostFromHosts(ProxyHostInfo.this.getHost());
                Tools.getGUIData().allHostsUpdate();
            }
        };
        items.add(removeHostItem);
        return items;
    }

    @Override
    public JPanel getGraphicalView() {
        DrbdGraph dg = this.getBrowser().getDrbdGraph();
        if (dg == null) {
            return null;
        }
        dg.getDrbdInfo().setSelectedNode(null);
        return dg.getDrbdInfo().getGraphicalView();
    }

    private String getMenuToolTip(String cmd, String res) {
        return this.getHost().getDistString(cmd).replaceAll("@RES-VOL@", res).replaceAll("@.*?@", "");
    }
}

