/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.progress;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.hamcrest.Matcher;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.matchers.And;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.matchers.Not;
import org.mockito.internal.matchers.Or;
import org.mockito.internal.progress.ArgumentMatcherStorage;
import org.mockito.internal.progress.HandyReturnValues;

public class ArgumentMatcherStorageImpl
implements ArgumentMatcherStorage {
    public static final int TWO_SUB_MATCHERS = 2;
    public static final int ONE_SUB_MATCHER = 1;
    private final Stack<LocalizedMatcher> matcherStack = new Stack();

    @Override
    public HandyReturnValues reportMatcher(Matcher matcher) {
        this.matcherStack.push(new LocalizedMatcher(matcher));
        return new HandyReturnValues();
    }

    @Override
    public List<LocalizedMatcher> pullLocalizedMatchers() {
        if (this.matcherStack.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocalizedMatcher> arrayList = new ArrayList<LocalizedMatcher>(this.matcherStack);
        this.matcherStack.clear();
        return arrayList;
    }

    @Override
    public HandyReturnValues reportAnd() {
        this.assertStateFor("And(?)", 2);
        And and = new And(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher((Matcher)and));
        return new HandyReturnValues();
    }

    @Override
    public HandyReturnValues reportOr() {
        this.assertStateFor("Or(?)", 2);
        Or or = new Or(this.popLastArgumentMatchers(2));
        this.matcherStack.push(new LocalizedMatcher((Matcher)or));
        return new HandyReturnValues();
    }

    @Override
    public HandyReturnValues reportNot() {
        this.assertStateFor("Not(?)", 1);
        Not not = new Not(this.popLastArgumentMatchers(1).get(0));
        this.matcherStack.push(new LocalizedMatcher((Matcher)not));
        return new HandyReturnValues();
    }

    private void assertStateFor(String string, int n) {
        this.assertMatchersFoundFor(string);
        this.assertIncorrectUseOfAdditionalMatchers(string, n);
    }

    private List<Matcher> popLastArgumentMatchers(int n) {
        LinkedList<Matcher> linkedList = new LinkedList<Matcher>();
        linkedList.addAll(this.matcherStack.subList(this.matcherStack.size() - n, this.matcherStack.size()));
        for (int i = 0; i < n; ++i) {
            this.matcherStack.pop();
        }
        return linkedList;
    }

    private void assertMatchersFoundFor(String string) {
        if (this.matcherStack.isEmpty()) {
            this.matcherStack.clear();
            new Reporter().reportNoSubMatchersFound(string);
        }
    }

    private void assertIncorrectUseOfAdditionalMatchers(String string, int n) {
        if (this.matcherStack.size() < n) {
            ArrayList<LocalizedMatcher> arrayList = new ArrayList<LocalizedMatcher>(this.matcherStack);
            this.matcherStack.clear();
            new Reporter().incorrectUseOfAdditionalMatchers(string, n, arrayList);
        }
    }

    @Override
    public void validateState() {
        if (!this.matcherStack.isEmpty()) {
            ArrayList<LocalizedMatcher> arrayList = new ArrayList<LocalizedMatcher>(this.matcherStack);
            this.matcherStack.clear();
            new Reporter().misplacedArgumentMatcher(arrayList);
        }
    }

    @Override
    public void reset() {
        this.matcherStack.clear();
    }
}

