/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class BeanPropertySetter {
    private static final String SET_PREFIX = "set";
    private final Object target;
    private final boolean reportNoSetterFound;
    private final Field field;

    public BeanPropertySetter(Object object, Field field, boolean bl) {
        this.field = field;
        this.target = object;
        this.reportNoSetterFound = bl;
    }

    public BeanPropertySetter(Object object, Field field) {
        this(object, field, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(Object object) {
        AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
        Method method = null;
        try {
            method = this.target.getClass().getMethod(this.setterName(this.field.getName()), this.field.getType());
            accessibilityChanger.enableAccess(method);
            method.invoke(this.target, object);
            boolean bl = true;
            if (method == null) return bl;
            accessibilityChanger.safelyDisableAccess(method);
            return bl;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Setter '" + method + "' of '" + this.target + "' with value '" + object + "' threw exception : '" + invocationTargetException.getTargetException() + "'", invocationTargetException);
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target + "' with value: '" + object + "'", illegalAccessException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.reportNoSetterFound();
            }
        }
        finally {
            if (method != null) {
                accessibilityChanger.safelyDisableAccess(method);
            }
        }
        this.reportNoSetterFound();
        return false;
    }

    private String setterName(String string) {
        return SET_PREFIX + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    private void reportNoSetterFound() {
        if (this.reportNoSetterFound) {
            throw new RuntimeException("Problems setting value on object: [" + this.target + "] for property : [" + this.field.getName() + "], setter not found");
        }
    }
}

