/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class IDFilter
extends XMLFilterImpl {
    private String id;
    private int activeDepth = 0;
    private Stack namespacePrefixes = new Stack();
    private Stack namespaceURIs = new Stack();

    public IDFilter(String string) {
        this.id = string;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.activeDepth > 0) {
            super.startPrefixMapping(string, string2);
        } else {
            this.namespacePrefixes.push(string);
            this.namespaceURIs.push(string2);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this.activeDepth > 0) {
            super.endPrefixMapping(string);
        } else {
            this.namespacePrefixes.pop();
            this.namespaceURIs.pop();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.activeDepth == 0) {
            int n;
            for (n = 0; n < attributes.getLength(); ++n) {
                if (!attributes.getType(n).equals("ID") || !attributes.getValue(n).equals(this.id)) continue;
                this.activeDepth = 1;
                break;
            }
            if (this.activeDepth == 1) {
                for (n = 0; n < this.namespacePrefixes.size(); ++n) {
                    super.startPrefixMapping((String)this.namespacePrefixes.elementAt(n), (String)this.namespaceURIs.elementAt(n));
                }
            }
        } else {
            ++this.activeDepth;
        }
        if (this.activeDepth > 0) {
            super.startElement(string, string2, string3, attributes);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.activeDepth > 0) {
            super.endElement(string, string2, string3);
            --this.activeDepth;
            if (this.activeDepth == 0) {
                for (int i = this.namespacePrefixes.size() - 1; i >= 0; --i) {
                    super.endPrefixMapping((String)this.namespacePrefixes.elementAt(i));
                }
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.activeDepth > 0) {
            super.characters(cArray, n, n2);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.activeDepth > 0) {
            super.ignorableWhitespace(cArray, n, n2);
        }
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.activeDepth > 0) {
            super.processingInstruction(string, string2);
        }
    }
}

