/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sql;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.style.StyleElement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SQLConnect
extends StyleElement {
    Expression database;
    Expression driver;
    Expression user;
    Expression password;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = this.attributeList.getValue("database");
        if (string == null) {
            this.reportAbsence("database");
        }
        this.database = this.makeAttributeValueTemplate(string);
        String string2 = this.attributeList.getValue("driver");
        if (string2 == null) {
            if (string.substring(0, 9).equals("jdbc:odbc")) {
                string2 = "sun.jdbc.odbc.JdbcOdbcDriver";
            } else {
                this.reportAbsence("driver");
            }
        }
        this.driver = this.makeAttributeValueTemplate(string2);
        String string3 = this.attributeList.getValue("user");
        this.user = string3 == null ? new StringValue("") : this.makeAttributeValueTemplate(string3);
        String string4 = this.attributeList.getValue("password");
        this.password = string4 == null ? new StringValue("") : this.makeAttributeValueTemplate(string4);
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    @Override
    public void process(Context context) throws TransformerException {
        Connection connection = null;
        Statement statement = null;
        String string = this.database.evaluateAsString(context);
        String string2 = this.driver.evaluateAsString(context);
        String string3 = this.user.evaluateAsString(context);
        String string4 = this.password.evaluateAsString(context);
        try {
            Class.forName(string2);
            connection = DriverManager.getConnection(string, string3, string4);
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            throw new TransformerException("JDBC Connection Failure: " + exception.getMessage());
        }
        DocumentInfo documentInfo = context.getCurrentNodeInfo().getDocumentRoot();
        context.getController().setUserData(documentInfo, "sql:connection", connection);
        context.getController().setUserData(documentInfo, "sql:statement", statement);
    }
}

