/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.AttributeValueTemplate;
import com.icl.saxon.expr.ErrorExpression;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeListExpression;
import com.icl.saxon.expr.SortedSelection;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.StyleSheetFunctionCall;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NoNodeTest;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.style.ExpressionContext;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleException;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.style.XSLApplyTemplates;
import com.icl.saxon.style.XSLAttributeSet;
import com.icl.saxon.style.XSLFallback;
import com.icl.saxon.style.XSLSort;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.style.XSLWithParam;
import com.icl.saxon.trace.TraceListener;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementWithAttributes;
import com.icl.saxon.tree.NodeImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementWithAttributes
implements Locator {
    protected Vector attributeSets = null;
    protected short[] extensionNamespaces = null;
    private short[] excludedNamespaces = null;
    protected String version = null;
    protected StaticContext staticContext = null;
    protected TransformerConfigurationException validationError = null;
    protected int reportingCircumstances = 1;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;

    public void substituteFor(StyleElement styleElement) {
        this.parent = styleElement.parent;
        this.attributeList = styleElement.attributeList;
        this.namespaceList = styleElement.namespaceList;
        this.nameCode = styleElement.nameCode;
        this.sequence = styleElement.sequence;
        this.attributeSets = styleElement.attributeSets;
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.excludedNamespaces = styleElement.excludedNamespaces;
        this.version = styleElement.version;
        this.root = styleElement.root;
        this.staticContext = styleElement.staticContext;
        this.validationError = styleElement.validationError;
        this.reportingCircumstances = styleElement.reportingCircumstances;
    }

    protected void setValidationError(TransformerException transformerException, int n) {
        this.validationError = transformerException instanceof TransformerConfigurationException ? (TransformerConfigurationException)transformerException : new TransformerConfigurationException(transformerException);
        this.reportingCircumstances = n;
    }

    public boolean isInstruction() {
        return false;
    }

    public boolean doesPostProcessing() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return false;
    }

    public XSLStyleSheet getContainingStyleSheet() {
        NodeImpl nodeImpl = this;
        while (!(nodeImpl instanceof XSLStyleSheet)) {
            nodeImpl = (NodeImpl)nodeImpl.getParent();
        }
        return (XSLStyleSheet)nodeImpl;
    }

    public int getPrecedence() {
        return this.getContainingStyleSheet().getPrecedence();
    }

    public final StandardNames getStandardNames() {
        DocumentImpl documentImpl = (DocumentImpl)this.getDocumentRoot();
        return ((StyleNodeFactory)documentImpl.getNodeFactory()).getStandardNames();
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            if (nodeImpl instanceof XSLStyleSheet) {
                ((XSLStyleSheet)nodeImpl).compileError(nodeImpl.getDisplayName() + " cannot appear as a child of another element");
                continue;
            }
            if (!(nodeImpl instanceof StyleElement)) continue;
            ((StyleElement)nodeImpl).processAllAttributes();
        }
    }

    public final void processAttributes() throws TransformerConfigurationException {
        try {
            this.prepareAttributes();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.setValidationError(transformerConfigurationException, 2);
            }
            this.compileError(transformerConfigurationException);
        }
    }

    protected void checkUnknownAttribute(int n) throws TransformerConfigurationException {
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        String string = this.getNamePool().getURI(n);
        String string2 = this.getURI();
        int n2 = n & 0xFFFFF;
        StandardNames standardNames = this.getStandardNames();
        if (this.isInstruction() && string.equals("http://www.w3.org/1999/XSL/Transform") && !string2.equals("http://www.w3.org/1999/XSL/Transform") && (n2 == standardNames.XSL_EXTENSION_ELEMENT_PREFIXES || n2 == standardNames.XSL_EXCLUDE_RESULT_PREFIXES || n2 == standardNames.XSL_VERSION)) {
            return;
        }
        if (string.equals("") || string.equals("http://www.w3.org/1999/XSL/Transform")) {
            this.compileError("Attribute " + this.getNamePool().getDisplayName(n) + " is not allowed on this element");
        }
    }

    public abstract void prepareAttributes() throws TransformerConfigurationException;

    public Expression makeExpression(String string) throws TransformerConfigurationException {
        try {
            return Expression.make(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new ErrorExpression(xPathException);
        }
    }

    public Pattern makePattern(String string) throws TransformerConfigurationException {
        try {
            return Pattern.make(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                return NoNodeTest.getInstance();
            }
            this.compileError(xPathException);
            return NoNodeTest.getInstance();
        }
    }

    public Expression makeAttributeValueTemplate(String string) throws TransformerConfigurationException {
        try {
            return AttributeValueTemplate.make(string, this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new StringValue(string);
        }
    }

    protected void processExtensionElementAttribute(int n) throws TransformerConfigurationException {
        String string = this.getAttributeValue(n & 0xFFFFF);
        if (string != null) {
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n2;
            }
            this.extensionNamespaces = new short[n2];
            n2 = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string);
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken();
                if (string2.equals("#default")) {
                    string2 = "";
                }
                try {
                    short s = this.getURICodeForPrefix(string2);
                    this.extensionNamespaces[n2++] = s;
                }
                catch (NamespaceException namespaceException) {
                    this.extensionNamespaces = null;
                    this.compileError(namespaceException.getMessage());
                }
            }
        }
    }

    protected void processExcludedNamespaces(int n) throws TransformerConfigurationException {
        String string = this.getAttributeValue(n & 0xFFFFF);
        if (string != null) {
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n2;
            }
            this.excludedNamespaces = new short[n2];
            n2 = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string);
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken();
                if (string2.equals("#default")) {
                    string2 = "";
                }
                try {
                    short s = this.getURICodeForPrefix(string2);
                    this.excludedNamespaces[n2++] = s;
                }
                catch (NamespaceException namespaceException) {
                    this.excludedNamespaces = null;
                    this.compileError(namespaceException.getMessage());
                }
            }
        }
    }

    protected void processVersionAttribute(int n) {
        this.version = this.getAttributeValue(n & 0xFFFFF);
    }

    public String getVersion() {
        if (this.version == null) {
            NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
            this.version = nodeInfo instanceof StyleElement ? ((StyleElement)nodeInfo).getVersion() : "1.0";
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return !this.getVersion().equals("1.0");
    }

    protected boolean definesExtensionElement(short s) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.extensionNamespaces.length; ++i) {
            if (this.extensionNamespaces[i] != s) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(short s) {
        NodeImpl nodeImpl = this;
        while (nodeImpl instanceof StyleElement) {
            if (nodeImpl.definesExtensionElement(s)) {
                return true;
            }
            nodeImpl = (NodeImpl)nodeImpl.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(short s) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (int i = 0; i < this.excludedNamespaces.length; ++i) {
            if (this.excludedNamespaces[i] != s) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(short s) {
        if (s == 2) {
            return true;
        }
        if (this.isExtensionNamespace(s)) {
            return true;
        }
        NodeImpl nodeImpl = this;
        while (nodeImpl instanceof StyleElement) {
            if (nodeImpl.definesExcludedNamespace(s)) {
                return true;
            }
            nodeImpl = (NodeImpl)nodeImpl.getParent();
        }
        return false;
    }

    public void validate() throws TransformerConfigurationException {
    }

    public void preprocess() throws TransformerConfigurationException {
    }

    public void validateSubtree() throws TransformerConfigurationException {
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            }
        }
        try {
            this.validate();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.setValidationError(transformerConfigurationException, 3);
            }
            this.compileError(transformerConfigurationException);
        }
        this.validateChildren();
    }

    protected void validateChildren() throws TransformerConfigurationException {
        for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
            if (!(nodeImpl instanceof StyleElement)) continue;
            ((StyleElement)nodeImpl).validateSubtree();
        }
    }

    protected XSLStyleSheet getPrincipalStyleSheet() {
        XSLStyleSheet xSLStyleSheet = this.getContainingStyleSheet();
        XSLStyleSheet xSLStyleSheet2;
        while ((xSLStyleSheet2 = xSLStyleSheet.getImporter()) != null) {
            xSLStyleSheet = xSLStyleSheet2;
        }
        return xSLStyleSheet;
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        return this.getPrincipalStyleSheet().getPreparedStyleSheet();
    }

    public void checkWithinTemplate() throws TransformerConfigurationException {
        StyleElement styleElement = (StyleElement)this.getParentNode();
        if (!styleElement.mayContainTemplateBody()) {
            this.compileError("Element must only be used within a template body");
        }
    }

    public void checkTopLevel() throws TransformerConfigurationException {
        if (!(this.getParentNode() instanceof XSLStyleSheet)) {
            this.compileError("Element must only be used at top level of stylesheet");
        }
    }

    public void checkNotTopLevel() throws TransformerConfigurationException {
        if (this.getParentNode() instanceof XSLStyleSheet) {
            this.compileError("Element must not be used at top level of stylesheet");
        }
    }

    public void checkEmpty() throws TransformerConfigurationException {
        if (this.getFirstChild() != null) {
            this.compileError("Element must be empty");
        }
    }

    public void reportAbsence(String string) throws TransformerConfigurationException {
        this.compileError("Element must have a \"" + string + "\" attribute");
    }

    public abstract void process(Context var1) throws TransformerException;

    public void processChildren(Context context) throws TransformerException {
        if (context.getController().isTracing()) {
            TraceListener traceListener = context.getController().getTraceListener();
            for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
                traceListener.enter(nodeImpl, context);
                if (nodeImpl.getNodeType() == 3) {
                    nodeImpl.copy(context.getOutputter());
                } else if (nodeImpl instanceof StyleElement) {
                    StyleElement styleElement = (StyleElement)nodeImpl;
                    if (styleElement.validationError != null) {
                        this.fallbackProcessing(styleElement, context);
                    } else {
                        try {
                            context.setStaticContext(styleElement.staticContext);
                            styleElement.process(context);
                        }
                        catch (TransformerException transformerException) {
                            throw styleElement.styleError(transformerException);
                        }
                    }
                }
                traceListener.leave(nodeImpl, context);
            }
        } else {
            for (NodeImpl nodeImpl = (NodeImpl)this.getFirstChild(); nodeImpl != null; nodeImpl = (NodeImpl)nodeImpl.getNextSibling()) {
                if (nodeImpl.getNodeType() == 3) {
                    nodeImpl.copy(context.getOutputter());
                    continue;
                }
                if (!(nodeImpl instanceof StyleElement)) continue;
                StyleElement styleElement = (StyleElement)nodeImpl;
                if (styleElement.validationError != null) {
                    this.fallbackProcessing(styleElement, context);
                    continue;
                }
                try {
                    context.setStaticContext(styleElement.staticContext);
                    styleElement.process(context);
                    continue;
                }
                catch (TransformerException transformerException) {
                    throw styleElement.styleError(transformerException);
                }
            }
        }
    }

    protected void fallbackProcessing(StyleElement styleElement, Context context) throws TransformerException {
        Node node;
        XSLFallback xSLFallback = null;
        for (node = styleElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof XSLFallback)) continue;
            xSLFallback = (XSLFallback)node;
            break;
        }
        if (xSLFallback == null) {
            throw styleElement.styleError(styleElement.validationError);
        }
        boolean bl = context.getController().isTracing();
        while (node != null) {
            if (node instanceof XSLFallback) {
                XSLFallback xSLFallback2 = (XSLFallback)node;
                if (bl) {
                    TraceListener traceListener = context.getController().getTraceListener();
                    traceListener.enter(xSLFallback2, context);
                    xSLFallback2.process(context);
                    traceListener.leave(xSLFallback2, context);
                } else {
                    xSLFallback2.process(context);
                }
            }
            node = node.getNextSibling();
        }
    }

    protected Expression handleSortKeys(Expression expression) throws TransformerConfigurationException {
        Node node;
        int n = 0;
        boolean bl = true;
        for (node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof XSLSort) {
                if (!bl) {
                    this.compileError("An xsl:sort element is not allowed here");
                }
                ++n;
                continue;
            }
            if (this instanceof XSLApplyTemplates && node instanceof XSLWithParam) continue;
            bl = false;
        }
        if (n > 0) {
            SortedSelection sortedSelection = new SortedSelection(expression, n);
            int n2 = 0;
            for (node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof XSLSort)) continue;
                sortedSelection.setSortKey(((XSLSort)node).getSortKeyDefinition(), n2++);
            }
            return sortedSelection;
        }
        return new NodeListExpression(expression);
    }

    protected void findAttributeSets(String string) throws TransformerConfigurationException {
        this.attributeSets = new Vector(5);
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Vector vector = xSLStyleSheet.getTopLevel();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            try {
                n = this.makeNameCode(string2, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
                n = -1;
            }
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                XSLAttributeSet xSLAttributeSet;
                if (!(vector.elementAt(i) instanceof XSLAttributeSet) || (xSLAttributeSet = (XSLAttributeSet)vector.elementAt(i)).getAttributeSetFingerprint() != n) continue;
                this.attributeSets.addElement(xSLAttributeSet);
                bl = true;
            }
            if (bl) continue;
            this.compileError("No attribute-set exists named " + string2);
        }
    }

    protected void processAttributeSets(Context context) throws TransformerException {
        if (this.attributeSets == null) {
            return;
        }
        Controller controller = context.getController();
        for (int i = 0; i < this.attributeSets.size(); ++i) {
            XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)this.attributeSets.elementAt(i);
            Object object = controller.getUserData(xSLAttributeSet, "is-being-expanded");
            if (object != null) {
                throw this.styleError("Circular reference to attribute set");
            }
            controller.setUserData(xSLAttributeSet, "is-being-expanded", "is-being-expanded");
            xSLAttributeSet.expand(context);
            controller.setUserData(xSLAttributeSet, "is-being-expanded", null);
        }
    }

    protected TransformerException styleError(TransformerException transformerException) {
        if (transformerException instanceof StyleException) {
            return transformerException;
        }
        if (transformerException instanceof TerminationException) {
            return transformerException;
        }
        if (transformerException.getLocator() == null) {
            return new TransformerException(transformerException.getMessage(), this, transformerException.getException());
        }
        return transformerException;
    }

    protected TransformerException styleError(String string) {
        return new TransformerException(string, this);
    }

    protected void compileError(TransformerException transformerException) throws TransformerConfigurationException {
        if (transformerException.getLocator() == null) {
            transformerException.setLocator(this);
        }
        PreparedStyleSheet preparedStyleSheet = this.getPreparedStyleSheet();
        try {
            if (preparedStyleSheet == null) {
                throw transformerException;
            }
            preparedStyleSheet.reportError(transformerException);
        }
        catch (TransformerException transformerException2) {
            if (transformerException2 instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2;
            }
            if (transformerException2.getException() instanceof TransformerConfigurationException) {
                throw (TransformerConfigurationException)transformerException2.getException();
            }
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(transformerException);
            transformerConfigurationException.setLocator(this);
            throw transformerConfigurationException;
        }
    }

    protected void compileError(String string) throws TransformerConfigurationException {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        transformerConfigurationException.setLocator(this);
        this.compileError(transformerConfigurationException);
    }

    public boolean isTopLevel() {
        return this.getParentNode() instanceof XSLStyleSheet;
    }

    public Binding bindVariable(int n) throws XPathException {
        Binding binding = this.getVariableBinding(n);
        if (binding == null) {
            throw new XPathException("Variable " + this.getNamePool().getDisplayName(n) + " has not been declared");
        }
        return binding;
    }

    public Binding getVariableBinding(int n) {
        block4: {
            NodeImpl nodeImpl = this;
            NodeImpl nodeImpl2 = this;
            if (!this.isTopLevel()) {
                int n2;
                do {
                    for (nodeImpl = (NodeImpl)nodeImpl.getPreviousSibling(); nodeImpl == null; nodeImpl = (NodeImpl)nodeImpl.getPreviousSibling()) {
                        nodeImpl = (NodeImpl)nodeImpl2.getParent();
                        nodeImpl2 = nodeImpl;
                        if (nodeImpl.getParent() instanceof XSLStyleSheet) break;
                    }
                    if (nodeImpl.getParent() instanceof XSLStyleSheet) break block4;
                } while (!(nodeImpl instanceof Binding) || (n2 = ((Binding)((Object)nodeImpl)).getVariableFingerprint()) != n);
                return (Binding)((Object)nodeImpl);
            }
        }
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Vector vector = xSLStyleSheet.getTopLevel();
        for (int i = vector.size() - 1; i >= 0; --i) {
            int n3;
            Object e = vector.elementAt(i);
            if (!(e instanceof Binding) || e == this || (n3 = ((Binding)e).getVariableFingerprint()) != n) continue;
            return (Binding)e;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Enumeration[] getVariableNames() {
        var1_1 = new Hashtable<E, E>();
        var2_2 = new Hashtable<String, String>();
        var3_3 = this;
        var4_4 /* !! */  = this;
        var5_5 = this.getNamePool();
        if (!this.isTopLevel()) {
            while (true) {
                for (var3_3 = (NodeImpl)var3_3.getPreviousSibling(); var3_3 == null; var3_3 = (NodeImpl)var3_3.getPreviousSibling()) {
                    var3_3 = (NodeImpl)var4_4 /* !! */ .getParent();
                    var4_4 /* !! */  = var3_3;
                    if (var3_3.getParent() instanceof XSLStyleSheet) break;
                }
                if (var3_3.getParentNode() instanceof XSLStyleSheet) break;
                if (!(var3_3 instanceof Binding)) ** continue;
                var6_6 = ((Binding)var3_3).getVariableFingerprint();
                var7_8 = var5_5.getURI(var6_6);
                var8_9 = var5_5.getLocalName(var6_6);
                var9_12 /* !! */  = (String)var7_8 + '^' + var8_9;
                if (var1_1.get(var9_12 /* !! */ ) != null) ** continue;
                var1_1.put(var9_12 /* !! */ , var9_12 /* !! */ );
            }
        }
        var6_7 = this.getPrincipalStyleSheet();
        var7_8 = var6_7.getTopLevel();
        for (var8_10 = 0; var8_10 < var7_8.size(); ++var8_10) {
            var9_12 /* !! */  = var7_8.elementAt(var8_10);
            if (!(var9_12 /* !! */  instanceof Binding) || var9_12 /* !! */  == this) continue;
            var10_13 = ((Binding)var9_12 /* !! */ ).getVariableFingerprint();
            var11_14 = var5_5.getURI(var10_13);
            var12_15 = var5_5.getLocalName(var10_13);
            var13_16 = var11_14 + '^' + var12_15;
            if (var1_1.get(var13_16) != null) continue;
            var2_2.put(var13_16, var13_16);
        }
        var8_11 = new Enumeration[]{var2_2.keys(), var1_1.keys()};
        return var8_11;
    }

    public Function getStyleSheetFunction(int n) {
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        Vector vector = xSLStyleSheet.getTopLevel();
        for (int i = vector.size() - 1; i >= 0; --i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof SAXONFunction) || ((SAXONFunction)e).getFunctionFingerprint() != n) continue;
            StyleSheetFunctionCall styleSheetFunctionCall = new StyleSheetFunctionCall();
            styleSheetFunctionCall.setFunction((SAXONFunction)e);
            return styleSheetFunctionCall;
        }
        return null;
    }
}

