/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.migrator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.migrator.internal.ProgressListener;

public class FileSelector {
    private List<File> javaFileList = new ArrayList<File>();
    ProgressListener pl;

    FileSelector(ProgressListener progressListener) {
        this.pl = progressListener;
    }

    public List<File> selectJavaFilesInFolder(File file) {
        if (file.isDirectory()) {
            this.selectFiles(file);
            return this.javaFileList;
        }
        throw new IllegalArgumentException("[" + file + "] is not a directory");
    }

    private void selectFiles(File file) {
        if (file.isDirectory()) {
            this.pl.onDirectory(file);
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    this.selectFiles(fileArray[i]);
                }
            }
        } else if (file.getName().endsWith(".java")) {
            this.pl.onFileAddition(file);
            this.javaFileList.add(file);
        }
    }
}

