/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.mime4j.codec.CodecUtil;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.message.BinaryBody;
import org.apache.james.mime4j.message.Body;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.Entity;
import org.apache.james.mime4j.message.Header;
import org.apache.james.mime4j.message.Message;
import org.apache.james.mime4j.message.Multipart;
import org.apache.james.mime4j.message.SingleBody;
import org.apache.james.mime4j.parser.Field;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.apache.james.mime4j.util.MimeUtil;

public class MessageWriter {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHES = new byte[]{45, 45};
    public static final MessageWriter DEFAULT = new MessageWriter();

    protected MessageWriter() {
    }

    public void writeBody(Body body, OutputStream out) throws IOException {
        if (body instanceof Message) {
            this.writeEntity((Message)body, out);
        } else if (body instanceof Multipart) {
            this.writeMultipart((Multipart)body, out);
        } else if (body instanceof SingleBody) {
            ((SingleBody)body).writeTo(out);
        } else {
            throw new IllegalArgumentException("Unsupported body class");
        }
    }

    public void writeEntity(Entity entity, OutputStream out) throws IOException {
        Header header = entity.getHeader();
        if (header == null) {
            throw new IllegalArgumentException("Missing header");
        }
        this.writeHeader(header, out);
        Body body = entity.getBody();
        if (body == null) {
            throw new IllegalArgumentException("Missing body");
        }
        boolean binaryBody = body instanceof BinaryBody;
        OutputStream encOut = this.encodeStream(out, entity.getContentTransferEncoding(), binaryBody);
        this.writeBody(body, encOut);
        if (encOut != out) {
            encOut.close();
        }
    }

    public void writeMultipart(Multipart multipart, OutputStream out) throws IOException {
        ContentTypeField contentType = this.getContentType(multipart);
        ByteSequence boundary = this.getBoundary(contentType);
        this.writeBytes(multipart.getPreambleRaw(), out);
        out.write(CRLF);
        for (BodyPart bodyPart : multipart.getBodyParts()) {
            out.write(DASHES);
            this.writeBytes(boundary, out);
            out.write(CRLF);
            this.writeEntity(bodyPart, out);
            out.write(CRLF);
        }
        out.write(DASHES);
        this.writeBytes(boundary, out);
        out.write(DASHES);
        out.write(CRLF);
        this.writeBytes(multipart.getEpilogueRaw(), out);
    }

    public void writeHeader(Header header, OutputStream out) throws IOException {
        for (Field field : header) {
            this.writeBytes(field.getRaw(), out);
            out.write(CRLF);
        }
        out.write(CRLF);
    }

    protected OutputStream encodeStream(OutputStream out, String encoding, boolean binaryBody) throws IOException {
        if (MimeUtil.isBase64Encoding(encoding)) {
            return CodecUtil.wrapBase64(out);
        }
        if (MimeUtil.isQuotedPrintableEncoded(encoding)) {
            return CodecUtil.wrapQuotedPrintable(out, binaryBody);
        }
        return out;
    }

    private ContentTypeField getContentType(Multipart multipart) {
        Entity parent = multipart.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Missing parent entity in multipart");
        }
        Header header = parent.getHeader();
        if (header == null) {
            throw new IllegalArgumentException("Missing header in parent entity");
        }
        ContentTypeField contentType = (ContentTypeField)header.getField("Content-Type");
        if (contentType == null) {
            throw new IllegalArgumentException("Content-Type field not specified");
        }
        return contentType;
    }

    private ByteSequence getBoundary(ContentTypeField contentType) {
        String boundary = contentType.getBoundary();
        if (boundary == null) {
            throw new IllegalArgumentException("Multipart boundary not specified");
        }
        return ContentUtil.encode(boundary);
    }

    private void writeBytes(ByteSequence byteSequence, OutputStream out) throws IOException {
        if (byteSequence instanceof ByteArrayBuffer) {
            ByteArrayBuffer bab = (ByteArrayBuffer)byteSequence;
            out.write(bab.buffer(), 0, bab.length());
        } else {
            out.write(byteSequence.toByteArray());
        }
    }
}

