/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.api.Api;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.cloud.OverseerSolrResponse;
import org.apache.solr.cloud.OverseerTaskQueue;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ConfigSetParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.ConfigSetsHandlerApi;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSetsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final CoreContainer coreContainer;
    public static long DEFAULT_ZK_TIMEOUT = 300000L;
    private final ConfigSetsHandlerApi configSetsHandlerApi = new ConfigSetsHandlerApi(this);

    public ConfigSetsHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ConfigSetParams.ConfigSetAction action;
        if (this.coreContainer == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        if (!this.coreContainer.isZooKeeperAware()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr instance is not running in SolrCloud mode.");
        }
        SolrParams params = req.getParams();
        String a = params.get("action");
        if (a != null) {
            action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown action: " + a);
            }
            if (action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                this.handleConfigUploadRequest(req, rsp);
                return;
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "action is a required param");
        }
        this.invokeAction(req, rsp, action);
        rsp.setHttpCaching(false);
    }

    void invokeAction(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetParams.ConfigSetAction action) throws Exception {
        ConfigSetOperation operation = ConfigSetOperation.get(action);
        log.info("Invoked ConfigSet Action :{} with params {} ", (Object)action.toLower(), (Object)req.getParamString());
        Map<String, Object> result = operation.call(req, rsp, this);
        this.sendToZk(rsp, operation, result);
    }

    protected void sendToZk(SolrQueryResponse rsp, ConfigSetOperation operation, Map<String, Object> result) throws KeeperException, InterruptedException {
        if (result != null) {
            result.put("operation", "configsets:" + operation.action.toLower());
            ZkNodeProps props = new ZkNodeProps(result);
            this.handleResponse(operation.action.toLower(), props, rsp, DEFAULT_ZK_TIMEOUT);
        }
    }

    private void handleConfigUploadRequest(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String configPathInZk;
        if (!"true".equals(System.getProperty("configset.upload.enabled", "true"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Configset upload feature is disabled. To enable this, start Solr with '-Dconfigset.upload.enabled=true'.");
        }
        String configSetName = req.getParams().get("name");
        if (StringUtils.isBlank((String)configSetName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration name should be provided in the \"name\" parameter");
        }
        SolrZkClient zkClient = this.coreContainer.getZkController().getZkClient();
        if (zkClient.exists(configPathInZk = "/configs/" + configSetName, true).booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The configuration " + configSetName + " already exists in zookeeper");
        }
        Iterator<ContentStream> contentStreamsIterator = req.getContentStreams().iterator();
        if (!contentStreamsIterator.hasNext()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No stream found for the config data to be uploaded");
        }
        InputStream inputStream = contentStreamsIterator.next().getStream();
        boolean trusted = this.getTrusted(req);
        zkClient.makePath(configPathInZk, ("{\"trusted\": " + Boolean.toString(trusted) + "}").getBytes(StandardCharsets.UTF_8), true);
        ZipInputStream zis = new ZipInputStream(inputStream, StandardCharsets.UTF_8);
        ZipEntry zipEntry = null;
        while ((zipEntry = zis.getNextEntry()) != null) {
            String filePathInZk = configPathInZk + "/" + zipEntry.getName();
            if (zipEntry.isDirectory()) {
                zkClient.makePath(filePathInZk, true);
                continue;
            }
            this.createZkNodeIfNotExistsAndSetData(zkClient, filePathInZk, IOUtils.toByteArray((InputStream)zis));
        }
        zis.close();
    }

    boolean getTrusted(SolrQueryRequest req) {
        AuthenticationPlugin authcPlugin = this.coreContainer.getAuthenticationPlugin();
        log.info("Trying to upload a configset. authcPlugin: {}, user principal: {}", (Object)authcPlugin, (Object)req.getUserPrincipal());
        return authcPlugin != null && req.getUserPrincipal() != null;
    }

    private void createZkNodeIfNotExistsAndSetData(SolrZkClient zkClient, String filePathInZk, byte[] data) throws Exception {
        if (!zkClient.exists(filePathInZk, true).booleanValue()) {
            zkClient.create(filePathInZk, data, CreateMode.PERSISTENT, true);
        } else {
            zkClient.setData(filePathInZk, data, true);
        }
    }

    private void handleResponse(String operation, ZkNodeProps m, SolrQueryResponse rsp, long timeout) throws KeeperException, InterruptedException {
        long time = System.nanoTime();
        OverseerTaskQueue.QueueEvent event = this.coreContainer.getZkController().getOverseerConfigSetQueue().offer(Utils.toJSON((Object)m), timeout);
        if (event.getBytes() != null) {
            SolrResponse response = SolrResponse.deserialize((byte[])event.getBytes());
            rsp.getValues().addAll(response.getResponse());
            SimpleOrderedMap exp = (SimpleOrderedMap)response.getResponse().get("exception");
            if (exp != null) {
                Integer code = (Integer)exp.get("rspCode");
                rsp.setException((Exception)((Object)new SolrException(code != null && code != -1 ? SolrException.ErrorCode.getErrorCode((int)code) : SolrException.ErrorCode.SERVER_ERROR, (String)exp.get("msg"))));
            }
        } else {
            if (System.nanoTime() - time >= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset time out:" + timeout / 1000L + "s");
            }
            if (event.getWatchedEvent() != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset error [Watcher fired on path: " + event.getWatchedEvent().getPath() + " state: " + event.getWatchedEvent().getState() + " type " + event.getWatchedEvent().getType() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, operation + " the configset unknown case");
        }
    }

    private static Map<String, Object> copyPropertiesWithPrefix(SolrParams params, Map<String, Object> props, String prefix) {
        Iterator iter = params.getParameterNamesIterator();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            if (!param.startsWith(prefix)) continue;
            props.put(param, params.get(param));
        }
        return props;
    }

    @Override
    public String getDescription() {
        return "Manage SolrCloud ConfigSets";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.ADMIN;
    }

    @Override
    public Collection<Api> getApis() {
        return this.configSetsHandlerApi.getApis();
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        String a = ctx.getParams().get("action");
        if (a != null) {
            ConfigSetParams.ConfigSetAction action = ConfigSetParams.ConfigSetAction.get((String)a);
            if (action == ConfigSetParams.ConfigSetAction.CREATE || action == ConfigSetParams.ConfigSetAction.DELETE || action == ConfigSetParams.ConfigSetAction.UPLOAD) {
                return PermissionNameProvider.Name.CONFIG_EDIT_PERM;
            }
            if (action == ConfigSetParams.ConfigSetAction.LIST) {
                return PermissionNameProvider.Name.CONFIG_READ_PERM;
            }
        }
        return null;
    }

    static enum ConfigSetOperation {
        CREATE_OP(ConfigSetParams.ConfigSetAction.CREATE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                Map props = req.getParams().required().getAll(null, new String[]{"name", "baseConfigSet"});
                return ConfigSetsHandler.copyPropertiesWithPrefix(req.getParams(), props, "configSetProp.");
            }
        }
        ,
        DELETE_OP(ConfigSetParams.ConfigSetAction.DELETE){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                return req.getParams().required().getAll(null, new String[]{"name"});
            }
        }
        ,
        LIST_OP(ConfigSetParams.ConfigSetAction.LIST){

            @Override
            Map<String, Object> call(SolrQueryRequest req, SolrQueryResponse rsp, ConfigSetsHandler h) throws Exception {
                NamedList results = new NamedList();
                SolrZkClient zk = h.coreContainer.getZkController().getZkStateReader().getZkClient();
                ZkConfigManager zkConfigManager = new ZkConfigManager(zk);
                List configSetsList = zkConfigManager.listConfigs();
                results.add("configSets", (Object)configSetsList);
                OverseerSolrResponse response = new OverseerSolrResponse(results);
                rsp.getValues().addAll(response.getResponse());
                return null;
            }
        };

        ConfigSetParams.ConfigSetAction action;

        private ConfigSetOperation(ConfigSetParams.ConfigSetAction action) {
            this.action = action;
        }

        abstract Map<String, Object> call(SolrQueryRequest var1, SolrQueryResponse var2, ConfigSetsHandler var3) throws Exception;

        public static ConfigSetOperation get(ConfigSetParams.ConfigSetAction action) {
            for (ConfigSetOperation op : ConfigSetOperation.values()) {
                if (op.action != action) continue;
                return op;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such action" + action);
        }
    }
}

