"use strict";
var linter = require("./linter");
var wrapperHelper = require("../wrapped-ast/wrapperHelper08");
var messageRegistry = require("../../../resources/errorMessages");
function escapeUri(u) {
    var ss = "";
    var level = 0;
    for (var i = 0; i < u.length; i++) {
        var c = u.charAt(i);
        if (level == 0) {
            ss = ss + c;
        }
        if (c == '{') {
            level++;
        }
        if (c == '}') {
            level--;
        }
    }
    return ss;
}
var OverloadingValidator = /** @class */ (function () {
    function OverloadingValidator() {
        this.holder = {};
        this.conflicting = {};
    }
    OverloadingValidator.prototype.validateApi = function (q, v) {
        var _this = this;
        q.resources().forEach(function (x) {
            _this.acceptResource(x);
            x.resources().forEach(function (y) { return _this.acceptResource(y); });
        });
        for (var c in this.conflicting) {
            var ms = this.conflicting[c];
            var notPushed = ms;
            if (notPushed.length > 1) {
                notPushed.forEach(function (m) {
                    v.accept(linter.createIssue1(messageRegistry.RESOURCES_SHARE_SAME_URI, {}, m.highLevel(), false));
                });
            }
        }
    };
    OverloadingValidator.prototype.acceptResource = function (x) {
        var uri = escapeUri(wrapperHelper.absoluteUri(x));
        var pos = this.holder[uri];
        if (!pos) {
            pos = [];
            this.holder[uri] = pos;
        }
        pos.push(x);
        if (pos.length > 1) {
            this.conflicting[uri] = pos;
        }
    };
    return OverloadingValidator;
}());
module.exports = OverloadingValidator;
//# sourceMappingURL=overloadingValidator08.js.map