"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ZSchema = require('z-schema');
var JSONValidator = /** @class */ (function () {
    function JSONValidator() {
        this.validator = new ZSchema({
            ignoreUnknownFormats: true
        });
    }
    JSONValidator.prototype.setRemoteReference = function (reference, content) {
        this.validator.setRemoteReference(reference, content);
    };
    JSONValidator.prototype.validateSchema = function (jsonSchema) {
        this.validator.validateSchema(jsonSchema);
    };
    JSONValidator.prototype.getMissingRemoteReferences = function () {
        return this.validator.getMissingRemoteReferences();
    };
    JSONValidator.prototype.isResourceLoaded = function (reference) {
        return this.validator.cache[reference] == null ? false : true;
    };
    JSONValidator.prototype.validate = function (content, schema) {
        this.validator.validate(content, schema);
    };
    JSONValidator.prototype.getLastErrors = function () {
        return this.validator.getLastErrors();
    };
    return JSONValidator;
}());
exports.JSONValidator = JSONValidator;
//# sourceMappingURL=index.js.map