/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.gosen;

import com.ibm.icu.text.Normalizer2;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.charfilter.BaseCharFilter;
import org.apache.lucene.analysis.util.RollingCharBuffer;

public class GosenNormalizerCharFilter
extends BaseCharFilter {
    private static final int VOICED_SOUND_MARK_CONVERT_OFFSET = 2;
    private static final int MAX_BUFFER_SIZE = 512;
    private static char[] specialCaseChars = new char[10];
    public static String DEFAULT_NORM_FORM;
    private final Normalizer2 normalizer;
    private final RollingCharBuffer buffer = new RollingCharBuffer();
    private Reader normalizedInput;

    public GosenNormalizerCharFilter(Reader reader) {
        this(reader, DEFAULT_NORM_FORM, Normalizer2.Mode.COMPOSE);
    }

    public GosenNormalizerCharFilter(Reader reader, String name, Normalizer2.Mode mode) {
        super(reader);
        this.normalizer = Normalizer2.getInstance(null, (String)name, (Normalizer2.Mode)mode);
        this.buffer.reset(this.input);
    }

    private static char[] replaceSpecialCharacters(char[] inBuffer, int len) {
        char[] outBuffer = new char[512];
        for (int i = 0; i < len; ++i) {
            char c = inBuffer[i];
            outBuffer[i] = c == specialCaseChars[0] || c == specialCaseChars[1] ? (char)(c - 2) : inBuffer[i];
        }
        return outBuffer;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.normalizedInput == null) {
            StringBuilder sbBuffer = new StringBuilder();
            char[] temp = new char[512];
            int cnt = this.input.read(temp);
            while (cnt > 0) {
                sbBuffer.append(GosenNormalizerCharFilter.replaceSpecialCharacters(temp, cnt), 0, cnt);
                cnt = this.input.read(temp);
            }
            this.normalizedInput = new StringReader(this.normalizer.normalize((CharSequence)sbBuffer.toString()));
        }
        return this.normalizedInput.read(cbuf, off, len);
    }

    protected int correct(int correctOffset) {
        return Math.max(0, super.correct(correctOffset));
    }

    static {
        GosenNormalizerCharFilter.specialCaseChars[0] = 12443;
        GosenNormalizerCharFilter.specialCaseChars[1] = 12444;
        DEFAULT_NORM_FORM = "nfkc";
    }
}

